/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.lib.util.IntIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntHashMap
implements Cloneable,
Serializable {
    static final long serialVersionUID = 2L;
    private transient Entry[] _table;
    private transient int _count;
    private int _threshold;
    private float _loadFactor;
    private transient int _modCount = 0;
    private transient SerializableSet _entrySet = null;
    private transient SerializableCollection _values = null;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this._loadFactor = loadFactor;
        this._table = new Entry[initialCapacity];
        this._threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this(21, 0.75f);
    }

    public IntHashMap(IntHashMap t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public int size() {
        return this._count;
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public boolean containsValue(Object value) {
        Entry[] tab = this._table;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (e._value == null) {
                        return true;
                    }
                    e = e._next;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e._value)) {
                        return true;
                    }
                    e = e._next;
                }
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public Object get(int key) {
        Entry[] tab = this._table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e._key == key) {
                return e._value;
            }
            e = e._next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this._table.length;
        Entry[] oldMap = this._table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this._modCount;
        this._threshold = (int)((float)newCapacity * this._loadFactor);
        this._table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old._next;
                int index = (e._key & Integer.MAX_VALUE) % newCapacity;
                e._next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object put(int key, Object value) {
        Entry[] tab = this._table;
        int index = 0;
        index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e._key == key) {
                Object old = e._value;
                e._value = value;
                return old;
            }
            e = e._next;
        }
        ++this._modCount;
        if (this._count >= this._threshold) {
            this.rehash();
            tab = this._table;
            index = (key & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(key, value, tab[index]);
        ++this._count;
        return null;
    }

    public Object remove(int key) {
        Entry[] tab = this._table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e._key == key) {
                ++this._modCount;
                if (prev != null) {
                    prev._next = e._next;
                } else {
                    tab[index] = e._next;
                }
                --this._count;
                Object oldValue = e._value;
                e._value = null;
                return oldValue;
            }
            prev = e;
            e = e._next;
        }
        return null;
    }

    public void putAll(IntHashMap t) {
        for (Entry e : t.entrySet()) {
            this.put(e._key, e.getValue());
        }
    }

    public void clear() {
        Entry[] tab = this._table;
        ++this._modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this._count = 0;
    }

    public Object clone() {
        try {
            IntHashMap t = (IntHashMap)super.clone();
            t._table = new Entry[this._table.length];
            int i = this._table.length;
            while (i-- > 0) {
                t._table[i] = this._table[i] != null ? (Entry)this._table[i].clone() : null;
            }
            t._entrySet = null;
            t._values = null;
            t._modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public IntIterator keyIterator() {
        return new IntHashKeyIterator();
    }

    public int[] keys() {
        int[] keys = new int[this._count];
        Iterator it = this.entrySet().iterator();
        for (int i = 0; i < keys.length && it.hasNext(); ++i) {
            keys[i] = ((Entry)it.next())._key;
        }
        return keys;
    }

    public Collection values() {
        if (this._values == null) {
            this._values = new SerializableCollection();
        }
        return this._values;
    }

    public Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new SerializableSet();
        }
        return this._entrySet;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntHashMap)) {
            return false;
        }
        IntHashMap t = (IntHashMap)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Entry e : this.entrySet()) {
                int key = e._key;
                Object value = e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Entry e = (Entry)i.next();
            sbuf.append(e._key).append("=").append(e.getValue());
            hasNext = i.hasNext();
            if (!hasNext) continue;
            sbuf.append(", ");
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this._table.length);
        s.writeInt(this._count);
        for (int index = this._table.length - 1; index >= 0; --index) {
            Entry entry = this._table[index];
            while (entry != null) {
                s.writeInt(entry._key);
                s.writeObject(entry._value);
                entry = entry._next;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this._table = new Entry[numBuckets];
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            int key = s.readInt();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    private class IntHashKeyIterator
    implements IntIterator {
        Entry[] _table;
        int _index;
        Entry _entry;
        Entry _lastReturned;
        private int _expectedModCount;

        private IntHashKeyIterator() {
            this._table = IntHashMap.this._table;
            this._index = this._table.length;
            this._entry = null;
            this._lastReturned = null;
            this._expectedModCount = IntHashMap.this._modCount;
        }

        @Override
        public boolean hasNext() {
            while (this._entry == null && this._index > 0) {
                this._entry = this._table[--this._index];
            }
            return this._entry != null;
        }

        @Override
        public int next() {
            if (IntHashMap.this._modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            while (this._entry == null && this._index > 0) {
                this._entry = this._table[--this._index];
            }
            if (this._entry != null) {
                Entry e = this._lastReturned = this._entry;
                this._entry = e._next;
                return e._key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.this._modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = IntHashMap.this._table;
            int index = (this._lastReturned._key & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == this._lastReturned) {
                    IntHashMap.this._modCount++;
                    ++this._expectedModCount;
                    if (prev == null) {
                        tab[index] = e._next;
                    } else {
                        prev._next = e._next;
                    }
                    IntHashMap.this._count--;
                    this._lastReturned = null;
                    return;
                }
                prev = e;
                e = e._next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private class IntHashIterator
    implements Iterator {
        Entry[] _table;
        int _index;
        Entry _entry;
        Entry _lastReturned;
        int _type;
        private int _expectedModCount;

        IntHashIterator(int type) {
            this._table = IntHashMap.this._table;
            this._index = this._table.length;
            this._entry = null;
            this._lastReturned = null;
            this._expectedModCount = IntHashMap.this._modCount;
            this._type = type;
        }

        @Override
        public boolean hasNext() {
            while (this._entry == null && this._index > 0) {
                this._entry = this._table[--this._index];
            }
            return this._entry != null;
        }

        public Object next() {
            if (IntHashMap.this._modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            while (this._entry == null && this._index > 0) {
                this._entry = this._table[--this._index];
            }
            if (this._entry != null) {
                Entry e = this._lastReturned = this._entry;
                this._entry = e._next;
                return this._type == 1 ? e._value : e;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.this._modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = IntHashMap.this._table;
            int index = (this._lastReturned._key & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == this._lastReturned) {
                    IntHashMap.this._modCount++;
                    ++this._expectedModCount;
                    if (prev == null) {
                        tab[index] = e._next;
                    } else {
                        prev._next = e._next;
                    }
                    IntHashMap.this._count--;
                    this._lastReturned = null;
                    return;
                }
                prev = e;
                e = e._next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry
    implements Map.Entry,
    IntIterator.IntMapEntry {
        int _key;
        Object _value;
        Entry _next;

        Entry(int key, Object value, Entry next) {
            this._key = key;
            this._value = value;
            this._next = next;
        }

        protected Object clone() {
            return new Entry(this._key, this._value, this._next == null ? null : (Entry)this._next.clone());
        }

        public Object getKey() {
            return new Integer(this._key);
        }

        @Override
        public int getIntKey() {
            return this._key;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this._key == e._key && (this._value == null ? e.getValue() == null : this._value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this._key ^ (this._value == null ? 0 : this._value.hashCode());
        }

        public String toString() {
            return String.valueOf(this._key) + "=" + this._value;
        }
    }

    private class SerializableSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private SerializableSet() {
        }

        @Override
        public Iterator iterator() {
            return new IntHashIterator(2);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry[] tab = IntHashMap.this._table;
            int hash = key == null ? 0 : key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e._key == hash && e.equals(entry)) {
                    return true;
                }
                e = e._next;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry[] tab = IntHashMap.this._table;
            int hash = key == null ? 0 : key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e._key == hash && e.equals(entry)) {
                    IntHashMap.this._modCount++;
                    if (prev != null) {
                        prev._next = e._next;
                    } else {
                        tab[index] = e._next;
                    }
                    IntHashMap.this._count--;
                    e._value = null;
                    return true;
                }
                prev = e;
                e = e._next;
            }
            return false;
        }

        @Override
        public int size() {
            return IntHashMap.this._count;
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class SerializableCollection
    extends AbstractCollection
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private SerializableCollection() {
        }

        @Override
        public Iterator iterator() {
            return new IntHashIterator(1);
        }

        @Override
        public int size() {
            return IntHashMap.this._count;
        }

        @Override
        public boolean contains(Object o) {
            return IntHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }
}

