/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util.channel;

import com.cisco.dcbu.lib.util.channel.Channel;
import com.cisco.dcbu.lib.util.channel.ChannelConsumer;
import com.cisco.dcbu.lib.util.channel.ChannelController;
import com.cisco.dcbu.lib.util.channel.ChannelControllerManager;
import com.cisco.dcbu.lib.util.channel.ChannelException;
import com.cisco.dcbu.lib.util.channel.ChannelFilter;
import com.cisco.dcbu.lib.util.channel.ChannelListener;
import com.cisco.dcbu.lib.util.channel.ChannelVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ChannelImpl<E>
implements Channel<E>,
Runnable {
    private String _name;
    private LinkedBlockingQueue<E> _queue = new LinkedBlockingQueue();
    private ThreadPoolExecutor _executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), new DispatchRejectHandler());
    private ChannelControllerManager _chCtrlMgr = new ChannelControllerManager();
    private LinkedList<FilterConsumer<E>> _consumers = new LinkedList();
    private List<FilterConsumer<E>> _consumersCopy = Collections.emptyList();
    private LinkedList<ChannelListener<E>> _listeners = new LinkedList();
    private List<ChannelListener<E>> _listenersCopy = Collections.emptyList();
    Logger _log = Logger.getLogger((String)"channel.eventchannel");

    public ChannelImpl() {
        this("ChannelImpl", null);
    }

    public ChannelImpl(String name) {
        this(name, null);
    }

    public ChannelImpl(String name, ThreadGroup tg) {
        this.setName(name);
        Thread t = new Thread(tg, this);
        if (name != null) {
            t.setName(name);
        }
        t.start();
    }

    @Override
    public void run() {
        E obj = null;
        while (true) {
            try {
                obj = this._queue.take();
            }
            catch (InterruptedException ie) {
                this._log.info((Object)(this + " stopped"));
                break;
            }
            try {
                this.dispatch(obj);
            }
            catch (Throwable t) {
                this._log.log((Priority)Level.ERROR, (Object)("dispatching error: " + obj), t);
            }
        }
    }

    private void dispatch(E obj) {
        try {
            this.preDispatching(obj);
        }
        catch (Throwable t) {
            this._log.log((Priority)Level.ERROR, (Object)("pre-dispatching error: " + obj), t);
        }
        for (ChannelListener<E> channelListener : this._listenersCopy) {
            try {
                channelListener.dequeued(this, obj);
            }
            catch (Throwable t) {
                this._log.log((Priority)Level.ERROR, (Object)("notifying listener " + channelListener + " error: " + obj), t);
            }
        }
        for (FilterConsumer filterConsumer : this._consumersCopy) {
            try {
                filterConsumer.handle(obj);
            }
            catch (Throwable t) {
                this._log.log((Priority)Level.ERROR, (Object)("notifying consumer " + filterConsumer + " error: " + obj), t);
            }
        }
        try {
            this.postDispatching(obj);
        }
        catch (Throwable t) {
            this._log.log((Priority)Level.ERROR, (Object)("post-dispatching error: " + obj), t);
        }
    }

    protected void preDispatching(Object obj) {
    }

    protected void postDispatching(Object obj) {
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public Logger getLogger() {
        return this._log;
    }

    @Override
    public void setLogger(Logger log) {
        this._log = log;
    }

    @Override
    public void addController(ChannelController<E> cc) {
        if (cc == null) {
            throw new IllegalArgumentException("ChannelController cannot be null");
        }
        this._chCtrlMgr.add(cc);
    }

    @Override
    public List<ChannelController<E>> getAllControllers() {
        return this._chCtrlMgr.getAllControllers();
    }

    @Override
    public void removeController(ChannelController<E> cc) {
        this._chCtrlMgr.removeController(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ChannelListener<E> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("ChannelListener cannot be null");
        }
        LinkedList<ChannelListener<E>> linkedList = this._listeners;
        synchronized (linkedList) {
            if (!this._listeners.contains(cl)) {
                this._listeners.add(cl);
                this._listenersCopy = Collections.unmodifiableList((List)this._listeners.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ChannelListener<E> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("ChannelListener cannot be null");
        }
        LinkedList<ChannelListener<E>> linkedList = this._listeners;
        synchronized (linkedList) {
            if (this._listeners.remove(cl)) {
                this._listenersCopy = Collections.unmodifiableList((List)this._listeners.clone());
            }
        }
    }

    @Override
    public List<ChannelListener<E>> getAllListeners() {
        return this._listenersCopy;
    }

    @Override
    public void addConsumer(ChannelConsumer<E> cc) {
        this.addConsumer(cc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(ChannelConsumer<E> cc, ChannelFilter<E> cf) {
        if (cc == null) {
            throw new IllegalArgumentException("ChannelConsumer cannot be null");
        }
        LinkedList<FilterConsumer<E>> linkedList = this._consumers;
        synchronized (linkedList) {
            FilterConsumer<E> fc = this.findFilterConsumer(cc);
            if (fc == null || fc._filter != cf) {
                if (fc == null) {
                    fc = new FilterConsumer<E>(cc, cf);
                    this._consumers.add(fc);
                    this._consumersCopy = Collections.unmodifiableList((List)this._consumers.clone());
                    this._executor.setMaximumPoolSize(this._consumers.size() + 1);
                } else {
                    fc._filter = cf;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ChannelConsumer<E> cc) {
        if (cc == null) {
            throw new IllegalArgumentException("ChannelConsumer cannot be null");
        }
        LinkedList<FilterConsumer<E>> linkedList = this._consumers;
        synchronized (linkedList) {
            FilterConsumer<E> fc = this.findFilterConsumer(cc);
            if (fc != null) {
                this._consumers.remove(fc);
                this._consumersCopy = Collections.unmodifiableList((List)this._consumers.clone());
                this._executor.setMaximumPoolSize(this._consumers.size() + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterConsumer<E> findFilterConsumer(ChannelConsumer<E> cc) {
        LinkedList<FilterConsumer<E>> linkedList = this._consumers;
        synchronized (linkedList) {
            for (FilterConsumer filterConsumer : this._consumers) {
                if (filterConsumer._consumer != cc) continue;
                return filterConsumer;
            }
        }
        return null;
    }

    @Override
    public List<ChannelConsumer<E>> getAllConsumers() {
        List list;
        if (this._consumersCopy.isEmpty()) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList<ChannelConsumer<E>>(this._consumersCopy.size());
            for (FilterConsumer<E> fc : this._consumersCopy) {
                list.add(fc._consumer);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(E obj) throws ChannelException, ClassCastException {
        this.validate(obj);
        try {
            this._chCtrlMgr.processQueue(obj);
        }
        catch (ChannelVetoException cve) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)"Controllers veto the the queueing of object", (Throwable)cve);
            }
            for (ChannelListener<E> cl : this._listenersCopy) {
                cl.vetoed(this, cve);
            }
            ChannelException ce = new ChannelException(this, cve.getMessage());
            ce.setVetoed(true);
            throw ce;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " queueing " + obj));
        }
        LinkedBlockingQueue<E> cve = this._queue;
        synchronized (cve) {
            this._queue.add(obj);
        }
        for (ChannelListener<E> cl : this._listenersCopy) {
            try {
                cl.queued(this, obj);
            }
            catch (Throwable t) {
                this._log.error((Object)(cl + "queuing error"), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        int i;
        LinkedBlockingQueue<E> linkedBlockingQueue = this._queue;
        synchronized (linkedBlockingQueue) {
            i = this._queue.size();
        }
        return i;
    }

    public String toString() {
        return this._name;
    }

    protected void validate(E obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Queued object cannot be null");
        }
    }

    class FilterConsumer<E>
    implements Runnable {
        ChannelConsumer<E> _consumer;
        ChannelFilter<E> _filter;
        LinkedBlockingQueue<E> _handoffQ = new LinkedBlockingQueue();
        AtomicBoolean _running = new AtomicBoolean(false);

        FilterConsumer(ChannelConsumer<E> consumer, ChannelFilter<E> filter) {
            this._consumer = consumer;
            this._filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handle(E entry) {
            block6: {
                try {
                    if (this._filter != null && !this._filter.accept(entry)) break block6;
                    this._handoffQ.add(entry);
                    AtomicBoolean atomicBoolean = this._running;
                    synchronized (atomicBoolean) {
                        if (!this._running.get()) {
                            ChannelImpl.this._executor.submit(this);
                            this._running.set(true);
                        }
                    }
                }
                catch (Throwable t) {
                    ChannelImpl.this._log.log((Priority)Level.ERROR, (Object)(this._consumer + " handling error:" + entry), t);
                }
            }
        }

        @Override
        public void run() {
            Object obj = null;
            while (true) {
                try {
                    while (true) {
                        obj = this._handoffQ.take();
                        this._consumer.consume(ChannelImpl.this, obj);
                    }
                }
                catch (NoSuchElementException ex) {
                }
                catch (Throwable t) {
                    ChannelImpl.this._log.log((Priority)Level.ERROR, (Object)(this._consumer + " consuming error: " + obj), t);
                    continue;
                }
                break;
            }
            this._running.set(false);
        }
    }

    class DispatchRejectHandler
    implements RejectedExecutionHandler {
        DispatchRejectHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            ChannelImpl.this._log.error((Object)(this + " dispatch execution rejected: "));
        }
    }
}

