/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lic.share;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class JnlpLauncher {
    private static final String HTTP_PORT = "8080";
    private static final String HTTP_PROTOCOL = "http";
    private static final String APP_CONTEXT = "/dcnm-client";
    private static final String SERVLET = "/DcnmJnlpReadServlet";
    private static final String FILE_SEPARATOR = File.separator;
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String DCNM_MODIFIED_JNLP = "cl_dcnm.jnlp";
    private static final String JWS_EXEC = "javaws ";
    private static final String HOST_IP = "169.254.25.129";
    private static final String REPLY_PORT = "8182";

    public JnlpLauncher(String hostIP, String replyPort, String token) {
        this.launch(hostIP, replyPort, token);
    }

    private void launch(String hostIP, String replyPort, String token) {
        String jnlpPath = this.generateJNLPfile(hostIP, replyPort, token);
        this.launchClient(jnlpPath);
    }

    private String contructURL(String hostIP) {
        String url = "http://" + hostIP + ":" + HTTP_PORT + APP_CONTEXT + SERVLET;
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateJNLPfile(String hostIP, String replyPort, String tmpToken) {
        String path = "";
        URL url = null;
        BufferedReader in = null;
        FileOutputStream fos = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            String SERVLET_URL = this.contructURL(hostIP);
            String QUERY_STRING = "?replyPort=" + replyPort + "&tmpToken=" + tmpToken;
            System.out.println("URL  " + SERVLET_URL + QUERY_STRING);
            url = new URL(SERVLET_URL + QUERY_STRING);
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            path = System.getProperty(JAVA_IO_TMPDIR) + FILE_SEPARATOR + DCNM_MODIFIED_JNLP;
            System.out.println(path);
            fos = new FileOutputStream(new File(path));
            fos.write(sb.toString().getBytes());
            fos.flush();
            String string = path;
            return string;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    private void launchClient(String jnlpPath) {
        System.out.println("launching  file " + jnlpPath);
        if (jnlpPath != "") {
            String cmd = JWS_EXEC + jnlpPath;
            try {
                Process p = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println(" ===== JNLP file path unknown ====");
        }
    }

    public static void main(String[] args) {
        new JnlpLauncher(HOST_IP, REPLY_PORT, "xset556");
    }
}

