/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.dialogs.physical;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dmdb.andiamo.elements.SatChassisIf;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.portland.dmdb.N5KDmSystem;

public abstract class EditSatPhysicalTable
extends EditTable {
    protected int[][] _inventoryRanges = new int[0][0];
    protected int _inventoryCurr;
    protected static final int START = 0;
    protected static final int STOP = 1;

    public EditSatPhysicalTable(String[] vars) {
        super(vars);
    }

    public abstract int[][] getCoreSwitchRanges();

    public int[][] getSatSwitchRanges() {
        return this.getCoreSwitchRanges();
    }

    public PhysicalElement[] getSelectedChassisOrCoreSwitchChassis() {
        return N5KDmSystem.getSelectedChassisOrCoreSwitchChassis();
    }

    public void buildRanges() {
        int rangeCount = this.getCoreSwitchRanges().length;
        PhysicalElement[] elems = new PhysicalElement[]{this.getSelectedChassisOrCoreSwitchChassis()[0]};
        this._inventoryRanges = new int[elems.length * rangeCount][];
        for (int i = 0; i < elems.length; ++i) {
            PhysicalElement elem = elems[i];
            int satSwitchId = elem instanceof SatChassisIf ? ((SatChassisIf)((Object)elem)).getSatSwitchId() : 0;
            int satOffset = FRUConstants.getSatelliteSwitchComponentOffset(satSwitchId);
            int[][] ranges = elem instanceof SatChassisIf ? this.getSatSwitchRanges() : this.getCoreSwitchRanges();
            for (int j = 0; j < rangeCount; ++j) {
                this._inventoryRanges[i * rangeCount + j] = new int[]{ranges[j][0] + satOffset, ranges[j][1] + satOffset};
            }
        }
    }

    @Override
    protected void get() {
        this._inventoryCurr = 0;
        super.get();
    }

    @Override
    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        VarBindList vbl = pdu.getVariables();
        int[] oid = vbl.get(0).getOid().getValue();
        if (oid.length > this.getFirstOid().length) {
            int currIndex = oid[oid.length - 1];
            if (currIndex < this._inventoryRanges[this._inventoryCurr][0]) {
                this.setNextIndex(pdu, this._inventoryRanges[this._inventoryCurr][0] - 1);
            } else if (currIndex >= this._inventoryRanges[this._inventoryCurr][1]) {
                ++this._inventoryCurr;
                if (this._inventoryCurr < this._inventoryRanges.length && currIndex != this._inventoryRanges[this._inventoryCurr][0]) {
                    this.setNextIndex(pdu, this._inventoryRanges[this._inventoryCurr][0] - 1);
                }
            }
        }
        super.sendGetPdu(pdu);
    }

    private SnmpPDU setNextIndex(SnmpPDU pdu, int index) {
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            int[] oid = pdu.getVariables().get(i).getOid().getValue();
            oid[oid.length - 1] = index;
        }
        return pdu;
    }

    @Override
    protected boolean isSkip(SnmpPDU pdu) {
        int[] oid = pdu.getVariables().get(0).getOid().getValue();
        int currIndex = oid[oid.length - 1];
        for (int i = 0; i < this._inventoryRanges.length; ++i) {
            if (currIndex < this._inventoryRanges[i][0] || currIndex > this._inventoryRanges[i][1]) continue;
            this._inventoryCurr = i;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (super.isEnd(req, vb)) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        return oid[oid.length - 1] > this._inventoryRanges[this._inventoryRanges.length - 1][1];
    }
}

