/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client;

import com.cisco.dcbu.sm.client.ServerConnection;
import com.cisco.dcbu.sm.common.rif.SanException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import javax.ejb.NoSuchEJBException;
import org.apache.log4j.Logger;

class ProxyInvocationHandler
implements InvocationHandler {
    public static final String CONNECTION_TIMEOUT = "Connection timeout. Reconnection is in progress. \nPlease wait for a while and try again.";
    private Logger _logger = Logger.getLogger(ProxyInvocationHandler.class);
    private Object _targetObj = null;
    private ServerConnection _connection = null;
    private boolean _standAlone = false;

    ProxyInvocationHandler(ServerConnection connection) {
        this._connection = connection;
        if (System.getProperty("fm.standalone") != null && "true".equalsIgnoreCase(System.getProperty("fm.standalone"))) {
            this._standAlone = true;
        }
    }

    Object setTargetObj() {
        return this._targetObj;
    }

    void setTargetObj(Object targetObj) {
        this._logger.debug((Object)("SetTargetObj " + targetObj));
        this._targetObj = targetObj;
    }

    private Serializable makeCopy(Serializable object) throws IOException, ClassNotFoundException {
        if (object instanceof Remote) {
            return object;
        }
        if (object.getClass().getName().indexOf("java.lang") >= 0) {
            return object;
        }
        Serializable ret = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(out);
        oOut.writeObject(object);
        oOut.reset();
        oOut.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInputStream oIn = new ObjectInputStream(in);
        ret = (Serializable)oIn.readObject();
        return ret;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (this._targetObj == null) {
            this._connection.targetObjectLost();
            throw new Exception(CONNECTION_TIMEOUT);
        }
        this._logger.debug((Object)("Call " + m.getName() + " in " + this._targetObj.getClass().getName()));
        try {
            Object proxyReturnObj;
            Object ret = proxyReturnObj = m.invoke(this._targetObj, args);
            if (ret != null && this._standAlone) {
                if (ret instanceof Serializable) {
                    ret = this.makeCopy((Serializable)ret);
                } else {
                    this._logger.warn((Object)(ret.getClass().getName() + " is not serializable in standAlone mode"));
                }
            }
            return ret;
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof SanException) {
                throw t;
            }
            this._logger.error((Object)("Failed to invoke " + m.getName() + " in " + this._targetObj), t);
            if (t instanceof NoSuchObjectException || t instanceof NoSuchEJBException) {
                this._connection.targetObjectLost();
                throw new Exception(CONNECTION_TIMEOUT);
            }
            if (t instanceof ConnectException) {
                this._connection.connectionDown();
                throw t;
            }
            throw t;
        }
        catch (Throwable t) {
            this._logger.error((Object)("Failed to invoke " + m.getName() + " in " + this._targetObj), t);
            this._logger.warn((Object)t.getMessage(), t);
            throw t;
        }
    }
}

