/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client;

import com.cisco.dcbu.install.StreamReader;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.IntProperties;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class SMLaunchPad
extends JFrame
implements ActionListener {
    static final String SERVER_HISTORY_FILENAME = ClientCache.getLocation() + "launchhistory.properties";
    public static final String TITLE = "Cisco DCNM-SAN Launch Pad 6.3(1)";
    public static Logger logger = Logger.getLogger(SMLaunchPad.class);
    static final Cursor busyCursor = Cursor.getPredefinedCursor(3);
    static final Cursor origCursor = Cursor.getDefaultCursor();
    protected MainSection main = null;
    protected String server = null;

    protected SMLaunchPad(String server) {
        this.setLookAndFeel();
        this.installAppender();
        logger.info((Object)"Initializing Launch Pad");
        IntProperties intProperties = new IntProperties(this.loadProperties(SERVER_HISTORY_FILENAME));
        Vector values = intProperties.getVector();
        if (server != null && intProperties.size() <= 0) {
            this.server = server.trim();
            if (!values.contains(this.server)) {
                values.add(this.server);
            }
        }
        String motd = this.fetchMtod(this.server);
        this.main = new MainSection(values, motd);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)new Banner(TITLE, "Please enter a server address"), "North");
        cp.add((Component)this.main, "Center");
        ButtonSection btnDisplay = new ButtonSection(this);
        cp.add((Component)btnDisplay, "South");
        this.setTitle(TITLE);
        ImageIcon icon = SMLaunchPad.loadIcon("icons/LogoIcon.gif");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.getRootPane().setDefaultButton(btnDisplay.getStart());
        this.getRootPane().registerKeyboardAction(this, "Start", KeyStroke.getKeyStroke(10, 0), 2);
    }

    public static ImageIcon loadIcon(String path) {
        ImageIcon icon = null;
        try {
            URL url = SMLaunchPad.class.getResource("/" + path);
            icon = new ImageIcon(url);
        }
        catch (Exception ex) {
            logger.error((Object)(path + " loadIcon: " + ex));
        }
        return icon;
    }

    private void installAppender() {
        try {
            String pattern = "%d{yyyy.MM.dd HH:mm:ss} %-5p %x [%c] %m%n";
            PatternLayout layout = new PatternLayout(pattern);
            String fmLog = ClientCache.getLocation() + SysInfo.FS + "logs" + SysInfo.FS + "fm.log";
            logger.addAppender((Appender)new FileAppender((Layout)layout, fmLog, true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setLookAndFeel() {
        if (SysInfo.ONWINDOWS) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to set look and feel: " + ex.getMessage()));
            }
        }
    }

    public String fetchMtod(String server) {
        String loc = server + "/download/motd.txt";
        try {
            URLConnection con = this.createConnection(loc);
            int size = con.getContentLength();
            InputStream in = con.getInputStream();
            StringBuilder motd = new StringBuilder();
            int data = -1;
            while ((data = in.read()) > -1) {
                motd.append((char)data);
            }
            logger.info((Object)motd.toString());
            return motd.toString();
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to get message of the day: " + ex.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String fileName) {
        Properties properties = new Properties();
        FileInputStream fsm = null;
        try {
            fsm = new FileInputStream(fileName);
            properties.load(fsm);
        }
        catch (IOException ex) {
            logger.info((Object)("Failed loading " + fileName));
        }
        finally {
            if (fsm != null) {
                try {
                    fsm.close();
                }
                catch (IOException ex1) {
                    logger.info((Object)("Failed closing " + fileName));
                }
            }
        }
        return properties;
    }

    public void doStart() {
        boolean stayAlive = false;
        String server = this.main.getServer().trim();
        if ("".equals(server)) {
            logger.warn((Object)"Server URL is blank.");
            return;
        }
        if (!server.toLowerCase().startsWith("http://") && !server.toLowerCase().startsWith("https://")) {
            server = "http://" + server;
        }
        String fm = server + "/fm-nosc.jnlp";
        try {
            try {
                this.testConnection(fm);
            }
            catch (Exception ex) {
                fm = server + "/install?command=fm";
                this.testConnection(fm);
            }
            this.main.dropDown.getModel().setSelectedItem(server);
            this.saveHistory(server);
            File ws = new File(SysInfo.JWSEXEC);
            if (!ws.exists()) {
                logger.error((Object)(ws.getAbsolutePath() + " not found. Try launching anyway."));
            }
            SMLaunchPad.exec(SysInfo.JWSEXEC + " -Xnosplash " + fm);
            boolean found = false;
            for (int i = 0; i < this.main.dropDown.getItemCount(); ++i) {
                String item = (String)this.main.dropDown.getItemAt(i);
                if (!server.equals(item)) continue;
                this.main.dropDown.setSelectedItem(item);
                found = true;
                break;
            }
            if (!found) {
                this.main.dropDown.setSelectedItem(server);
            }
        }
        catch (UnknownHostException uhe) {
            String err = "Host is unkown: " + uhe.getMessage();
            logger.error((Object)err);
            JOptionPane.showConfirmDialog(this, err, TITLE, -1, 0);
            stayAlive = true;
        }
        catch (SocketTimeoutException timeout) {
            String err = "Connect timeout: " + timeout.getMessage();
            logger.error((Object)err);
            JOptionPane.showConfirmDialog(this, err, TITLE, -1, 0);
            stayAlive = true;
        }
        catch (Exception ex) {
            String err = ex.getMessage();
            if (err == null) {
                err = "Unable to connect.";
            }
            logger.error((Object)err);
            JOptionPane.showConfirmDialog(this, err, TITLE, -1, 0);
            stayAlive = true;
        }
        if (!stayAlive) {
            System.exit(0);
        }
    }

    private void testConnection(String fm) throws NoSuchAlgorithmException, KeyManagementException, MalformedURLException, IOException {
        URLConnection conn = this.createConnection(fm);
        conn.setConnectTimeout(30000);
        conn.connect();
        Object cont = conn.getContent();
    }

    private URLConnection createConnection(String where) throws NoSuchAlgorithmException, KeyManagementException, MalformedURLException, IOException {
        if (where.startsWith("https")) {
            this.trustAllHost();
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    logger.warn((Object)("Warning: wrong hostname: host " + urlHostName + " should be " + session.getPeerHost()));
                    return true;
                }
            });
        }
        URL url = new URL(where);
        String protocol = url.getProtocol();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("protocol: " + protocol));
        }
        URLConnection conn = url.openConnection();
        return conn;
    }

    public static boolean exec(String cmd) throws Exception {
        Process proc = Runtime.getRuntime().exec(cmd);
        new StreamReader(proc.getInputStream()).start();
        new StreamReader(proc.getErrorStream()).start();
        int rc = proc.waitFor();
        return rc == 0;
    }

    private void trustAllHost() throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        KeyManager[] km = null;
        TrustManager[] tma = new TrustManager[]{tm};
        SSLContext sc = SSLContext.getInstance("ssl");
        sc.init(km, tma, new SecureRandom());
        SSLSocketFactory sf = sc.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sf);
    }

    public void saveHistory(String server) {
        String selected;
        ComboBoxModel model = this.main.dropDown.getModel();
        Vector<String> vector = new Vector<String>();
        int MAX = 10;
        for (int i = 0; i < model.getSize() && i < 10; ++i) {
            String svr = (String)model.getElementAt(i);
            vector.add(svr);
        }
        if (vector.contains(server.trim())) {
            vector.remove(server.trim());
        }
        vector.insertElementAt(server.trim(), 0);
        Properties oldProps = this.loadProperties(SERVER_HISTORY_FILENAME);
        if (oldProps.size() <= 0 && !this.server.equals((selected = this.main.dropDown.getSelectedItem().toString()).trim())) {
            vector.remove(this.server);
        }
        IntProperties props = new IntProperties();
        props.setVector(vector);
        try {
            SMLaunchPad.saveProperties(SERVER_HISTORY_FILENAME, props);
        }
        catch (IOException e) {
            logger.error((Object)("Unable to save history: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(String fileName, Properties prop) throws IOException {
        if (fileName == null || prop == null) {
            return;
        }
        try (FileOutputStream fsm = new FileOutputStream(fileName);){
            prop.store(fsm, "(c) Cisco Systems\n#DCNM-SAN 6.3(1)\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (e.getSource() instanceof JRootPane) {
            action = "Start";
        }
        switch (action.charAt(0)) {
            case 'S': {
                try {
                    this.setCursor(busyCursor);
                    this.doStart();
                    break;
                }
                finally {
                    this.setCursor(origCursor);
                }
            }
            case 'C': {
                System.exit(0);
            }
        }
    }

    public static void main(String ... args) {
        String server = "http://localhost";
        block3: for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') continue;
            switch (args[i].charAt(1)) {
                case 's': {
                    server = args[++i];
                    continue block3;
                }
            }
        }
        SMLaunchPad lp = new SMLaunchPad(server);
        lp.pack();
        lp.setVisible(true);
        lp.toFront();
    }

    private static class Banner
    extends JPanel {
        JLabel title;
        JTextArea describe;
        ImageIcon image;

        public Banner(String name, String brief) {
            this.title = new JLabel(name);
            this.describe = new JTextArea(brief);
            this.image = SMLaunchPad.loadIcon("icons/logo.gif");
            this.buildContent();
        }

        private void buildContent() {
            JPanel left = new JPanel();
            left.setLayout(new GridBagLayout());
            left.setBackground(Color.WHITE);
            Font font = UIManager.getDefaults().getFont("Table.font");
            this.title.setFont(new Font(font.getFontName(), 1, font.getSize()));
            this.describe.setEditable(false);
            this.describe.setLineWrap(true);
            this.describe.setWrapStyleWord(true);
            this.describe.setOpaque(false);
            this.describe.setFont((Font)UIManager.getDefaults().get("Table.font"));
            JLabel icon = new JLabel(this.image);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 0.5;
            gbc.weighty = 0.5;
            gbc.insets = new Insets(10, 10, 0, 0);
            gbc.fill = 2;
            gbc.anchor = 10;
            left.add((Component)this.title, gbc);
            gbc.gridy = 1;
            gbc.insets = new Insets(5, 30, 10, 0);
            left.add((Component)this.describe, gbc);
            this.setLayout(new BorderLayout());
            this.setBackground(Color.WHITE);
            this.add((Component)left, "West");
            this.add((Component)icon, "East");
            this.add((Component)new JSeparator(), "South");
        }
    }

    private static class MainSection
    extends JPanel {
        JComboBox dropDown;

        public MainSection(Vector servers, String motd) {
            JPanel addressPane = this.createAddressArea(servers);
            JPanel motdPane = motd == null ? null : this.createMotdArea(motd);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(15, 15, 15, 15);
            this.add((Component)addressPane, gbc);
            if (motdPane != null) {
                gbc.insets = new Insets(0, 15, 15, 15);
                motdPane.setPreferredSize(new Dimension(600, 90));
                gbc.anchor = 11;
                ++gbc.gridx;
                gbc.weighty = 1.0;
                this.add((Component)motdPane, gbc);
            }
        }

        private JPanel createMotdArea(String motd) {
            JPanel motdPane = new JPanel();
            JTextArea motdArea = new JTextArea();
            motdArea.setText(motd);
            motdArea.setEditable(false);
            motdArea.setWrapStyleWord(true);
            motdArea.setLineWrap(true);
            motdArea.setOpaque(false);
            motdArea.setFont((Font)UIManager.getDefaults().get("Table.font"));
            motdArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JScrollPane pScroll = new JScrollPane(motdArea, 20, 30);
            pScroll.setBorder(BorderFactory.createEmptyBorder());
            motdPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            motdPane.add((Component)pScroll, gbc);
            return motdPane;
        }

        private JPanel createAddressArea(Vector servers) {
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            this.dropDown = new JComboBox();
            final MyComboBoxUI boxUI = (MyComboBoxUI)MyComboBoxUI.createUI(this.dropDown);
            this.dropDown.setUI(boxUI);
            KeyListener comboKeyListener = new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 127 && MainSection.this.dropDown.isPopupVisible()) {
                        JList list = boxUI.getList();
                        int idx = list.getSelectedIndex();
                        list.remove(idx);
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            };
            this.dropDown.addKeyListener(comboKeyListener);
            this.dropDown.setMaximumRowCount(5);
            this.dropDown.removeAllItems();
            for (Object item : servers) {
                if (item == null) continue;
                this.dropDown.addItem(item);
            }
            this.dropDown.setEditable(true);
            this.dropDown.setPreferredSize(new Dimension(500, this.dropDown.getPreferredSize().height));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            gbc.fill = 2;
            JLabel url = new JLabel("Server URL:");
            pane.add((Component)url, gbc);
            gbc.ipadx = 20;
            pane.add(Box.createHorizontalStrut(10), gbc);
            pane.add((Component)this.dropDown, gbc);
            return pane;
        }

        public String getServer() {
            return (String)this.dropDown.getSelectedItem();
        }
    }

    private static class ButtonSection
    extends JPanel {
        public static final String START_CMD = "Start";
        public static final String CLOSE_CMD = "Close";
        protected JButton startBtn = new JButton("Start");
        protected JButton closeBtn = new JButton("Close");

        public ButtonSection(ActionListener listener) {
            JButton[] btns;
            this.startBtn.setActionCommand(START_CMD);
            this.closeBtn.setActionCommand(CLOSE_CMD);
            this.setLayout(new BorderLayout());
            this.add((Component)new JSeparator(), "North");
            JPanel btnPanel = new JPanel();
            btnPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(10, 0, 10, 0);
            for (JButton b : btns = new JButton[]{this.startBtn, this.closeBtn}) {
                b.addActionListener(listener);
                Dimension bd = new Dimension(100, (int)b.getPreferredSize().getHeight());
                b.setPreferredSize(bd);
                ++gbc.gridx;
                btnPanel.add(Box.createHorizontalStrut(5), gbc);
                ++gbc.gridx;
                btnPanel.add((Component)b, gbc);
            }
            this.add((Component)btnPanel, "Center");
        }

        public JButton getStart() {
            return this.startBtn;
        }

        public JButton getClose() {
            return this.closeBtn;
        }
    }

    private static class MyComboBoxUI
    extends BasicComboBoxUI {
        JList list = null;

        private MyComboBoxUI() {
        }

        public JList getList() {
            return this.list;
        }

        public static ComponentUI createUI(JComponent c) {
            return new MyComboBoxUI();
        }

        @Override
        protected ComboPopup createPopup() {
            ComboPopup popup = super.createPopup();
            this.list = popup.getList();
            return popup;
        }
    }
}

