/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.aaa;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.aaa.AAAManager;
import com.cisco.dcbu.sm.client.aaa.AAAModel;
import com.cisco.dcbu.sm.client.aaa.AAATable;
import com.cisco.dcbu.sm.client.aaa.AAATableModel;
import com.cisco.dcbu.sm.client.aaa.AAAWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class AAASwitchPanel
extends WizardPanel
implements TableModelListener,
ItemListener {
    public static String[] ProtocolType = new String[]{"TACACS", "RADIUS", "LDAP"};
    private RadioButtonPanel protocol = new RadioButtonPanel(ProtocolType);
    private AAATableModel model;
    private AAATable table;

    public AAASwitchPanel() {
        super("1 of 3: Select Protocol and Devices", "Select all the switches that you would like to configure AAA on.  Switches that have this feature CFS enabled can not be configured. Please exit the wizard and disable CFS if you would like to include them.\nNote: LDAP configuration is only supported on switches running version 5.2 or higher.", AAAWizard.AAA_ICON);
        this.protocol.setSelected(0);
        this.protocol.addChangeListener(this);
        this.protocol.setBorder(new EmptyBorder(5, 1, 1, 1));
        JScrollPane tablePane = this.createTablePanel();
        JPanel protoPanel = new JPanel();
        protoPanel.add(new JLabel("Protocol : "));
        protoPanel.add(this.protocol);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)protoPanel, "North");
        tablePanel.add((Component)tablePane, "Center");
        this.add(tablePanel);
    }

    private JScrollPane createTablePanel() {
        this.model = new AAATableModel(AAAManager.PROTOCOL.values()[this.protocol.getSelected() + 1]);
        this.table = new AAATable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        return scrollPane;
    }

    @Override
    public void doNext() {
        AAAManager.getInstance().setProtocol(AAAManager.PROTOCOL.values()[this.protocol.getSelected() + 1]);
        List<Switch> swList = this.model.getSelectedSwitches();
        if (swList.size() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please select at least one switch to configure.");
            return;
        }
        AAAManager.getInstance().setSwitches(swList);
        boolean existing = this.removeExistingConfig(swList);
        if (!existing) {
            AAAManager.getInstance().resetModel();
            this.refresh();
            return;
        }
        StringBuffer removeConfigError = new StringBuffer();
        boolean configChanged = false;
        for (Switch sw : swList) {
            AAAModel model = AAAManager.getInstance().getAAAModel(sw.getPeer());
            if (!(AAAManager.getInstance().isTACACS() && model.config.tacacs || AAAManager.getInstance().isRADIUS() && model.config.radius || AAAManager.getInstance().isLDAP() && model.config.ldap) && !existing) continue;
            String groupErr = AAAManager.getInstance().deleteServerGroup(sw.getPeer(), AAAManager.getInstance().getProtocol());
            if (AAAManager.getInstance().serverGroupExists(sw, AAAManager.getInstance().getProtocol()) > 0) {
                removeConfigError.append("Could not delete Server Group: \n\t" + groupErr + "\n");
            }
            String priServerErr = AAAManager.getInstance().deleteServer(sw.getPeer(), AAAManager.getInstance().getProtocol(), true);
            if (AAAManager.getInstance().serverExists(sw, AAAManager.getInstance().getProtocol(), true)) {
                removeConfigError.append("Could not delete Primary Server: \n\t" + priServerErr + "\n");
            }
            String secServerErr = AAAManager.getInstance().deleteServer(sw.getPeer(), AAAManager.getInstance().getProtocol(), false);
            if (AAAManager.getInstance().serverExists(sw, AAAManager.getInstance().getProtocol(), false)) {
                removeConfigError.append("Could not delete Secondary Server: \n\t" + secServerErr + "\n");
            }
            configChanged = true;
        }
        if (configChanged) {
            AAAManager.getInstance().resetModel();
            this.refresh();
        }
        if (removeConfigError.length() > 0) {
            Util.errorMessage((Component)this.getWizard(), removeConfigError.toString());
            return;
        }
        AAAManager.getInstance().setSwitches(swList);
        this.setDataValid(false);
        Map<Object, Object> errors = new HashMap();
        try {
            errors = AAAManager.getInstance().enableFeatureControl(swList);
        }
        catch (SnmpException e) {
            Util.errorMessage((Component)this.getWizard(), "Could not enable feature: " + e.getMessage());
        }
        Iterator<Object> i$ = errors.values().iterator();
        if (i$.hasNext()) {
            SnmpException ex = (SnmpException)i$.next();
            Util.errorMessage((Component)this.getWizard(), ex);
            return;
        }
        super.doNext();
    }

    private boolean removeExistingConfig(List<Switch> swList) {
        for (Switch sw : swList) {
            boolean configExists;
            AAAModel model = AAAManager.getInstance().getAAAModel(sw.getPeer());
            boolean bl = configExists = AAAManager.getInstance().isLDAP() && model.config.ldap || AAAManager.getInstance().isRADIUS() && model.config.radius || AAAManager.getInstance().isTACACS() && model.config.tacacs;
            if (configExists) {
                int opt = JOptionPane.showConfirmDialog(this.getWizard(), "If the selected protocol is already configured on any of the selected switches, \nthose configurations will be removed in order to proceed with the new configuration. \nDo you wish to continue?", this.getTitle(), 0);
                return opt == 0;
            }
            boolean serverGroupExists = AAAManager.getInstance().serverGroupExists(sw, AAAManager.getInstance().getProtocol()) > 0;
            if (!serverGroupExists) continue;
            int opt = JOptionPane.showConfirmDialog(this.getWizard(), "A server group already exists with the reserved index(" + AAAManager.SERVERGROUP_INDEX[AAAManager.getInstance().getProtocol().ordinal() - 1] + ") for selected protocol on " + sw + ".\n" + "The old configuration will be removed in order to proceed with the new configuration. \n" + "Do you wish to continue?", this.getTitle(), 0);
            return opt == 0;
        }
        return true;
    }

    @Override
    public boolean refresh() {
        this.model.refresh();
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        AAAManager.PROTOCOL p = AAAManager.PROTOCOL.TACACS;
        if (e.getSource() == this.protocol.getButton(0)) {
            p = AAAManager.PROTOCOL.TACACS;
        } else if (e.getSource() == this.protocol.getButton(1)) {
            p = AAAManager.PROTOCOL.RADIUS;
        } else if (e.getSource() == this.protocol.getButton(2)) {
            p = AAAManager.PROTOCOL.LDAP;
        }
        AAAManager.getInstance().setProtocol(p);
        this.model.setProtocol(p);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        System.out.println("AAASwitchPanel: Table changed : " + e);
    }
}

