/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cat;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.EndPortSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class PingDialog
extends JDialog
implements ActionListener,
SnmpCallbackIf,
ItemListener {
    static int[] _addrOid = PingDialog.getOids("fcPingAddress");
    static int[] _operStatusOid = PingDialog.getOids("fcPingOperStatus");
    static int[] _txOid = PingDialog.getOids("fcPingTxPackets");
    static int[] _rxOid = PingDialog.getOids("fcPingRxPackets");
    static int[] _minOid = PingDialog.getOids("fcPingMinRtt");
    static int[] _avgOid = PingDialog.getOids("fcPingAvgRtt");
    static int[] _maxOid = PingDialog.getOids("fcPingMaxRtt");
    static int[] _timeoutsOid = PingDialog.getOids("fcPingNumTimeouts");
    static final String[] LABELS = new String[]{"Source Switch:", "VSAN:", "Select:", "Target EndPort:", "", ""};
    static final String[] BUTTONS = new String[]{"Start", "Clear", "Close"};
    Fabric _fabric;
    JComboBox _peers;
    JComboBox _vsans;
    ArrayList _ports;
    FieldPanel _port;
    JLabel _status;
    JButton[] _buttons;
    Timer _timer;
    boolean _pending;
    int _timeElapsed;
    SnmpPeer _peer;
    int _state = 0;
    static final int INIT = 0;
    static final int SET = 1;
    static final int POLL = 2;
    static final int GET = 3;
    static final int GENERR = 4;
    static final int GENERR_GET = 5;
    static final int CLEANUP = 6;
    static final int POLL_INTERVAL = 6;
    SnmpPDU _pollPdu;
    SnmpPDU _resultPdu;
    SnmpPDU _genErrPdu;
    SnmpPDU _cleanPdu;
    JTextArea _ta;
    DialogSeparator _dialogSeperator;
    JButton ellipsisBtn;
    JCheckBox _showAllPorts;

    public PingDialog(JFrame parent, String title, boolean showAllPorts) throws SnmpException {
        super((Frame)parent, title);
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", this.buildInput(showAllPorts));
        p.add("Center", this.buildResult());
        JPanel southPanel = new JPanel(new BorderLayout());
        this._buttons = DialogUtil.buildButtons(BUTTONS, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
        }
        southPanel.add("North", buttonPanel);
        this._status = new JLabel(" ");
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        southPanel.add("South", this._status);
        p.add("South", southPanel);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)p, southPanel);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
    }

    public PingDialog(JFrame parent, boolean showAllPorts) throws SnmpException {
        this(parent, "Ping" + ClientController.getInstance().getDialogFabricTitlePostfix(), showAllPorts);
    }

    JComponent buildInput(boolean showAllPorts) throws SnmpException {
        SmMap map = SmMap.getSelectedMap();
        this._fabric = map.getFabric();
        if (this._fabric == null) {
            this._fabric = ClientController.getInstance().getFabric();
        }
        EndPort ep = null;
        boolean hasMdsPeers = false;
        ArrayList coll = map.getSelectedNodes();
        if (coll.size() == 0) {
            this._fabric = ClientController.getInstance().getFabric();
            hasMdsPeers = this._fabric.getSnmpPeers() != null && this._fabric.getSnmpPeers().length > 0;
            Fabric[] fabrics = ClientController.getInstance().getFabrics();
            if (!hasMdsPeers && fabrics != null) {
                for (int f = 0; f < fabrics.length; ++f) {
                    boolean bl = hasMdsPeers = fabrics[f].getSnmpPeers() != null && fabrics[f].getSnmpPeers().length > 0;
                    if (!hasMdsPeers) continue;
                    this._fabric = fabrics[f];
                    break;
                }
            }
        }
        for (MapNode node : coll) {
            Object obb = node.getModel();
            if (obb instanceof AbstractModelObject) {
                ArrayList<EndPort> members;
                AbstractModelObject obj = (AbstractModelObject)node.getModel();
                if (obj instanceof EndPort) {
                    ep = (EndPort)obj;
                    if (!hasMdsPeers) {
                        boolean bl = hasMdsPeers = ep.getFabric().getSnmpPeers() != null && ep.getFabric().getSnmpPeers().length > 0;
                    }
                    if (hasMdsPeers) {
                        break;
                    }
                } else if (obj instanceof Enclosure && (members = ((Enclosure)obj).getMembers()) != null) {
                    for (int prts = 0; prts < members.size(); ++prts) {
                        ep = members.get(prts);
                        if (!hasMdsPeers) {
                            boolean bl = hasMdsPeers = ep.getFabric().getSnmpPeers() != null && ep.getFabric().getSnmpPeers().length > 0;
                        }
                        if (hasMdsPeers) break;
                    }
                }
            }
            if (this._fabric == null) {
                this._fabric = ep == null ? ClientController.getInstance().getFabric() : ep.getFabric();
                continue;
            }
            hasMdsPeers = this._fabric.getSnmpPeers() != null && this._fabric.getSnmpPeers().length > 0;
        }
        if (!hasMdsPeers) {
            throw new SnmpException("No switches are available for this feature.");
        }
        Object[] peers = this._fabric.getSnmpPeers(true);
        if (peers != null && peers.length > 0) {
            Arrays.sort(peers);
        }
        Object[] vsans = this._fabric.getVsans();
        Arrays.sort(vsans);
        JComponent[] values = new JComponent[LABELS.length];
        this._peers = new JComboBox<Object>(peers);
        if (peers.length > 0) {
            SnmpPeer apeer;
            Arrays.sort(peers);
            Object peer = peers[0];
            if (ep != null && (apeer = ep.getSwitch().getPeer()) != null) {
                peer = apeer;
            }
            this._peers.setSelectedItem(peer);
            Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)peer).getAddress());
            vsans = sw.getVsans();
        }
        this._peers.addItemListener(this);
        this._vsans = new JComboBox<Object>(vsans);
        this.ellipsisBtn = new JButton("...");
        this.ellipsisBtn.setToolTipText("Select End Device");
        this.ellipsisBtn.setActionCommand("EndPorts");
        this.ellipsisBtn.setMargin(Util.getNoBorder());
        this.ellipsisBtn.addActionListener(this);
        this._port = new FieldPanel(new KTextField(25), (JComponent)this.ellipsisBtn);
        if (vsans.length > 0) {
            Vsan selVsan;
            this._vsans.setSelectedItem(vsans[0]);
            this._ports = ((Vsan)vsans[0]).getEndPorts(null);
            if (ep != null && (selVsan = this._fabric.findVsanById(ep.getVsanId())) != null) {
                this._vsans.setSelectedItem(selVsan);
                byte[] b = ep.getPortWwn().getValue();
                String wwn = SnmpString.toHexString(b, 0, b.length);
                this._port.setText(wwn);
                this._ports = selVsan.getEndPorts(null);
            }
        }
        this._vsans.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vsan vsan = (Vsan)PingDialog.this._vsans.getSelectedItem();
                if (vsan != null) {
                    PingDialog.this._ports = vsan.getEndPorts(null);
                }
            }
        });
        this._showAllPorts = new JCheckBox("Target Port from all VSANs");
        this._showAllPorts.setVisible(showAllPorts);
        values[0] = this._peers;
        values[1] = this._vsans;
        values[2] = this._showAllPorts;
        values[3] = this._port;
        values[4] = new JLabel("(FCID or Port WWN)");
        this._dialogSeperator = new DialogSeparator("Results");
        values[5] = this._dialogSeperator;
        JComponent[] labels = DialogUtil.buildLabels(LABELS);
        labels[2].setVisible(showAllPorts);
        return DialogUtil.buildPanel(labels, values);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        SnmpPeer peer = (SnmpPeer)this._peers.getSelectedItem();
        Switch sw = this._fabric.findSwitchByIpAddress(peer.getAddress());
        Object[] vsans = sw.getVsans();
        Arrays.sort(vsans);
        this._vsans.removeAllItems();
        for (int i = 0; i < vsans.length; ++i) {
            this._vsans.addItem(vsans[i]);
        }
    }

    JComponent buildResult() {
        this._ta = new JTextArea(3, 30);
        this._ta.setEditable(false);
        this._ta.setOpaque(false);
        this._ta.setFont((Font)UIManager.getDefaults().get("Table.font"));
        return this._ta;
    }

    @Override
    public void dispose() {
        if (this._timer != null) {
            this._timer.stop();
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() instanceof Timer) {
                this.handleTimerEvent();
            } else if (e.getSource() == this.ellipsisBtn) {
                EndPortSelector prtSel = new EndPortSelector((JFrame)SwingUtilities.windowForComponent(this.getParent()), this._showAllPorts.isSelected() ? null : (Vsan)this._vsans.getSelectedItem(), null, false, null);
                prtSel.setVisible(true);
                EndPort[] ep = prtSel.getSelectedEndPort();
                if (ep != null && ep.length > 0) {
                    this._port.setText(SnmpString.toHexString(ep[0].getPortWwn().getValue()));
                }
            } else {
                this.doIt((JButton)e.getSource());
            }
        }
        catch (Exception ex) {
            if (this._timer != null) {
                this._timer.stop();
            }
            Util.errorMessage((Component)this, ex);
            DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
            this._buttons[0].setText("Start");
        }
    }

    void poll() {
        try {
            this._peer.send(this._pollPdu, this);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void fetchResults() {
        try {
            this._peer.send(this._resultPdu, this);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void cleanup() {
        try {
            this._peer.send(this._cleanPdu, this);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void handleTimerEvent() {
        this._timeElapsed += 6;
        if (!this._pending) {
            if (this._state == 2) {
                this._pending = true;
                this.poll();
            } else if (this._state == 3) {
                this._pending = true;
                this.fetchResults();
            } else if (this._state == 4) {
                try {
                    this._pending = true;
                    int[] oid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 305, 1, 2, 1, 1, 5, 1, 0, 0, 0, 0, 0};
                    byte[] b = this._peer.getSession().getSnmpSourceAddress().getAddress();
                    String vpnAddr = this._peer.getSession().getLocalVPNAddress();
                    if (vpnAddr != null && vpnAddr.length() != 0) {
                        try {
                            b = InetAddress.getByName(vpnAddr).getAddress();
                        }
                        catch (UnknownHostException uhe) {
                            // empty catch block
                        }
                    }
                    for (int i = 0; i < b.length; ++i) {
                        oid[oid.length - (5 - i)] = b[i] & 0xFF;
                    }
                    oid[oid.length - 1] = this._genErrPdu.getReqid();
                    SnmpPDU errPdu = new SnmpPDU(-96, new VarBindList(1));
                    errPdu.addNull(new SnmpOID(oid));
                    this._state = 5;
                    this._peer.send(errPdu, this);
                }
                catch (Exception exception) {}
            } else if (this._state == 6) {
                this._pending = true;
                this.cleanup();
            } else {
                this._timer.stop();
                this._timeElapsed = 0;
                this._buttons[0].setText("Start");
            }
        } else {
            this.setStatus("In Progress polling " + this._timeElapsed + " secs");
        }
    }

    void startAction(Vsan vsan, String port) throws Exception {
        this.clear();
        int[] index = new int[]{PingDialog.random()};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(PingDialog.getOids("fcPingRowStatus"), index), new SnmpInt(4));
        if (port.startsWith("0x")) {
            byte[] b = this.extract3ByteId(port);
            pdu.addVar(new SnmpOID(_addrOid, index), new SnmpString(b));
            pdu.addVar(new SnmpOID(PingDialog.getOids("fcPingAddressType"), index), new SnmpInt(2));
        } else {
            pdu.addVar(new SnmpOID(_addrOid, index), new SnmpString(port));
        }
        pdu.addVar(new SnmpOID(PingDialog.getOids("fcPingVsanIndex"), index), new SnmpInt(vsan.getId()));
        pdu.addVar(new SnmpOID(PingDialog.getOids("fcPingAdminStatus"), index), new SnmpInt(1));
        this._pollPdu = new SnmpPDU(-96, new VarBindList());
        this._pollPdu.addVar(new SnmpOID(_operStatusOid, index));
        this._resultPdu = new SnmpPDU(-96, new VarBindList());
        this._resultPdu.addVar(new SnmpOID(_txOid, index));
        this._resultPdu.addVar(new SnmpOID(_rxOid, index));
        this._resultPdu.addVar(new SnmpOID(_minOid, index));
        this._resultPdu.addVar(new SnmpOID(_avgOid, index));
        this._resultPdu.addVar(new SnmpOID(_maxOid, index));
        this._resultPdu.addVar(new SnmpOID(_timeoutsOid, index));
        this._cleanPdu = new SnmpPDU(-93, new VarBindList());
        this._cleanPdu.addVar(new SnmpOID(PingDialog.getOids("fcPingRowStatus"), index), new SnmpInt(6));
        this._cleanPdu.setIgnoreSetCount(true);
        try {
            this._state = 1;
            this._pending = true;
            pdu.setIgnoreSetCount(true);
            this._peer.send(pdu, this);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    void clear() {
        this._ta.setText(null);
    }

    void doIt(JButton button) throws Exception {
        String cmd = button.getText();
        if (cmd.equals("Start")) {
            SnmpPeer peer = (SnmpPeer)this._peers.getSelectedItem();
            Vsan vsan = (Vsan)this._vsans.getSelectedItem();
            String port = this._port.getText();
            if (port == null || port.length() == 0) {
                Util.errorMessage((Component)this, "Incorrect EndPort");
                return;
            }
            this._peer = peer;
            this.startAction(vsan, port);
            this._buttons[0].setText("Stop");
            this.setStatus("Started");
            this._timer = new Timer(6000, this);
            this._timeElapsed = 0;
            this._timer.start();
        } else if (cmd.equals("Stop")) {
            this._timer.stop();
            this._timeElapsed = 0;
            this._buttons[0].setText("Start");
        } else if (cmd.equals("Clear")) {
            this.clear();
        } else {
            this._buttons[0].setText("Start");
            this.dispose();
        }
    }

    void setStatus(String msg) {
        this._status.setText(msg);
    }

    byte[] extract3ByteId(String fcidPort) throws SnmpException {
        int value = 0;
        if (fcidPort.charAt(1) == 'x' || fcidPort.charAt(1) == 'X') {
            if (fcidPort.length() != 8) {
                throw new SnmpException("The fcid must be 3 bytes long.");
            }
            try {
                value = Integer.parseInt(fcidPort.substring(2), 16);
            }
            catch (NumberFormatException ex) {
                if (fcidPort.length() > 0) {
                    throw new SnmpException("Please type a valid port (" + fcidPort + ").");
                }
                throw new SnmpException("Please type a valid port.");
            }
        } else if (fcidPort.length() != 6) {
            throw new SnmpException("The fcid must be 3 bytes long.");
        }
        byte[] fcid = new byte[3];
        fcid[2] = (byte)(value & 0xFF);
        fcid[1] = (byte)(value >> 8 & 0xFF);
        fcid[0] = (byte)(value >> 16 & 0xFF);
        return fcid;
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        this._pending = false;
        if (this._state == 2 && timedOut) {
            return;
        }
        if (this._state == 1 && pdu.getError() == 5) {
            this._genErrPdu = pdu;
            this._state = 4;
            return;
        }
        if (this._state == 6) {
            this._state = 0;
        } else {
            if (timedOut || pdu.getError() != 0) {
                int err = pdu.getError();
                Util.errorMessage((Component)this, err != 0 ? SnmpException.toError(pdu.getError()) : "TIMEOUT");
                this.setStatus(err != 0 ? SnmpException.toError(pdu.getError()) : "TIMEOUT");
                this._state = 0;
                return;
            }
            VarBindList vbl = pdu.getVariables();
            if (this._state == 5) {
                if (!vbl.isNull(0)) {
                    Util.errorMessage((Component)this, vbl.stringValue(0));
                    this.setStatus(vbl.stringValue(0));
                } else {
                    Util.errorMessage((Component)this, "GenError");
                    this.setStatus("GenError");
                }
            } else if (this._state == 1) {
                this._state = 2;
            } else if (this._state == 2) {
                this.pollCb(vbl);
            } else if (this._state == 3) {
                this.resultCb(vbl);
            }
        }
    }

    void pollCb(VarBindList vbl) {
        int status = vbl.intValue(0);
        String msg = PingDialog.getEnum("fcPingOperStatus", status);
        this.setStatus(msg);
        if (status == 2) {
            this._state = 3;
        } else if (status != 1) {
            this._state = 0;
            Util.errorMessage((Component)this, "Failed - " + msg);
        }
    }

    void resultCb(VarBindList vbl) {
        StringBuffer buff = new StringBuffer();
        long tx = vbl.longValue(0);
        long rx = vbl.longValue(1);
        int min = vbl.intValue(2);
        int avg = vbl.intValue(3);
        int max = vbl.intValue(4);
        long tms = vbl.longValue(5);
        buff.append(tx);
        buff.append(" frames sent, ");
        buff.append(rx);
        buff.append(" frames received, ");
        buff.append(tms);
        buff.append(" timeouts\n");
        buff.append("Round-trip min/avg/max = ");
        buff.append(min);
        buff.append("/");
        buff.append(avg);
        buff.append("/");
        buff.append(max);
        buff.append(" usec");
        this._ta.setText(buff.toString());
        this.setStatus("Done");
        this._state = 6;
    }

    static final int[] getOids(String n) {
        return MibNode.get(n).getOid();
    }

    static final int random() {
        return (int)(Math.random() * 2.14748364E8) + 1;
    }

    static final String getEnum(String name, int value) {
        MibNode mn = MibNode.get(name);
        return MibEnum.getLabel(mn.getEnums(), value);
    }

    static String getDisplay(EndPort port, Vsan vsan) {
        String s = port.toString();
        String fcid = port.getFcIdAsString(port.getFcIdNum(vsan.getId()));
        return fcid + " " + s;
    }
}

