/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cat;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cat.PingDialog;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.map.actions.SelectionAction;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class RdlDialog
extends PingDialog {
    static final int _Visible_Rows = 6;
    static final String[] RESULT_COLS = new String[]{"Hop", "Switch"};
    KTable _resultTable;
    JScrollPane _resultSp;
    VarBindList _resultVbl;
    static int[] _addrOid = RdlDialog.getOids("fcTraceRouteTargetAddr");
    static int[] _addrTypeOid = RdlDialog.getOids("fcTraceRouteTargetAddrType");
    static int[] _operStatusOid = RdlDialog.getOids("fcTraceRouteOperStatus");
    static int[] _hopAddrOid = RdlDialog.getOids("fcTraceRouteHopsHopAddr");
    static int[][] _resultOids = new int[][]{_hopAddrOid};

    public RdlDialog(JFrame parent) throws SnmpException {
        super(parent, "Trace Route" + ClientController.getInstance().getDialogFabricTitlePostfix(), false);
    }

    @Override
    JComponent buildResult() {
        this._dialogSeperator.setLabel("Round Trip between Source and Target. (Click for Map Highlight)");
        this._resultTable = RdlDialog.buildTable(RESULT_COLS, new Array());
        this._resultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int[] rows;
                if (me.getSource() instanceof KTable && (rows = RdlDialog.this._resultTable.getSelectedRows()).length > 0) {
                    ArrayList<Object> sws = new ArrayList<Object>();
                    for (int i = 0; i < rows.length; ++i) {
                        Object[] row = (Object[])RdlDialog.this.getData(RdlDialog.this._resultTable).elementAt(rows[i]);
                        if (!(row[1] instanceof Switch)) continue;
                        sws.add(row[1]);
                    }
                    if (DataView._SelectMapFrmTable) {
                        RdlDialog.this.select(sws);
                    }
                }
            }
        });
        this._resultSp = new JScrollPane(this._resultTable);
        Dimension dd = new Dimension(400, 100);
        this._resultSp.setPreferredSize(dd);
        return this._resultSp;
    }

    KTableModel getModel(KTable table) {
        return (KTableModel)table.getModel();
    }

    Array getData(KTable table) {
        return this.getModel(table).getData();
    }

    void clear(KTable table) {
        this.getData(table).clear();
        this.getModel(table).fireTableDataChanged();
    }

    @Override
    void clear() {
        this.clear(this._resultTable);
    }

    static final KTable buildTable(String[] cols, Array data) {
        KTableModel model = new KTableModel();
        model.setData(data);
        model.setHeaders(cols);
        KTable table = new KTable(model);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        table.addPopupMenu();
        table.setAutoResizeMode(3);
        return table;
    }

    final void select(ArrayList sws) {
        SelectionAction sa = SelectionAction.getInstance();
        sa.setObjects(sws, null);
        sa.execute();
    }

    void setVisibleRows(int rows, KTable table, JComponent parent) {
        Dimension dm = table.calcPreferredSize();
        dm = new Dimension(dm.width > 400 ? 400 : dm.width, table.getRowHeight() * (rows + 2));
        parent.setPreferredSize(dm);
    }

    @Override
    void fetchResults() {
        try {
            new SnmpFetch().getBulk(this._peer, this._resultVbl, (SnmpCallbackIf)this);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    final Object getSwitch(SnmpString swwn) {
        Wwn wwn = new Wwn(swwn);
        Switch sw = this._fabric.findSwitchByWwn(wwn);
        if (sw == null) {
            return wwn;
        }
        return sw;
    }

    @Override
    void startAction(Vsan vsan, String port) throws Exception {
        this.clear();
        int[] index = new int[]{RdlDialog.random()};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        if (port.startsWith("0x")) {
            byte[] b = this.extract3ByteId(port);
            pdu.addVar(new SnmpOID(_addrOid, index), new SnmpString(b));
            pdu.addVar(new SnmpOID(_addrTypeOid, index), new SnmpInt(2));
        } else {
            pdu.addVar(new SnmpOID(_addrOid, index), new SnmpString(port));
        }
        pdu.addVar(new SnmpOID(RdlDialog.getOids("fcTraceRouteRowStatus"), index), new SnmpInt(4));
        if (vsan.getId() != 1) {
            pdu.addVar(new SnmpOID(RdlDialog.getOids("fcTraceRouteVsanIndex"), index), new SnmpInt(vsan.getId()));
        }
        pdu.addVar(new SnmpOID(RdlDialog.getOids("fcTraceRouteAdminStatus"), index), new SnmpInt(1));
        pdu.setIgnoreSetCount(true);
        try {
            this._pending = true;
            this._state = 1;
            this._peer.send(pdu, this);
            this._pollPdu = new SnmpPDU(-96, new VarBindList());
            this._pollPdu.addVar(new SnmpOID(RdlDialog.getOids("fcTraceRouteOperStatus"), index));
            this._resultVbl = new VarBindList();
            for (int i = 0; i < _resultOids.length; ++i) {
                this._resultVbl.add(_resultOids[i], index);
            }
            this._cleanPdu = new SnmpPDU(-93, new VarBindList());
            this._cleanPdu.addVar(new SnmpOID(RdlDialog.getOids("fcTraceRouteRowStatus"), index), new SnmpInt(6));
            this._cleanPdu.setIgnoreSetCount(true);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    @Override
    void pollCb(VarBindList vbl) {
        int status = vbl.intValue(0);
        String msg = RdlDialog.getEnum("fcTraceRouteOperStatus", status);
        this.setStatus(msg);
        if (status == 4) {
            this.setStatus(msg + "(could fail if non-trunk isls exist in the route)");
            this._state = 0;
        } else if (status == 5) {
            this._state = 0;
        }
        if (status == 2 || status == 3) {
            this.setStatus(msg);
            this._state = 3;
        }
    }

    @Override
    void resultCb(VarBindList vbl) {
        Object[] row;
        this._state = 6;
        Array data = this.getData(this._resultTable);
        if (vbl.size() > 1) {
            row = new Object[2];
            row[0] = "n/a";
            int last = vbl.size() - 1;
            row[1] = this.getSwitch((SnmpString)vbl.getVb(last).getVar());
            data.addElement(row);
            row = new Object[2];
        }
        for (int i = 0; i < vbl.size(); ++i) {
            row = new Object[2];
            row[0] = new Integer(i + 1);
            SnmpVarBind vb = vbl.getVb(i);
            SnmpString addr = (SnmpString)vbl.getVb(i).getVar();
            row[1] = this.getSwitch(addr);
            data.addElement(row);
            this.getModel(this._resultTable).fireTableDataChanged();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RdlDialog.this.setVisibleRows(6, RdlDialog.this._resultTable, RdlDialog.this._resultSp);
                RdlDialog.this.pack();
            }
        });
    }
}

