/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cfs.CfsConfigWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CfsMasterSwitchPanel
extends WizardPanel
implements ListSelectionListener {
    public static final int START_ENABLE_FEATURE = 1;
    public static final int ENABLE_FEATURE = 2;
    public static final int ENABLE_CFS = 3;
    public static final int VALIDATE_MERGE_STATE = 4;
    public static final int COMMIT_MERGE_FAIL = 5;
    protected JList _switchLst;
    protected SnmpPeer[] _peers;

    public CfsMasterSwitchPanel(JWizard wizard, String description, int panels) throws SnmpException {
        super("1 of " + panels + ": Select Master Switch", description, wizard, CfsConfigWizard._Image);
        JPanel pnl = new JPanel(new BorderLayout());
        this.buildSwitchPanel(pnl);
        this.add((Component)pnl, "Center");
    }

    protected void buildSwitchPanel(JPanel pnl) throws SnmpException {
        this._switchLst = new JList();
        this._switchLst.setVisibleRowCount(10);
        JScrollPane scrLst = new JScrollPane(this._switchLst);
        this._switchLst.setSelectionMode(0);
        this._peers = this.build20SwitchList();
        this._switchLst.addListSelectionListener(this);
        if (this._peers == null || this._peers.length == 0) {
            throw new SnmpException("There are no CFS capable switches in this Fabric.");
        }
        pnl.add((Component)scrLst, "Center");
        Arrays.sort(this._peers);
    }

    protected SnmpPeer[] build20SwitchList() {
        ArrayList<SnmpPeer> peersLst = new ArrayList<SnmpPeer>();
        Switch[] swLst = ClientController.getInstance().getFabric().getSwitches();
        if (swLst != null) {
            for (int i = 0; i < swLst.length; ++i) {
                if (swLst[i] == null || !swLst[i].isMDS() || !swLst[i].isManageable() || swLst[i].getPeer() == null || !swLst[i].isVersionGreaterThan("2.0(0)")) continue;
                peersLst.add(swLst[i].getPeer());
            }
        }
        return peersLst.toArray(new SnmpPeer[peersLst.size()]);
    }

    @Override
    public boolean refresh() {
        this.populateSwitchList();
        return super.refresh();
    }

    protected void populateSwitchList() {
        DefaultListModel<SnmpPeer> listMdl = new DefaultListModel<SnmpPeer>();
        listMdl.clear();
        for (int i = 0; i < this._peers.length; ++i) {
            listMdl.addElement(this._peers[i]);
        }
        this._switchLst.setModel(listMdl);
        if (listMdl.getSize() > 0) {
            this._switchLst.setSelectedIndex(0);
        }
    }

    @Override
    public void doNext() {
        Object ob = this.getSelectedListObject();
        if (ob == null) {
            Util.errorMessage((Component)this.getWizard(), "Please select a Master Switch");
            return;
        }
        this.setModelValue("CFS_SWITCH_LIST", this._peers);
        try {
            Object obSw = this.getModelValue("CFS_MASTER_SWITCH");
            if (obSw != ob) {
                this.setModelValue("CFS_MASTER_SWITCH", ob);
                this.setDataValid(false);
            }
            if (this.userAction()) {
                super.doNext();
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
            return;
        }
    }

    protected Object getSelectedListObject() {
        return this._switchLst.getSelectedValue();
    }

    protected boolean userAction() throws SnmpException {
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.getWizard() != null && this.getWizard().getNavigator() != null) {
            this.getWizard().getNavigator().getNextBtn().setEnabled(this._switchLst.getSelectedIndex() != -1);
        }
    }
}

