/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs.dpvm;

import com.cisco.dcbu.lib.mds.zm.ActionEnabler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.cfs.CfsClientActionCommiter;
import com.cisco.dcbu.sm.client.cfs.CfsConfigWizard;
import com.cisco.dcbu.sm.client.cfs.dpvm.AutoLearnPanel;
import com.cisco.dcbu.sm.client.cfs.dpvm.DPVMMasterSwitchPanel;
import com.cisco.dcbu.sm.client.cfs.dpvm.DpvmEditPanel;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DPVMConfigWizard
extends CfsConfigWizard
implements StatusIf {
    public static final String AUTO_LEARNT = "AUTO_LEARNT";
    public static final ImageIcon DPVM_ICON = Util.loadIcon("icons/dpvm.gif");
    static final MibEnum[] DPVM_ACTIVATE_RESULT_ENUM = MibNode.get("cdpvmActivateResult").getEnums();

    public DPVMConfigWizard(JFrame parent) throws SnmpException {
        super(parent, "DPVM Setup Wizard", DPVM_ICON, null);
    }

    @Override
    protected void addPanels() throws SnmpException {
        this.addPanel("select master switch", new DPVMMasterSwitchPanel(this));
        this.addPanel("enable auto learn", new AutoLearnPanel(this));
        this.addPanel("edit dpvm config", new DpvmEditPanel(this));
    }

    @Override
    public void handleError(Exception[] ex) {
        this.setCursor(false);
        this.getCurrent().actionFinished(false);
        Util.errorMessage((Component)this, ActionEnabler.buildErrorMessage(ex).toString());
    }

    @Override
    public void actionFinished() {
        this.getCurrent().actionFinished(true);
    }

    @Override
    public void dispose() {
        this.getCurrent().dispose();
        super.dispose();
    }

    static void appendReadFromVbl(VarBindList vbl, boolean readRunning) {
        vbl.add(MibNode.get("cfsFeatureOpShowCfgOption").getOid(), CfsClientActionCommiter.DPVM_INDEX, (SnmpVar)new SnmpInt(readRunning ? 1 : 2));
    }

    void setCursor(boolean busy) {
        this.setCursor(Cursor.getPredefinedCursor(busy ? 3 : 0));
    }
}

