/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs.ps;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.PortChooser;
import com.cisco.dcbu.lib.mds.PortChooserIf;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cfs.SearchTable;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SwitchMenuButton;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmInsertPortSecurityDlg
extends JDialog
implements ListSelectionListener,
ActionListener,
ItemListener {
    static final int INTERFACE_COL = 2;
    static final int DEVICE_NAME = 1;
    static final int WWN_COL = 0;
    static final int WWN_RADIO = 0;
    static final int SWITCH_RADIO = 1;
    static final String[] HEADERS_WWN = new String[]{"Device WWN", "Name", "Attached To"};
    static final String[] HEADERS_SWITCH = new String[]{"Switch", "Interfaces"};
    private SearchTable deviceTable;
    private KTableModel deviceTableModel;
    private KTableModel switchTableModel;
    private RadioButtonPanel select;
    private FieldPanel pwwnOrSwitch;
    private FieldPanel switchInterface;
    private SwitchMenuButton swMenuBtn;
    private Vsan selVsan;
    private FieldPanel switchPanel;
    private Wwn selectedWwn;
    private Wwn selectedInterface;
    private IfPortChooser portChooser;
    private int loginDevTpe;

    public SmInsertPortSecurityDlg(JDialog parent, Vsan v) {
        super(parent);
        this.selVsan = v;
        this.setTitle("Insert Port Security Devices " + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.buildDialog();
    }

    protected void buildDialog() {
        this.select = new RadioButtonPanel(new String[]{"Port WWN", "Switch"}, 2, this);
        this.deviceTableModel = new KTableModel();
        this.deviceTableModel.setHeaders(HEADERS_WWN);
        this.deviceTableModel.setData(this.updateData(true));
        this.deviceTable = new SearchTable(this.deviceTableModel, this);
        this.deviceTable.setAutoResizeMode(0);
        this.deviceTable.setSelectionMode(0);
        this.deviceTable.getSelectionModel().addListSelectionListener(this);
        this.deviceTable.getTableHeader().addMouseListener(new HeaderListener());
        this.deviceTable.setSortable(true);
        this.deviceTable.calcPreferredSize();
        this.switchTableModel = new KTableModel();
        this.switchTableModel.setHeaders(HEADERS_SWITCH);
        this.switchTableModel.setData(this.updateData(false));
        JPanel controlPnl = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.deviceTable);
        sp.setPreferredSize(new Dimension(600, 265));
        DialogSeparator sep = new DialogSeparator("To");
        this.pwwnOrSwitch = new FieldPanel(20);
        JButton portEllipsis = new JButton("...");
        portEllipsis.setToolTipText("Select Switch Port");
        portEllipsis.setActionCommand("Interfaces");
        portEllipsis.setMargin(Util.getNoBorder());
        portEllipsis.addActionListener(this);
        this.switchInterface = new FieldPanel(20, (JComponent)portEllipsis);
        this.swMenuBtn = new SwitchMenuButton(null);
        this.switchPanel = new FieldPanel(20, (JComponent)this.swMenuBtn);
        this.switchPanel.getField().setEditable(false);
        controlPnl.add((Component)DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"Bind:", "Port or Switch WWN:", null, "Switch:", "Interface WWN:"}), new JComponent[]{this.select, this.pwwnOrSwitch, sep, this.switchPanel, this.switchInterface}), "Center");
        DialogUtil.buildDialog(this, Util.getFrameAncestor(this), controlPnl);
        this.populateSwitchMenuBtn();
        this.pack();
        this.setSize(this.getPreferredSize().width + 5, this.getPreferredSize().height);
        this.setModal(true);
        this.setResizable(true);
    }

    private void populateSwitchMenuBtn() {
        this.switchPanel.setText("");
        Object[] sw = this.selVsan.getFabric().getSwitches();
        Arrays.sort(sw);
        ArrayList<Object> switches = new ArrayList<Object>();
        for (int i = 0; i < sw.length; ++i) {
            if (!((AbstractSwitch)sw[i]).isMDS() || !((Switch)sw[i]).isManageable() || ((Switch)sw[i]).isNpvEnabled()) continue;
            switches.add(sw[i]);
        }
        Collections.sort(switches);
        this.swMenuBtn.buildMenu(switches.toArray(), false, null, this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updateRadioSelection();
        }
    }

    private void updateRadioSelection() {
        if (this.deviceTable != null) {
            if (this.select.getSelected() == 1) {
                if (this.deviceTable.getModel() != this.switchTableModel) {
                    this.deviceTable.setModel(this.switchTableModel);
                    this.switchTableModel.fireTableStructureChanged();
                    this.deviceTable.calcPreferredSize();
                }
            } else if (this.deviceTable.getModel() != this.deviceTableModel) {
                this.deviceTable.setModel(this.deviceTableModel);
                this.deviceTableModel.fireTableStructureChanged();
                this.deviceTable.calcPreferredSize();
            }
            this.pack();
        }
    }

    private Array updateData(boolean wwnSel) {
        Array<Object[]> data;
        block9: {
            block8: {
                data = new Array<Object[]>();
                if (wwnSel) break block8;
                Object[] sw = this.selVsan.getFabric().getSwitches();
                Arrays.sort(sw);
                if (sw == null) {
                    return data;
                }
                for (int i = 0; i < sw.length; ++i) {
                    Object[] ob = new Object[HEADERS_SWITCH.length + 3];
                    ob[0] = sw[i];
                    int[] indices = ((Switch)sw[i]).getIfCache().getXEIfIndeces();
                    StringBuffer buf = new StringBuffer();
                    String indiceWwn = "";
                    if (indices != null) {
                        for (int in = 0; in < indices.length; ++in) {
                            if (in > 0) {
                                buf.append(" ,");
                            } else {
                                indiceWwn = SnmpString.toHexString(((Switch)sw[i]).ifIndex2wwn(indices[in], ((Switch)sw[i]).getWwn().getValue()));
                            }
                            buf.append(((Switch)sw[i]).ifIndexToName(indices[in]));
                        }
                    }
                    ob[1] = buf;
                    ob[SmInsertPortSecurityDlg.HEADERS_SWITCH.length + 1] = ((Switch)sw[i]).getWwn();
                    ob[SmInsertPortSecurityDlg.HEADERS_SWITCH.length + 2] = indiceWwn;
                    data.addElement(ob);
                }
                ArrayList<Object> switches = new ArrayList<Object>();
                for (int i = 0; i < sw.length; ++i) {
                    if (!((AbstractSwitch)sw[i]).isMDS() || !((Switch)sw[i]).isManageable()) continue;
                    switches.add(sw[i]);
                }
                break block9;
            }
            EndPort[] ep = ClientController.getInstance().getFabric().getEndPorts();
            if (ep == null) break block9;
            for (int i = 0; i < ep.length; ++i) {
                if (IfIndexUtil.getType(ep[i].getSwitchIntKey()._index) != 1 || ep[i].isVirtualized() || !ep[i].isMemberOfVsan(this.selVsan)) continue;
                Object[] ob = new Object[HEADERS_WWN.length + 2];
                ob[2] = ep[i].getSwitch() + "(" + ep[i].getIfIndexName() + ")" + " (" + SnmpString.toHexString(ep[i].getSwitch().ifIndex2wwn(ep[i].getSwitchIntKey()._index, ep[i].getSwitch().getWwn().getValue())) + ")";
                ob[1] = ep[i];
                Switch sww = ep[i].getSwitch();
                ob[0] = SnmpString.toHexString(ep[i].getPortWwn().getValue());
                ob[SmInsertPortSecurityDlg.HEADERS_WWN.length + 1] = ep[i].getSwitch().ifIndex2wwn(ep[i].getIfIndex(), ep[i].getSwitch().getWwn().getValue());
                data.addElement(ob);
            }
        }
        return data;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch = e.getActionCommand().charAt(0);
        if (ch == 'C') {
            this.selectedWwn = null;
            this.selectedInterface = null;
            this.dispose();
        } else {
            if (ch == 'I') {
                if (this.portChooser != null) {
                    this.portChooser.dispose();
                }
                Switch sw = this.swMenuBtn.getSwitch(this.switchPanel.getText().trim());
                InetAddress address = null;
                if (sw == null) {
                    try {
                        address = InetAddress.getByName(this.switchPanel.getText().trim());
                        sw = this.selVsan.getFabric().findSwitchByIpAddress(address);
                        if (sw == null) {
                            Util.errorMessage((Component)this, "Please select a switch.");
                        }
                    }
                    catch (UnknownHostException ex) {
                        Util.errorMessage((Component)this, "Could not find switch " + this.switchPanel.getText().trim() + " in fabric.");
                        return;
                    }
                }
                this.portChooser = new IfPortChooser(this, sw);
                this.portChooser.setTitle(this.getTitle());
                this.portChooser.setType(3);
                this.portChooser.setIsFICON(false, sw.getPeer());
                this.portChooser.setLogicalInterfaceType(20);
                this.portChooser.setFilters(new PortEditorFilter(new int[]{1}));
                this.updatePortPicker(sw.getPeer(), this.portChooser);
                this.portChooser.showPortDialog((JComponent)e.getSource());
                this.updatePortPicker(sw.getPeer(), this.portChooser);
                return;
            }
            if (ch == 'O') {
                if (!this.validateData()) {
                    return;
                }
                this.dispose();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int row = this.deviceTable.getSelectedRow();
        if (row != -1) {
            if (this.select.getSelected() == 0) {
                byte[] v = (byte[])this.deviceTable.getModel().getValueAt(row, HEADERS_WWN.length + 1);
                this.switchInterface.setText(v == null ? "" : SnmpWWN.toHexString(v));
                this.pwwnOrSwitch.setText((String)this.deviceTable.getModel().getValueAt(row, 0));
                this.switchPanel.setText(((EndPort)this.deviceTable.getModel().getValueAt(row, 1)).getSwitch().toString());
            } else {
                Wwn swWwn = (Wwn)this.deviceTable.getModel().getValueAt(row, HEADERS_SWITCH.length + 1);
                this.pwwnOrSwitch.setText(SnmpString.toHexString(swWwn.getValue()));
                this.switchPanel.setText(this.deviceTable.getModel().getValueAt(row, 0).toString());
                this.switchInterface.setText((String)this.deviceTable.getModel().getValueAt(row, HEADERS_SWITCH.length + 2));
            }
        }
    }

    private boolean validateData() {
        String wwn = this.pwwnOrSwitch.getText().trim();
        try {
            this.selectedWwn = new Wwn(SnmpWWN.parse(wwn, false));
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this, "Invalid Port WWN.");
            return false;
        }
        try {
            this.selectedInterface = new Wwn(SnmpWWN.parse(this.switchInterface.getText().trim(), false));
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this, "Invalid Switch Interface WWN.");
            return false;
        }
        this.loginDevTpe = this.select.getSelected();
        return true;
    }

    boolean isWWNLoginDevSelected() {
        return this.loginDevTpe == 0;
    }

    boolean isSwitchLoginDevSelected() {
        return this.loginDevTpe == 1;
    }

    Wwn getWWN() {
        return this.selectedWwn;
    }

    Wwn getSelectedInterface() {
        return this.selectedInterface;
    }

    private void updatePortPicker(SnmpPeer peer, PortChooser chooser) {
        PortEditorCardAttribute[] slotMembers = this.findSlotInfo(peer);
        if (slotMembers == null) {
            return;
        }
        ClientController.getInstance();
        Switch sww = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sww != null) {
            chooser.setIfIndexIf(sww);
            chooser.setSlotMembers(slotMembers);
        }
    }

    private PortEditorCardAttribute[] findSlotInfo(SnmpPeer peer) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        Card[] cards = sw.getCards();
        if (cards == null) {
            return null;
        }
        PortEditorCardAttribute[] slotMembers = new PortEditorCardAttribute[sw.getNumSlots()];
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i] == null || cards[i].isFex()) continue;
            int nOfPortonCard = cards[i].getNumPorts();
            int[] ifTypes = new int[nOfPortonCard];
            for (int j = 0; j < nOfPortonCard; ++j) {
                ifTypes[j] = cards[i].getIfType(j + 1);
            }
            slotMembers[cards[i].getSlotId() - 1] = new PortEditorCardAttribute(cards[i].getType(), nOfPortonCard, ifTypes, 0, Integer.toString(cards[i].getSlotId()));
        }
        return slotMembers;
    }

    class IfPortChooser
    extends PortChooser
    implements PortChooserIf {
        Switch _sw;

        public IfPortChooser(JDialog dlg, Switch sw) {
            super(Util.getFrameAncestor(dlg));
            this._sw = sw;
            this.setTarget(this);
            this.setModal(true);
        }

        @Override
        public void portChooserCB(String ifName, Object context) {
            try {
                SmInsertPortSecurityDlg.this.switchInterface.setText(SnmpWWN.toHexString(this._sw.ifIndex2wwn(this._sw.nameToIfIndex(ifName), this._sw.getWwn().getValue())));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

