/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.jnm.JCalendarChooserPanel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigThread;
import com.cisco.dcbu.sm.client.datamig.DataMigWizard;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.actions.StorageDependent;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.ddm.DDMSwitch;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.cisco.dcbu.sm.common.rif.DMMException;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.dmm.Mediator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataMigJobPanel
extends DataMigConfigPanel
implements ActionListener,
ListSelectionListener,
ItemListener {
    static String[] _Labels = new String[]{"Job Name:", null, null, null, null, null, null, null, "Migration Type:", "Rate:", "Schedule:", "Date and Time:", "Method"};
    public static String[] _JobType = new String[]{"Online", "Offline"};
    public static final String[] _WhenSel = new String[]{"Manual", "Now", "Specify..."};
    static final String PORT_LIST_NAME = "Ports: (Name, VSAN, Fabric, Switch Interface)";
    static final String[] _Method = new String[]{"Method 1", "Method 2", "Method 3"};
    public static final int SCH_ACTION_NO_SCH = 0;
    public static final int SCH_ACTION_NOW = 1;
    public static final int SCH_ACTION_SCH = 2;
    public static final int ZONEPOLICY_DENY = 2;
    KTextField _jobName;
    JList _server;
    JScrollPane _serverSp;
    JList _serverPorts;
    JScrollPane _serverPortsSp;
    RadioButtonPanel _jobType;
    static final int JOBTYPE_ONLINE_POS = 0;
    static final int JOBTYPE_OFFLINE_POS = 1;
    static final int DMM_JOB_NAME_LEN = 50;
    RadioButtonPanel _rate;
    JList _oldStorage;
    JScrollPane _oldStorageSp;
    JList _oldStoragePorts;
    JScrollPane _oldStoragePortsSp;
    JButton _oldStorageDependentPorts;
    JList _newStorage;
    JScrollPane _newStorageSp;
    JList _newStoragePorts;
    JScrollPane _newStoragePortsSp;
    JButton _newStorageDependentPorts;
    JCalendarChooserPanel _scheduleDate;
    RadioButtonPanel _when;
    JLabel _labelDate;
    int _curServerSel = -1;
    EnclosureBase[] _oldStoragesData = null;
    EnclosureBase[] _newStoragesData = null;
    JButton _showSelection;
    RadioButtonPanel _method;
    static final int METHOD_SYNC_BUTTON_POS = 0;
    static final int METHOD_ASYNC_BUTTON_POS = 1;
    static final int METHOD_ASYNC_PLUS_BUTTON_POS = 2;
    DDMServerRif ddmServerRif = (DDMServerRif)this.getModelValue("ServerRif");
    static final int JOB_NAME = 0;
    static final int SERVER_SEPERATOR = 1;
    static final int SERVER_NAME = 2;
    static final int ES_STORAGE_SEPERATOR = 3;
    static final int OLD_STORAGE = 4;
    static final int NEW_STORAGE_SEPERATOR = 5;
    static final int NEW_STORAGE = 6;
    static final int OTHER_SEPERATOR = 7;
    static final int JOB_TYPE = 8;
    static final int RATE = 9;
    static final int WHEN = 10;
    static final int DATE = 11;
    static final int METHOD = 12;
    static final int COMP_SIZE = 13;

    public DataMigJobPanel(JWizard wizard, int migType) throws Exception {
        super("Step 1: Create Job", migType == -86 ? "Select a Server and its associated Existing and New storage enclosures." : "Select an Existing and New storage enclosure.", wizard, migType == -86 ? DataMigWizard._Image_Server : DataMigWizard._Image_Storage);
        JComponent[] labels = DialogUtil.buildLabels(_Labels);
        JComponent[] comps = new JComponent[13];
        EnclosureBase[] hosts = this.ddmServerRif.findAllHosts();
        String dateTimeStr = new SimpleDateFormat("yyyy/MM/dd-HH:mm").format(new Date());
        String defaultJobName = ClientController.getInstance().getFMUsername() + "_" + dateTimeStr;
        this._jobName = new KTextField(defaultJobName);
        this._jobName.setMaxLength(50);
        comps[0] = this._jobName;
        if ((hosts == null || hosts.length == 0) && migType == -86) {
            throw new Exception("Cannot find valid Host! Possible cause: all hosts are unaliased.");
        }
        this._curServerSel = this.validateServerSelection(hosts, true);
        int[] old_new_storage_sel = new int[2];
        this.preselectExistingNewStorage(this._oldStoragesData, this._newStoragesData, old_new_storage_sel);
        comps[1] = new DialogSeparator("Host");
        JComponent[] serverEncl = new JComponent[2];
        serverEncl[0] = new JLabel("Enclosure:");
        this._server = new JList<EnclosureBase>(hosts);
        this._server.setSelectedIndex(this._curServerSel);
        this._server.addListSelectionListener(this);
        this._server.setSelectionMode(0);
        this._serverSp = new JScrollPane(this._server);
        this._serverSp.setPreferredSize(new Dimension(200, 80));
        serverEncl[1] = this._serverSp;
        JPanel hostPanel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), serverEncl);
        JComponent[] serverPort = new JComponent[2];
        serverPort[0] = new JLabel(PORT_LIST_NAME);
        this._serverPorts = new JList();
        this._serverPorts.setSelectionMode(2);
        this._serverPorts.setCellRenderer(new EndPortCellRenderer());
        if (migType == -86) {
            this.updateEnclosurePortList(hosts[this._curServerSel], this._serverPorts);
        }
        this._serverPortsSp = new JScrollPane(this._serverPorts);
        this._serverPortsSp.setPreferredSize(new Dimension(450, 80));
        serverPort[1] = this._serverPortsSp;
        JPanel hostPortPanel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), serverPort);
        JPanel hostGrpPanel = new JPanel();
        hostGrpPanel.setLayout(new BoxLayout(hostGrpPanel, 0));
        hostGrpPanel.add(hostPanel);
        hostGrpPanel.add(hostPortPanel);
        comps[2] = hostGrpPanel;
        comps[1].setVisible(migType == -86);
        serverEncl[0].setVisible(migType == -86);
        this._server.setVisible(migType == -86);
        this._serverSp.setVisible(migType == -86);
        serverPort[0].setVisible(migType == -86);
        this._serverPorts.setVisible(migType == -86);
        this._serverPortsSp.setVisible(migType == -86);
        comps[2].setVisible(migType == -86);
        comps[3] = new DialogSeparator("Existing Storage");
        JComponent[] oldStorageEncl = new JComponent[2];
        oldStorageEncl[0] = new JLabel("Enclosure:");
        this._oldStorage = new JList<EnclosureBase>(this._oldStoragesData);
        this._oldStorage.setSelectedIndex(old_new_storage_sel[0]);
        this._oldStorage.addListSelectionListener(this);
        this._oldStorage.setSelectionMode(0);
        this._oldStorageSp = new JScrollPane(this._oldStorage);
        this._oldStorageSp.setPreferredSize(new Dimension(200, 80));
        oldStorageEncl[1] = this._oldStorageSp;
        JPanel oldStoragePanel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), oldStorageEncl);
        JComponent[] oldStoragePort = new JComponent[migType == -69 ? 3 : 2];
        oldStoragePort[0] = new JLabel(PORT_LIST_NAME);
        this._oldStoragePorts = new JList();
        this._oldStoragePorts.setSelectionMode(2);
        this._oldStoragePorts.setCellRenderer(new EndPortCellRenderer());
        this.updateEnclosurePortList(this._oldStoragesData[old_new_storage_sel[0]], this._oldStoragePorts);
        this._oldStoragePortsSp = new JScrollPane(this._oldStoragePorts);
        this._oldStoragePortsSp.setPreferredSize(new Dimension(450, 80));
        oldStoragePort[1] = this._oldStoragePortsSp;
        if (migType == -69) {
            this._oldStorageDependentPorts = new JButton("Show Dependent Ports");
            this._oldStorageDependentPorts.setActionCommand("OSP");
            this._oldStorageDependentPorts.addActionListener(this);
            oldStoragePort[2] = this._oldStorageDependentPorts;
        }
        JPanel oldStoragePortPanel = null;
        oldStoragePortPanel = migType == -69 ? DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null, null}), oldStoragePort) : DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), oldStoragePort);
        JPanel oldStorageGrpPanel = new JPanel();
        oldStorageGrpPanel.setLayout(new BoxLayout(oldStorageGrpPanel, 0));
        oldStorageGrpPanel.add(oldStoragePanel);
        oldStorageGrpPanel.add(oldStoragePortPanel);
        comps[4] = oldStorageGrpPanel;
        comps[5] = new DialogSeparator("New Storage");
        JComponent[] newStorageEncl = new JComponent[2];
        newStorageEncl[0] = new JLabel("Enclosure:");
        this._newStorage = new JList<EnclosureBase>(this._newStoragesData);
        this._newStorage.setSelectedIndex(old_new_storage_sel[1]);
        this._newStorage.addListSelectionListener(this);
        this._newStorage.setSelectionMode(0);
        this._newStorageSp = new JScrollPane(this._newStorage);
        this._newStorageSp.setPreferredSize(new Dimension(200, 80));
        newStorageEncl[1] = this._newStorageSp;
        JPanel newStoragePanel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), newStorageEncl);
        JComponent[] newStoragePort = new JComponent[migType == -69 ? 3 : 2];
        newStoragePort[0] = new JLabel(PORT_LIST_NAME);
        this._newStoragePorts = new JList();
        this._newStoragePorts.setSelectionMode(2);
        this._newStoragePorts.setCellRenderer(new EndPortCellRenderer());
        this.updateEnclosurePortList(this._newStoragesData[old_new_storage_sel[1]], this._newStoragePorts);
        this._newStoragePortsSp = new JScrollPane(this._newStoragePorts);
        this._newStoragePortsSp.setPreferredSize(new Dimension(450, 80));
        newStoragePort[1] = this._newStoragePortsSp;
        if (migType == -69) {
            this._newStorageDependentPorts = new JButton("Show Dependent Ports");
            this._newStorageDependentPorts.setActionCommand("NSP");
            this._newStorageDependentPorts.addActionListener(this);
            this._newStorageDependentPorts.setVisible(migType == -69);
            newStoragePort[2] = this._newStorageDependentPorts;
        }
        JPanel newStoragePortPanel = null;
        newStoragePortPanel = migType == -69 ? DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null, null}), newStoragePort) : DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), newStoragePort);
        JPanel newStorageGrpPanel = new JPanel();
        newStorageGrpPanel.setLayout(new BoxLayout(newStorageGrpPanel, 0));
        newStorageGrpPanel.add(newStoragePanel);
        newStorageGrpPanel.add(newStoragePortPanel);
        comps[6] = newStorageGrpPanel;
        comps[7] = new DialogSeparator();
        this._jobType = new RadioButtonPanel(_JobType);
        comps[8] = this._jobType;
        this._jobType.setSelected(0);
        this._jobType.addChangeListener(this);
        this._rate = new RadioButtonPanel(Mediator.DMM_JOB_Rates, Mediator.DMM_JOB_Rates.length);
        comps[9] = this._rate;
        this._rate.setSelected(0);
        this._when = new RadioButtonPanel(_WhenSel);
        comps[10] = this._when;
        this._when.addChangeListener(this);
        this._labelDate = labels[11];
        this._labelDate.setVisible(false);
        this._scheduleDate = new JCalendarChooserPanel(10, "Migration Session Start Date");
        comps[11] = this._scheduleDate;
        this._scheduleDate.initializeDate("MM/dd/yyyy");
        this._scheduleDate.setVisible(false);
        this._scheduleDate.getSecondSpinner().setVisible(false);
        this._scheduleDate.getHmsLabel().setText(" hh:mm ");
        this._method = new RadioButtonPanel(_Method);
        comps[12] = this._method;
        this._showSelection = new JButton("Show Selection...");
        this._showSelection.addActionListener(this);
        this._showSelection.setActionCommand("selection");
        JPanel p = DialogUtil.buildTablePanel(labels, comps);
        p.add(this._showSelection);
        this.add((Component)p, "Center");
    }

    int validateServerSelection(EnclosureBase[] hosts, boolean initialTry) throws Exception {
        int migType = (Integer)this.getModelValue("dmType");
        EnclosureBase[] oldStorages = null;
        EnclosureBase[] newStorages = null;
        if (migType == -86) {
            for (int i = 0; i < hosts.length; ++i) {
                oldStorages = migType == -86 ? this.ddmServerRif.findAllStoragePortsByHost(hosts[i], true, false) : this.ddmServerRif.findAllStoragePortsByHost(null, false, true);
                newStorages = migType == -86 ? this.ddmServerRif.findAllStoragePortsByHost(null, false, true) : this.ddmServerRif.findAllStoragePortsByHost(null, false, true);
                if (oldStorages == null || oldStorages.length == 0 || newStorages == null || newStorages.length == 0) continue;
                this._oldStoragesData = oldStorages;
                this._newStoragesData = newStorages;
                return i;
            }
        } else {
            this._oldStoragesData = this.ddmServerRif.findAllStoragePortsByHost(null, false, true);
            oldStorages = this._oldStoragesData;
            this._newStoragesData = this.ddmServerRif.findAllStoragePortsByHost(null, false, true);
            newStorages = this._newStoragesData;
        }
        if (oldStorages == null || oldStorages.length == 0) {
            throw new Exception("cannot find any valid Existing Storage" + (migType == -86 && !initialTry ? " for the selected Host!" : "!"));
        }
        if (newStorages == null || newStorages.length == 0) {
            throw new Exception("cannot find any valid New Storage" + (migType == -86 && !initialTry ? " for the selected Host!" : "!"));
        }
        return -1;
    }

    void preselectExistingNewStorage(EnclosureBase[] oldStorages, EnclosureBase[] newStorages, int[] old_new_storage_sel) throws Exception {
        old_new_storage_sel[0] = 0;
        old_new_storage_sel[1] = newStorages.length > 1 ? 1 : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String cmd = e.getActionCommand();
            DDMServerRif ddmServerRif = (DDMServerRif)this.getModelValue("ServerRif");
            if (cmd.equals("OSP") || cmd.equals("NSP")) {
                EndPortBase[] selectedPorts = null;
                selectedPorts = cmd.equals("OSP") ? this.getSelectedEndPort(this._oldStoragePorts) : this.getSelectedEndPort(this._newStoragePorts);
                if (selectedPorts == null) throw new Exception("Cannot find any dependent Host Ports!");
                ArrayList<EndPort> endPorts = new ArrayList<EndPort>(selectedPorts.length);
                for (int i = 0; i < selectedPorts.length; ++i) {
                    endPorts.add(ClientController.findFabricEndPortByWwn(selectedPorts[i].getEndPortPK()._wwn));
                }
                StorageDependent.getInstance().selectDependentHosts(endPorts, null);
                return;
            } else {
                if (!cmd.equals("selection")) return;
                this.showSelection();
            }
            return;
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
            if (!SnmpSession.isTrace()) return;
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void showSelection() {
        JDialog dialog = new JDialog(this.getWizard(), "Selected Ports", true);
        dialog.setLayout(new GridLayout(0, 1));
        dialog.setPreferredSize(new Dimension(500, 400));
        dialog.setMinimumSize(new Dimension(500, 400));
        int migType = (Integer)this.getModelValue("dmType");
        if (migType == -86) {
            JPanel hostPanel = this.buildSubPanel("Host", this._server, this._serverPorts);
            dialog.add(hostPanel);
        }
        JPanel esPanel = this.buildSubPanel("Existing Storage", this._oldStorage, this._oldStoragePorts);
        JPanel nsPanel = this.buildSubPanel("New Storage", this._newStorage, this._newStoragePorts);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(new JButton("Close"));
        dialog.add(esPanel);
        dialog.add(nsPanel);
        dialog.setLocationRelativeTo(BrowserFrame.getInstance());
        dialog.pack();
        dialog.setVisible(true);
    }

    private JPanel buildSubPanel(String separator, JList selection, JList list) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new DialogSeparator(separator), "North");
        JLabel s = new JLabel(selection.getSelectedValue().toString() + "         ");
        panel.add((Component)s, "West");
        JList<Object> ss = new JList<Object>(list.getSelectedValues());
        panel.add(ss, "Center");
        return panel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        block13: {
            boolean selected;
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList src = (JList)e.getSource();
            boolean bl = selected = src.getSelectedIndices().length > 0;
            if (!selected) {
                return;
            }
            if (src == this._server) {
                try {
                    EnclosureBase host = (EnclosureBase)this._server.getSelectedValue();
                    int curServerSel = this._server.getSelectedIndex();
                    if (curServerSel == this._curServerSel) {
                        return;
                    }
                    this.validateServerSelection(new EnclosureBase[]{host}, false);
                    this._curServerSel = curServerSel;
                    this.updateEnclosurePortList(host, this._serverPorts);
                    int[] old_new_storage_sel = new int[2];
                    this.preselectExistingNewStorage(this._oldStoragesData, this._newStoragesData, old_new_storage_sel);
                    this._oldStorage.setListData(this._oldStoragesData);
                    this._oldStorage.setSelectedIndex(old_new_storage_sel[0]);
                    this._newStorage.setListData(this._newStoragesData);
                    this._newStorage.setSelectedIndex(old_new_storage_sel[1]);
                }
                catch (Exception ex) {
                    this._server.setSelectedIndex(this._curServerSel);
                    Util.errorMessage((Component)this, ex);
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    break block13;
                }
            }
            if (src == this._oldStorage) {
                EnclosureBase oldStorage = (EnclosureBase)this._oldStorage.getSelectedValue();
                try {
                    this.updateEnclosurePortList(oldStorage, this._oldStoragePorts);
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, ex);
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    break block13;
                }
            }
            EnclosureBase newStorage = (EnclosureBase)this._newStorage.getSelectedValue();
            try {
                this.updateEnclosurePortList(newStorage, this._newStoragePorts);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block13;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    void updateEnclosurePortList(EnclosureBase enclosure, JList portList) throws Exception {
        Object[] ports = this.ddmServerRif.getEndPorts(enclosure);
        Arrays.sort(ports);
        portList.setListData(ports);
        portList.addSelectionInterval(0, ports.length - 1);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        boolean isschedule = this._when.getSelected() == 2;
        this._labelDate.setVisible(isschedule);
        this._scheduleDate.setVisible(isschedule);
        int selJobType = this._jobType.getSelected();
        this._method.getButton(1).setEnabled(selJobType == 0);
        this._method.getButton(2).setEnabled(selJobType == 0);
        int selMethod = this._method.getSelected();
        if (selJobType == 1 && (selMethod == 1 || selMethod == 2)) {
            this._method.setSelected(0);
        }
    }

    @Override
    public void doNext() {
        this._cfgThread = new ConfigJobThread(this.getWizard());
        this._cfgThread.start();
    }

    boolean validDMMSwitchVsan(Integer[] hostStorageVsans, DDMSwitch sw, boolean isSingleFabric) {
        short[] vsans = sw.getSwitch().getVsanIds();
        if (vsans == null) {
            return false;
        }
        if (isSingleFabric) {
            for (int i = 0; i < vsans.length; ++i) {
                for (int j = 0; j < hostStorageVsans.length; ++j) {
                    if (vsans[i] != hostStorageVsans[j]) continue;
                    return true;
                }
            }
            return false;
        }
        for (int i = 0; i < hostStorageVsans.length; ++i) {
            boolean hoststorageSubVsan = false;
            for (int j = 0; j < vsans.length; ++j) {
                if (hostStorageVsans[i] != vsans[j]) continue;
                hoststorageSubVsan = true;
                break;
            }
            if (hoststorageSubVsan) continue;
            return false;
        }
        return true;
    }

    EndPortBase[] getSelectedEndPort(JList portList) {
        Object[] selPorts = portList.getSelectedValues();
        ArrayList<Object> selPortsList = new ArrayList<Object>();
        for (int i = 0; i < selPorts.length; ++i) {
            selPortsList.add(selPorts[i]);
        }
        return selPortsList.toArray(new EndPortBase[selPortsList.size()]);
    }

    private Integer[] getVsans(EndPortBase[] ports, FabricPK fabricPK) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < ports.length; ++i) {
            short[] vsans;
            if (ports[i] == null || !ports[i].getFabricPK().equals(fabricPK) || (vsans = ports[i].getVsanMembership()) == null) continue;
            for (int j = 0; j < vsans.length; ++j) {
                Integer vsanId = new Integer(vsans[j]);
                map.put(vsanId, vsanId);
            }
        }
        Set ret = map.keySet();
        return ret.size() != 0 ? ret.toArray(new Integer[ret.size()]) : null;
    }

    void checkStorage(EndPortBase[] selStoragePorts) throws Exception {
        HashedArrayList<EndPort> epErrorList = new HashedArrayList<EndPort>();
        for (int i = 0; i < selStoragePorts.length; ++i) {
            WwnKey pk = selStoragePorts[i].getEndPortPK();
            EndPort ep = ClientController.findFabricEndPortByWwn(pk._wwn);
            if (ep == null || ep.isPresent()) continue;
            ((ArrayList)epErrorList).add(ep);
        }
        if (epErrorList.size() != 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("Following storage port(s) in Enclosure " + (epErrorList.size() == 1 ? "is" : "are") + " down.\n");
            buf.append("Please bring " + (epErrorList.size() == 1 ? "it" : "them") + " up before restart the wizard:\n");
            for (int i = 0; i < epErrorList.size(); ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(((EndPort)epErrorList.get(i)).toString());
            }
            throw new Exception(buf.toString());
        }
    }

    void ValidateSSM4SingleFabricMultiVsan(DDMSwitch[] ssms, Integer[] hostStorageSVsans) throws Exception {
        int row2 = -1;
        for (int row1 = 0; row1 < ssms.length; ++row1) {
            short[] vsan1 = ssms[row1].getSwitch().getVsanIds();
            ArrayList<Integer> vsan2List = new ArrayList<Integer>();
            for (int j = 0; j < hostStorageSVsans.length; ++j) {
                boolean findThisVsan = false;
                for (int k = 0; k < vsan1.length; ++k) {
                    if (vsan1[k] != hostStorageSVsans[j]) continue;
                    findThisVsan = true;
                    break;
                }
                if (findThisVsan) continue;
                vsan2List.add(hostStorageSVsans[j]);
            }
            if (vsan2List.size() == 0) {
                int[] rows1 = new int[]{row1};
                this.setModelValue("singleFabricMultiVsanTable1RowSelectionList", rows1);
                return;
            }
            for (int i = row1 + 1; i < ssms.length; ++i) {
                short[] vsan2 = ssms[i].getSwitch().getVsanIds();
                boolean findSSM2 = true;
                for (int j = 0; j < vsan2List.size(); ++j) {
                    boolean findThisVsan = false;
                    for (int k = 0; k < vsan2.length; ++k) {
                        if (vsan2[k] != (Integer)vsan2List.get(j)) continue;
                        findThisVsan = true;
                        break;
                    }
                    if (findThisVsan) continue;
                    findSSM2 = false;
                    break;
                }
                if (!findSSM2) continue;
                row2 = i;
                break;
            }
            if (row2 == -1) continue;
            int[] rows1 = new int[]{row1, row2};
            this.setModelValue("singleFabricMultiVsanTable1RowSelectionList", rows1);
            return;
        }
        if (row2 == -1) {
            throw new Exception("Cannot find any SSM sets that contain required VSAN membership!");
        }
    }

    FabricPK[] findAllFabricForEndPortList(EndPortBase[] endPorts) {
        HashedArrayList<FabricPK> fabricList = new HashedArrayList<FabricPK>();
        for (int i = 0; i < endPorts.length; ++i) {
            FabricPK fb = endPorts[i].getFabricPK();
            if (((ArrayList)fabricList).contains(fb)) continue;
            ((ArrayList)fabricList).add(fb);
        }
        return fabricList.toArray(new FabricPK[fabricList.size()]);
    }

    class EndPortCellRenderer
    extends DefaultListCellRenderer {
        EndPortCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            StringBuffer buf = new StringBuffer();
            EndPortBase ep = (EndPortBase)value;
            buf.append(ClientController.findFabricEndPortByWwn(ep.getEndPortPK()._wwn));
            buf.append(", ");
            buf.append(ep.getVsansAsString());
            buf.append(", ");
            buf.append(San.getInstance().getFabric(ep.getFabricPK()));
            buf.append(", ");
            Switch sw = ClientController.findFabricSwitchByWwn(ep.getSwitchPK()._wwn);
            buf.append(sw);
            buf.append(" ");
            buf.append(sw.ifIndexToName(ep.getIfIndex()));
            this.setText(buf.toString());
            return retValue;
        }
    }

    class ConfigJobThread
    extends DataMigConfigThread {
        public ConfigJobThread(JWizard wizard) {
            super(wizard);
        }

        @Override
        public void run() {
            try {
                int migType = (Integer)DataMigJobPanel.this.getModelValue("dmType");
                byte method = -18;
                if (DataMigJobPanel.this._method.getSelected() == 1) {
                    method = -1;
                } else if (DataMigJobPanel.this._method.getSelected() == 2) {
                    method = -35;
                }
                DataMigJobPanel.this.setModelValue("jobMethod", new Byte(method));
                this.setupConfigStatus(true, false, null);
                DataMigJobPanel.this.setDataValid(false);
                String name = DataMigJobPanel.this._jobName.getText();
                if (name.length() == 0) {
                    throw new Exception("Please enter a valid Job Name!");
                }
                DataMigJobPanel.this.setModelValue("jobName", name);
                EnclosureBase host = (EnclosureBase)DataMigJobPanel.this._server.getSelectedValue();
                if (host == null && migType == -86) {
                    throw new Exception("Please select a Host!");
                }
                DataMigJobPanel.this.setModelValue("server", host);
                int serverPortSize = DataMigJobPanel.this._serverPorts.getModel().getSize();
                EndPortBase[] selServerPorts = DataMigJobPanel.this.getSelectedEndPort(DataMigJobPanel.this._serverPorts);
                DataMigJobPanel.this.setModelValue("serverPorts", selServerPorts);
                EnclosureBase oldStorage = (EnclosureBase)DataMigJobPanel.this._oldStorage.getSelectedValue();
                if (oldStorage == null) {
                    throw new Exception("Please select an Existing Storage!");
                }
                EnclosureBase newStorage = (EnclosureBase)DataMigJobPanel.this._newStorage.getSelectedValue();
                if (newStorage == null) {
                    throw new Exception("Please select a New Storage!");
                }
                int oldStroagePortSize = DataMigJobPanel.this._oldStoragePorts.getModel().getSize();
                EndPortBase[] selOldStoragePorts = DataMigJobPanel.this.getSelectedEndPort(DataMigJobPanel.this._oldStoragePorts);
                int newStroagePortSize = DataMigJobPanel.this._newStoragePorts.getModel().getSize();
                EndPortBase[] selNewStoragePorts = DataMigJobPanel.this.getSelectedEndPort(DataMigJobPanel.this._newStoragePorts);
                if (oldStorage.equals(newStorage)) {
                    for (int i = 0; i < selOldStoragePorts.length; ++i) {
                        for (int j = 0; j < selNewStoragePorts.length; ++j) {
                            if (!selOldStoragePorts[i].equals(selNewStoragePorts[j])) continue;
                            throw new Exception("Cannot select same port for the same enclosure for both the Existing and New Storage!");
                        }
                    }
                }
                DataMigJobPanel.this.checkStorage(selOldStoragePorts);
                DataMigJobPanel.this.checkStorage(selNewStoragePorts);
                DataMigJobPanel.this.setModelValue("oldStorage", oldStorage);
                if (oldStroagePortSize != selOldStoragePorts.length) {
                    DataMigJobPanel.this.setModelValue("oldStoragePorts", selOldStoragePorts);
                } else {
                    DataMigJobPanel.this.setModelValue("oldStoragePorts", null);
                }
                DataMigJobPanel.this.setModelValue("newStorage", newStorage);
                if (newStroagePortSize != selNewStoragePorts.length) {
                    DataMigJobPanel.this.setModelValue("newStoragePorts", selNewStoragePorts);
                } else {
                    DataMigJobPanel.this.setModelValue("newStoragePorts", null);
                }
                if (serverPortSize == 0 && migType == -86) {
                    throw new Exception("Please select Port(s) for the Host!");
                }
                if (oldStroagePortSize == 0) {
                    throw new Exception("Please select Port(s) for the Existing Storage!");
                }
                if (newStroagePortSize == 0) {
                    throw new Exception("Please select Port(s) for the New Storage!");
                }
                FabricPK[] fbsHost = DataMigJobPanel.this.findAllFabricForEndPortList(selServerPorts);
                FabricPK[] fbsES = DataMigJobPanel.this.findAllFabricForEndPortList(selOldStoragePorts);
                FabricPK[] fbsNS = DataMigJobPanel.this.findAllFabricForEndPortList(selNewStoragePorts);
                if ((fbsHost == null || fbsHost.length == 0) && migType == -86) {
                    throw new Exception("Cannot find valid fabric information for Host Port(s) selection!");
                }
                if (fbsES == null || fbsES.length == 0 || fbsNS == null || fbsNS.length == 0) {
                    throw new Exception("Cannot find valid fabric information for Existing Storage or New Storage Port(s) selection!");
                }
                if (((DataMigWizard)DataMigJobPanel.this.getWizard()).isMethod3()) {
                    this.method3Checks(migType, method, selServerPorts, selOldStoragePorts, selNewStoragePorts, fbsHost, fbsES, fbsNS);
                    if (!((Boolean)DataMigJobPanel.this.getModelValue("singleFabricMultiVsan")).booleanValue()) {
                        this.migrationFabricCheck(selOldStoragePorts);
                        this.migrationFabricCheck(selNewStoragePorts);
                    }
                } else {
                    this.nonMethod3Checks(migType, method, selServerPorts, selOldStoragePorts, selNewStoragePorts, fbsHost, fbsES, fbsNS);
                }
                this.setupConfigStatus(false, false, null);
                DataMigJobPanel.this.goNext();
            }
            catch (Exception ex) {
                if (!this.keepRunning(DataMigJobPanel.this._cfgThread)) {
                    return;
                }
                this.setupConfigStatus(false, false, ex);
                return;
            }
        }

        private void zonePolicyCheck(FabricPK fb, int vsanId) throws Exception {
            Fabric fabric = San.getInstance().getFabric(fb);
            Vsan[] vsans = fabric.getVsansById(vsanId);
            StringBuffer err = new StringBuffer();
            ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
            for (Vsan vsan : vsans) {
                Switch[] switches;
                for (Switch sw : switches = vsan.getSwitches()) {
                    if (sw.isUCS() || sw.isNpvEnabled()) continue;
                    peers.add(sw.getPeer());
                }
            }
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("zoneDefaultZoneBehaviour").getOid(), vsanId);
            boolean failed = false;
            HashMap<SnmpPeer, Exception> errors = new HashMap<SnmpPeer, Exception>();
            try {
                SnmpPDU[] pdus;
                for (SnmpPDU pdu : pdus = new SnmpAggregrate().get(peers.toArray(new SnmpPeer[0]), vbl)) {
                    int policy;
                    VarBindList response;
                    if (pdu.getError() != 0) {
                        errors.put(pdu.getPeer(), new SnmpException(SnmpException.toError(pdu.getError())));
                    }
                    if ((response = pdu.getVariables()) == null || response.isEmpty() || response.isNull(0)) {
                        errors.put(pdu.getPeer(), new SnmpException("Could not get default zone policy for VSAN " + vsanId));
                    }
                    if ((policy = response.intValue(0)) == 2) continue;
                    errors.put(pdu.getPeer(), new Exception(pdu.getAddress().getHostName() + ": The default zone policy for VSAN " + vsanId + " is set to PERMIT."));
                }
            }
            catch (Exception ex) {
                err.append(ex.getMessage());
                failed = true;
            }
            for (Exception e : errors.values()) {
                err.append(e.getMessage() + "\n");
                failed = true;
            }
            if (failed) {
                throw new Exception("Default zone policy check:\n" + err + "\n Please set the default zone policy to DENY for all the switches in  VSAN " + vsanId);
            }
        }

        private void migrationFabricCheck(EndPortBase[] selectedPorts) throws Exception {
            int isMigFabric = 0;
            FabricPK migFabric = ((FabricPK[])DataMigJobPanel.this.getModelValue("migrationFabric"))[0];
            for (int i = 0; i < selectedPorts.length; ++i) {
                FabricPK fabric = selectedPorts[i].getFabricPK();
                if (!fabric.equals(migFabric) || ++isMigFabric <= 1) continue;
                throw new Exception("Cannot select more than one storage port from fabric: " + migFabric);
            }
        }

        private void method3Checks(int migType, byte method, EndPortBase[] selServerPorts, EndPortBase[] selOldStoragePorts, EndPortBase[] selNewStoragePorts, FabricPK[] fbsHost, FabricPK[] fbsES, FabricPK[] fbsNS) throws Exception, RemoteException {
            boolean isFb1V2;
            int i;
            Map hosts1;
            String hostStr;
            boolean isSingleFabricMultiVsan;
            if (fbsHost.length > 2 && migType == -86) {
                throw new Exception("Data Migration does not support job across more than 2 fabrics!");
            }
            if (fbsES.length > 3) {
                throw new Exception("Data Migration does not support job across more than 3 fabrics!");
            }
            if (fbsNS.length > 1) {
                throw new Exception("New Storage Port must belong to only one fabric!");
            }
            if (migType != -86 || fbsHost.length != fbsES.length) {
                // empty if block
            }
            if (migType == -86) {
                for (int i2 = 0; i2 < fbsHost.length; ++i2) {
                    boolean findFabric = false;
                    for (int j = 0; j < fbsES.length; ++j) {
                        if (!fbsES[j].equals(fbsHost[i2])) continue;
                        findFabric = true;
                        break;
                    }
                    if (findFabric) continue;
                    throw new Exception("Host and Existing Storage Port(s) selection do not contain same Fabric membership!");
                }
            }
            FabricPK[] fbs = migType == -86 ? fbsHost : fbsES;
            DataMigJobPanel.this.setModelValue("fabricsConnected", fbs);
            DataMigJobPanel.this.setModelValue("migrationFabric", fbsNS);
            ArrayList<FabricPK> prodFabrics = new ArrayList<FabricPK>();
            for (int i3 = 0; i3 < fbs.length; ++i3) {
                if (fbs[i3].equals(fbsNS[0])) continue;
                prodFabrics.add(fbs[i3]);
            }
            boolean bl = isSingleFabricMultiVsan = prodFabrics.size() == 0;
            if (isSingleFabricMultiVsan) {
                prodFabrics.add(fbs[0]);
                DataMigJobPanel.this.setModelValue("migrationFabric", fbs);
            }
            DataMigJobPanel.this.setModelValue("productionFabric", prodFabrics.toArray(new FabricPK[0]));
            DataMigJobPanel.this.setModelValue("dualFabric", new Boolean(prodFabrics.size() > 1));
            String string = hostStr = migType == -86 ? "Host/" : "";
            if (isSingleFabricMultiVsan) {
                Map hosts = DataMigJobPanel.this.ddmServerRif.getServerHosts(method, selOldStoragePorts, selNewStoragePorts, fbs[0]);
                EnclosureBase newStorage = (EnclosureBase)DataMigJobPanel.this._newStorage.getSelectedValue();
                for (EnclosureBase host : hosts.values()) {
                    EnclosureBase[] list = DataMigJobPanel.this.ddmServerRif.findAllStoragePortsByHostZone(host, true, false);
                    List<EnclosureBase> coll = Arrays.asList(list);
                    if (!coll.contains(newStorage)) continue;
                    DefaultLogger._ExLogger.warn((Object)("Host and New Storage Port(s) selection are zoned in a common VSAN or belong to same enclosure. Host= " + host + " NS enclosure= " + newStorage));
                    throw new Exception("Host and New Storage Port(s) selection are zoned in a common VSAN.");
                }
            }
            String vsanErrStr = hostStr + "Existing Storage Port(s) and " + hostStr + "New Storage Port(s) need to contain same VSAN memebership in Fabric ";
            Map hosts = hosts1 = DataMigJobPanel.this.ddmServerRif.getServerHosts(method, selOldStoragePorts, selNewStoragePorts, (FabricPK)prodFabrics.get(0));
            if (prodFabrics.size() > 1) {
                Map hosts2 = DataMigJobPanel.this.ddmServerRif.getServerHosts(method, selOldStoragePorts, selNewStoragePorts, (FabricPK)prodFabrics.get(1));
                for (EnclosureBase host : hosts2.keySet()) {
                    if (hosts1.get(host) != null) continue;
                    hosts.put(host, host);
                }
            }
            ArrayList<EndPortBase> hostPorts = new ArrayList<EndPortBase>();
            for (EnclosureBase host : hosts.values()) {
                if (migType == -86) {
                    hostPorts.addAll(Arrays.asList(DataMigJobPanel.this.ddmServerRif.getEndPorts(host, fbs)));
                    continue;
                }
                hostPorts.addAll(Arrays.asList(DataMigJobPanel.this.ddmServerRif.getEndPorts(host)));
            }
            Integer[] hostESVsans1 = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership(hostPorts.toArray(new EndPortBase[0]), selOldStoragePorts, (FabricPK)prodFabrics.get(0));
            Integer[] ESNSVsans = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership(selNewStoragePorts, selOldStoragePorts, fbsNS[0]);
            if (hostESVsans1.length < 1) {
                throw new DMMException("Host and existing storage are either not zoned or not contained in the same vsan");
            }
            if (ESNSVsans.length < 1) {
                throw new DMMException("Existing and New storage are either not zoned or not contained in the same vsan as the Data Mover SSM");
            }
            DataMigJobPanel.this.setModelValue("singleFabricMultiVsanHostStorageVsans", hostESVsans1);
            Fabric fb = San.getInstance().getFabric((FabricPK)prodFabrics.get(0));
            boolean zoneExists = false;
            block11: for (i = 0; i < hostESVsans1.length; ++i) {
                Vsan[] vsans = fb.getVsansById(hostESVsans1[i]);
                for (int j = 0; j < vsans.length; ++j) {
                    EnforcedZone[] zones = vsans[j].getEnforcedZones();
                    if (zones.length <= 0) continue;
                    zoneExists = true;
                    continue block11;
                }
            }
            if (!zoneExists) {
                throw new Exception("Host and existing storage port do not belong to a common zone in fabric " + fbs[0] + "!");
            }
            for (i = 0; i < hostESVsans1.length; ++i) {
                this.zonePolicyCheck((FabricPK)prodFabrics.get(0), hostESVsans1[i]);
            }
            String type = (String)DataMigJobPanel.this._jobType.getSelectedValue();
            DataMigJobPanel.this.setModelValue("type", type);
            String rate = (String)DataMigJobPanel.this._rate.getSelectedValue();
            DataMigJobPanel.this.setModelValue("rate", rate);
            int scheduleActionSel = DataMigJobPanel.this._when.getSelected();
            if (scheduleActionSel == 2) {
                DataMigJobPanel.this._scheduleDate.getValidDate("MM/dd/yyyy");
                Date selectedDate = DataMigJobPanel.this._scheduleDate.getSelectedDate();
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                Date currentTime = cal.getTime();
                cal.setTime(selectedDate);
                cal.set(11, DataMigJobPanel.this._scheduleDate.getHour());
                cal.set(12, DataMigJobPanel.this._scheduleDate.getMin());
                cal.set(13, DataMigJobPanel.this._scheduleDate.getSec());
                Date schTime = cal.getTime();
                if (schTime.compareTo(currentTime) < 0) {
                    throw new Exception("Cannot schedule a job in the past!");
                }
                DataMigJobPanel.this.setModelValue("jobDate", schTime);
            }
            switch (scheduleActionSel) {
                case 0: {
                    DataMigJobPanel.this.setModelValue("jobScheduleAction", new Byte(1));
                    break;
                }
                case 1: {
                    DataMigJobPanel.this.setModelValue("jobScheduleAction", new Byte(2));
                    break;
                }
                case 2: {
                    DataMigJobPanel.this.setModelValue("jobScheduleAction", new Byte(0));
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataMigJobPanel.this.getWizard().setStatus("Retrieving SSM information...");
                }
            });
            ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
            DDMSwitch[] sws1 = DataMigJobPanel.this.ddmServerRif.findAllDDMEnabledSwitch((FabricPK)prodFabrics.get(0), true, method);
            boolean bl2 = isFb1V2 = modelFacadeRif.getFabricCredentials((FabricPK)prodFabrics.get(0)) == null;
            if (sws1 == null || sws1.length == 0) {
                throw new Exception("Cannot find any SSM card in " + prodFabrics.get(0) + (isFb1V2 ? ": opened with SNMPv2c." : ".") + " (The minimum supported NX-OS version for DMM is " + "6.2(1)" + ")");
            }
            ArrayList<DDMSwitch> swlist1 = new ArrayList<DDMSwitch>();
            for (int i4 = 0; i4 < sws1.length; ++i4) {
                if (!DataMigJobPanel.this.validDMMSwitchVsan(hostESVsans1, sws1[i4], prodFabrics.size() == 1)) continue;
                swlist1.add(sws1[i4]);
            }
            if (swlist1.size() == 0) {
                throw new Exception("Cannot find any SSM card in Fabric " + prodFabrics.get(0) + " that contain any VSAN memebership as the Host/Storage!");
            }
            sws1 = swlist1.toArray(new DDMSwitch[swlist1.size()]);
            boolean bl3 = isSingleFabricMultiVsan = fbs.length < 3;
            if (isSingleFabricMultiVsan) {
                DataMigJobPanel.this.ValidateSSM4SingleFabricMultiVsan(sws1, hostESVsans1);
            }
            DataMigJobPanel.this.setModelValue("singleFabricMultiVsan", new Boolean(isSingleFabricMultiVsan));
            DataMigJobPanel.this.setModelValue("fabrics1DMMSwitch", sws1);
            DataMigJobPanel.this.setModelValue("singleFabricMultiVsanHostStorageVsans", hostESVsans1);
            if (prodFabrics.size() > 1) {
                int i5;
                boolean isFb2V2;
                Integer[] hostESVsans2 = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership(hostPorts.toArray(new EndPortBase[0]), selOldStoragePorts, (FabricPK)prodFabrics.get(1));
                DDMSwitch[] sws2 = DataMigJobPanel.this.ddmServerRif.findAllDDMEnabledSwitch((FabricPK)prodFabrics.get(1), true, method);
                boolean bl4 = isFb2V2 = modelFacadeRif.getFabricCredentials((FabricPK)prodFabrics.get(1)) == null;
                if (sws2 == null || sws2.length == 0) {
                    throw new Exception("Cannot find any SSM card in " + prodFabrics.get(1) + (isFb2V2 ? ": opened with SNMPv2c." : ".") + " (The minimum supported NX-OS version for DMM is " + "6.2(1)" + ")");
                }
                ArrayList<DDMSwitch> swlist2 = new ArrayList<DDMSwitch>();
                for (i5 = 0; i5 < sws2.length; ++i5) {
                    if (!DataMigJobPanel.this.validDMMSwitchVsan(hostESVsans2, sws2[i5], false)) continue;
                    swlist2.add(sws2[i5]);
                }
                if (swlist2.size() == 0) {
                    throw new Exception("Cannot find any SSM card in Fabric " + prodFabrics.get(1) + " that contain any VSAN memebership as the Host/Storage!");
                }
                for (i5 = 0; i5 < hostESVsans2.length; ++i5) {
                    this.zonePolicyCheck((FabricPK)prodFabrics.get(1), hostESVsans2[i5]);
                }
                sws2 = swlist2.toArray(new DDMSwitch[swlist2.size()]);
                DataMigJobPanel.this.setModelValue("fabrics2DMMSwitch", sws2);
            }
        }

        private void nonMethod3Checks(int migType, byte method, EndPortBase[] selServerPorts, EndPortBase[] selOldStoragePorts, EndPortBase[] selNewStoragePorts, FabricPK[] fbsHost, FabricPK[] fbsES, FabricPK[] fbsNS) throws Exception, RemoteException {
            boolean isSingleFabricMultiVsan;
            boolean isFb1V2;
            int j;
            boolean findFabric;
            int i;
            if (fbsHost.length > 2 && migType == -86) {
                throw new Exception("Data Migration does not support job across more than 2 fabrics!");
            }
            if (fbsES.length > 2 || fbsNS.length > 2) {
                throw new Exception("Data Migration does not support job across more than 2 fabrics!");
            }
            if (migType == -86 && fbsHost.length != fbsES.length) {
                throw new Exception("Host and Existing Storage Port(s) selection do not contain same Fabric membership!");
            }
            if (migType == -86 && fbsHost.length != fbsNS.length) {
                throw new Exception("Host and New Storage Port(s) selection do not contain same Fabric membership!");
            }
            if (fbsES.length != fbsNS.length) {
                throw new Exception("Existing and New Storage Port(s) selection do not contain same Fabric membership!");
            }
            if (migType == -86) {
                for (i = 0; i < fbsHost.length; ++i) {
                    findFabric = false;
                    for (j = 0; j < fbsES.length; ++j) {
                        if (!fbsES[j].equals(fbsHost[i])) continue;
                        findFabric = true;
                        break;
                    }
                    if (!findFabric) {
                        throw new Exception("Host and Existing Storage Port(s) selection do not contain same Fabric membership!");
                    }
                    findFabric = false;
                    for (j = 0; j < fbsNS.length; ++j) {
                        if (!fbsNS[j].equals(fbsHost[i])) continue;
                        findFabric = true;
                        break;
                    }
                    if (findFabric) continue;
                    throw new Exception("Host and New Storage Port(s) selection do not contain same Fabric membership!");
                }
            } else {
                for (i = 0; i < fbsES.length; ++i) {
                    findFabric = false;
                    for (j = 0; j < fbsNS.length; ++j) {
                        if (!fbsNS[j].equals(fbsES[i])) continue;
                        findFabric = true;
                        break;
                    }
                    if (findFabric) continue;
                    throw new Exception("Existing and New Storage Port(s) selection do not contain same Fabric membership!");
                }
            }
            FabricPK[] fbs = migType == -86 ? fbsHost : fbsES;
            DataMigJobPanel.this.setModelValue("fabricsConnected", fbs);
            Integer[] hostESVsans1 = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership((EndPortBase[])(migType == -86 ? selServerPorts : null), selOldStoragePorts, fbs[0]);
            Integer[] hostNSVsans1 = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership((EndPortBase[])(migType == -86 ? selServerPorts : null), selNewStoragePorts, fbs[0]);
            String hostStr = migType == -86 ? "Host/" : "";
            String vsanErrStr = hostStr + "Existing Storage Port(s) and " + hostStr + "New Storage Port(s) need to contain same VSAN memebership in Fabric ";
            if (hostESVsans1 == null || hostNSVsans1 == null || hostESVsans1.length != hostNSVsans1.length) {
                throw new Exception(vsanErrStr + fbs[0] + "!");
            }
            for (int i2 = 0; i2 < hostESVsans1.length; ++i2) {
                if (hostESVsans1[i2].intValue() == hostNSVsans1[i2].intValue()) continue;
                throw new Exception(vsanErrStr + fbs[0] + "!");
            }
            Integer[] eSVsans1 = DataMigJobPanel.this.getVsans(selOldStoragePorts, fbs[0]);
            Integer[] eSnSVsans1 = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership(selOldStoragePorts, selNewStoragePorts, fbs[0]);
            if (eSVsans1 != null && eSnSVsans1 != null && eSVsans1.length != eSnSVsans1.length) {
                throw new Exception("New Storage Port List does not contain all VSAN membership of the Existing Storage in Fabric " + fbs[0] + "!");
            }
            for (int i3 = 0; i3 < hostESVsans1.length; ++i3) {
                this.zonePolicyCheck(fbs[0], hostESVsans1[i3]);
            }
            Integer[] hostESVsans2 = null;
            Integer[] hostNSVsans2 = null;
            if (fbs.length == 2) {
                hostESVsans2 = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership((EndPortBase[])(migType == -86 ? selServerPorts : null), selOldStoragePorts, fbs[1]);
                hostNSVsans2 = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership((EndPortBase[])(migType == -86 ? selServerPorts : null), selNewStoragePorts, fbs[1]);
                if (hostESVsans2 == null || hostNSVsans2 == null || hostESVsans2.length != hostNSVsans2.length) {
                    throw new Exception(vsanErrStr + fbs[1] + "!");
                }
                for (int i4 = 0; i4 < hostESVsans2.length; ++i4) {
                    if (hostESVsans2[i4].intValue() == hostNSVsans2[i4].intValue()) continue;
                    throw new Exception(vsanErrStr + fbs[1] + "!");
                }
                Integer[] eSVsans2 = DataMigJobPanel.this.getVsans(selOldStoragePorts, fbs[1]);
                Integer[] eSnSVsans2 = DataMigJobPanel.this.ddmServerRif.findCommonVsanMembership(selOldStoragePorts, selNewStoragePorts, fbs[1]);
                if (eSVsans2 != null && eSnSVsans2 != null && eSVsans2.length != eSnSVsans2.length) {
                    throw new Exception("New Storage Port List does not contain all VSAN membership of the Existing Storage in Fabric " + fbs[1] + "!");
                }
                for (int i5 = 0; i5 < hostESVsans2.length; ++i5) {
                    this.zonePolicyCheck(fbs[1], hostESVsans2[i5]);
                }
            }
            String type = (String)DataMigJobPanel.this._jobType.getSelectedValue();
            DataMigJobPanel.this.setModelValue("type", type);
            String rate = (String)DataMigJobPanel.this._rate.getSelectedValue();
            DataMigJobPanel.this.setModelValue("rate", rate);
            int scheduleActionSel = DataMigJobPanel.this._when.getSelected();
            if (scheduleActionSel == 2) {
                DataMigJobPanel.this._scheduleDate.getValidDate("MM/dd/yyyy");
                Date selectedDate = DataMigJobPanel.this._scheduleDate.getSelectedDate();
                Calendar cal = Calendar.getInstance();
                Date currentTime = cal.getTime();
                cal.setTime(selectedDate);
                cal.set(11, DataMigJobPanel.this._scheduleDate.getHour());
                cal.set(12, DataMigJobPanel.this._scheduleDate.getMin());
                cal.set(13, DataMigJobPanel.this._scheduleDate.getSec());
                Date schTime = cal.getTime();
                if (schTime.compareTo(currentTime) < 0) {
                    throw new Exception("Cannot schedule a job in the past!");
                }
                DataMigJobPanel.this.setModelValue("jobDate", schTime);
            }
            switch (scheduleActionSel) {
                case 0: {
                    DataMigJobPanel.this.setModelValue("jobScheduleAction", new Byte(1));
                    break;
                }
                case 1: {
                    DataMigJobPanel.this.setModelValue("jobScheduleAction", new Byte(2));
                    break;
                }
                case 2: {
                    DataMigJobPanel.this.setModelValue("jobScheduleAction", new Byte(0));
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataMigJobPanel.this.getWizard().setStatus("Retrieving SSM information...");
                }
            });
            ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
            DDMSwitch[] sws1 = DataMigJobPanel.this.ddmServerRif.findAllDDMEnabledSwitch(fbs[0], true, method);
            boolean bl = isFb1V2 = modelFacadeRif.getFabricCredentials(fbs[0]) == null;
            if (sws1 == null || sws1.length == 0) {
                throw new Exception("Cannot find any SSM card in " + fbs[0] + (isFb1V2 ? ": opened with SNMPv2c." : ".") + " (The minimum supported NX-OS version for DMM is " + "6.2(1)" + ")");
            }
            ArrayList<DDMSwitch> swlist1 = new ArrayList<DDMSwitch>();
            for (int i6 = 0; i6 < sws1.length; ++i6) {
                if (!DataMigJobPanel.this.validDMMSwitchVsan(hostESVsans1, sws1[i6], fbs.length == 1)) continue;
                swlist1.add(sws1[i6]);
            }
            if (swlist1.size() == 0) {
                throw new Exception("Cannot find any SSM card in Fabric " + fbs[0] + " that contain any VSAN memebership as the Host/Storage!");
            }
            sws1 = swlist1.toArray(new DDMSwitch[swlist1.size()]);
            boolean bl2 = isSingleFabricMultiVsan = fbs.length == 1 && hostESVsans1.length > 1;
            if (isSingleFabricMultiVsan) {
                DataMigJobPanel.this.ValidateSSM4SingleFabricMultiVsan(sws1, hostESVsans1);
            }
            DataMigJobPanel.this.setModelValue("singleFabricMultiVsan", new Boolean(isSingleFabricMultiVsan));
            DataMigJobPanel.this.setModelValue("fabrics1DMMSwitch", sws1);
            DataMigJobPanel.this.setModelValue("singleFabricMultiVsanHostStorageVsans", hostESVsans1);
            if (fbs.length > 1) {
                boolean isFb2V2;
                DDMSwitch[] sws2 = DataMigJobPanel.this.ddmServerRif.findAllDDMEnabledSwitch(fbs[1], true, method);
                boolean bl3 = isFb2V2 = modelFacadeRif.getFabricCredentials(fbs[1]) == null;
                if (sws2 == null || sws2.length == 0) {
                    throw new Exception("Cannot find any SSM card in " + fbs[1] + (isFb2V2 ? ": opened with SNMPv2c." : ".") + " (The minimum supported NX-OS version for DMM is " + "6.2(1)" + ")");
                }
                ArrayList<DDMSwitch> swlist2 = new ArrayList<DDMSwitch>();
                for (int i7 = 0; i7 < sws2.length; ++i7) {
                    if (!DataMigJobPanel.this.validDMMSwitchVsan(hostESVsans2, sws2[i7], false)) continue;
                    swlist2.add(sws2[i7]);
                }
                if (swlist2.size() == 0) {
                    throw new Exception("Cannot find any SSM card in Fabric " + fbs[1] + " that contain any VSAN memebership as the Host/Storage!");
                }
                sws2 = swlist2.toArray(new DDMSwitch[swlist2.size()]);
                DataMigJobPanel.this.setModelValue("fabrics2DMMSwitch", sws2);
            }
            DataMigJobPanel.this.setModelValue("dualFabric", new Boolean(fbs.length == 2));
            DataMigJobPanel.this.setModelValue("singleFabricMultiVsanHostStorageVsans", hostESVsans1);
        }
    }
}

