/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Filler;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.datamig.DMMStatusTable;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigThread;
import com.cisco.dcbu.sm.client.datamig.DataMigSessionTableRenderer;
import com.cisco.dcbu.sm.client.datamig.DataMigWizard;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.DataViewModelIf;
import com.cisco.dcbu.sm.client.gui.SmCommand;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.common.model.ddm.DDMLun;
import com.cisco.dcbu.sm.common.model.ddm.DDMLunITL;
import com.cisco.dcbu.sm.common.model.ddm.DDMSession;
import com.cisco.dcbu.sm.common.rif.DDMCreationRif;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DataMigSessionPanel
extends DataMigConfigPanel
implements ActionListener {
    JLabel _hours2complete;
    JLabel _hours2completeLabel;
    JCheckBox _loadBalance;
    JCheckBox _selectAllRows;
    JPanel _container;
    SnmpKTable _s1Table;
    SnmpKTable _s2Table;
    JLabel _host1;
    JLabel _esPort1;
    JLabel _nsPort1;
    JLabel _ssm1;
    SmTableModel _s1TableModel;
    SmTableModel _s2TableModel;
    JLabel _host2;
    JLabel _esPort2;
    JLabel _nsPort2;
    JLabel _ssm2;
    boolean _isDualFabric;
    Array _s1Data;
    Array _s2Data;
    DDMLun[] _sLunsPri;
    DDMLun[] _dLunsPri;
    DDMLun[] _sLunsSec;
    DDMLun[] _dLunsSec;
    int _totalDataRows;
    int _splitLbPos;
    JPanel _sp1Panel;
    JPanel _sp2Panel;
    JLabel _warningLuns;
    final String[] _Labels = new String[]{"Estimated time for completion:"};
    static final String[] _ColLabels = new String[]{"Row Number", "Select", "Existing LUN(Id, Size)", "New LUN(Id, Size)"};
    static final boolean[] _Editable = new boolean[]{false, true, true, true};
    ArrayList<Long> _srcLunIds = new ArrayList();
    ArrayList<Long> _destLunIds = new ArrayList();
    public static final int ROW_NUMBER = 0;
    public static final int SESSION_SELECT = 1;
    public static final int SESSION_SRC = 2;
    public static final int SESSION_DEST = 3;
    static final int LB_LUN_NUM_MIN = 2;

    public DataMigSessionPanel(JWizard wizard, int migType) {
        super("", "Choose the mapping between Existing and New LUNs. You will need to fix any anomalies marked in red. Press Finish to complete", wizard, migType == -86 ? DataMigWizard._Image_Server : DataMigWizard._Image_Storage);
    }

    @Override
    public boolean refresh() {
        boolean allowLoadBalance;
        this.removeAll();
        this.setTitle("Step " + ((DataMigWizard)this.getWizard()).getNextStep() + ": Create Session");
        JPanel topPanel = new JPanel(null);
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel hrs2CompletePanel = new JPanel(new FlowLayout(0, 0, 0));
        this._hours2completeLabel = new JLabel("Estimated time for completion:");
        hrs2CompletePanel.add(this._hours2completeLabel);
        hrs2CompletePanel.add(new Filler(new Dimension(10, 10)));
        this._hours2complete = new JLabel();
        hrs2CompletePanel.add(this._hours2complete);
        topPanel.add(hrs2CompletePanel);
        JPanel ldPanel = new JPanel(new FlowLayout(0, 0, 0));
        ldPanel.add(new JLabel("Sessions:"));
        this._selectAllRows = new JCheckBox("Select All", true);
        this._selectAllRows.setToolTipText("Toggle to either Select all qualifying rows or Deselect all rows.");
        this._selectAllRows.setActionCommand("SA");
        this._selectAllRows.addActionListener(this);
        ldPanel.add(new Filler(new Dimension(10, 10)));
        ldPanel.add(this._selectAllRows);
        this._loadBalance = new JCheckBox("Load Balance", false);
        this._loadBalance.setActionCommand("LB");
        this._loadBalance.addActionListener(this);
        ldPanel.add(new Filler(new Dimension(10, 10)));
        ldPanel.add(this._loadBalance);
        topPanel.add(ldPanel);
        this._s1TableModel = new SmTableModel();
        this._s1TableModel.setHeaders(_ColLabels);
        this._s1TableModel.setEditable(_Editable);
        this._s1Table = new SnmpKTable(this._s1TableModel);
        this._s1Table.setSelectionMode(1);
        this._s1Table.setAutoResizeMode(3);
        this._s1Table.getTableHeader().addMouseListener(new HeaderListener());
        this._s1Table.setSortable(true);
        ((JLabel)((Object)this._s1Table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
        DDMLunITL srcLunPri = (DDMLunITL)this.getModelValue("sourcePathPri");
        DDMLunITL destLunPri = (DDMLunITL)this.getModelValue("destPathPri");
        DDMLunITL srcLunSec = (DDMLunITL)this.getModelValue("sourcePathSec");
        DDMLunITL destLunSec = (DDMLunITL)this.getModelValue("destPathSec");
        this._sLunsPri = srcLunPri.getLuns();
        this._dLunsPri = destLunPri.getLuns();
        boolean isDualFabric = (Boolean)this.getModelValue("dualFabric");
        boolean isDualSSMSelected = (Boolean)this.getModelValue("dualSSMSelected");
        int dmType = (Integer)this.getModelValue("dmType");
        JPanel warningPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._warningLuns = new JLabel("(Note: There are more number of LUNs in the Existing(" + this._sLunsPri.length + ") " + "than New Storage(" + this._dLunsPri.length + ").)");
        this._warningLuns.setForeground(Color.red);
        warningPanel.add(this._warningLuns);
        topPanel.add(warningPanel);
        this._warningLuns.setVisible(this._sLunsPri.length > this._dLunsPri.length);
        warningPanel.setVisible(this._sLunsPri.length > this._dLunsPri.length);
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", topPanel);
        this._totalDataRows = Math.min(this._sLunsPri.length, this._dLunsPri.length);
        this._splitLbPos = this._totalDataRows % 2 == 0 ? this._totalDataRows / 2 : this._totalDataRows / 2 + 1;
        this.loadNonLBTable();
        JScrollPane sp1 = new JScrollPane(this._s1Table);
        String host1 = "Host: " + this.getWWN_Alias(srcLunPri.getInitator().getEndPortPK()._wwn);
        this._host1 = new JLabel(host1);
        String es1 = "Existing Storage: " + this.getWWN_Alias(srcLunPri.getTaget().getEndPortPK()._wwn);
        this._esPort1 = new JLabel(es1);
        String ns1 = "New Storage: " + this.getWWN_Alias(destLunPri.getTaget().getEndPortPK()._wwn);
        this._nsPort1 = new JLabel(ns1);
        this._s1Table.setToolTipText("<html>" + es1 + "<br>" + ns1);
        sp1.setPreferredSize(new Dimension(250, 180));
        this._ssm1 = new JLabel("SSM: " + srcLunPri.getSwitch());
        JComponent[] sp1Comps = new JComponent[]{this._host1, this._esPort1, this._nsPort1, this._ssm1, sp1};
        this._sp1Panel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null, null, null, null}), sp1Comps);
        boolean bl = allowLoadBalance = (isDualFabric || isDualSSMSelected) && this._totalDataRows >= 2 && srcLunSec != null && destLunSec != null;
        if (allowLoadBalance) {
            this._sLunsSec = srcLunSec.getLuns();
            this._dLunsSec = destLunSec.getLuns();
            this._s2TableModel = new SmTableModel();
            this._s2TableModel.setHeaders(_ColLabels);
            this._s2TableModel.setEditable(_Editable);
            this._s2Table = new SnmpKTable(this._s2TableModel);
            this._s2Table.setSelectionMode(1);
            this._s2Table.setAutoResizeMode(3);
            this._s2Table.getTableHeader().addMouseListener(new HeaderListener());
            this._s2Table.setSortable(true);
            ((JLabel)((Object)this._s2Table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
            JScrollPane sp2 = new JScrollPane(this._s2Table);
            String host2 = "Host: " + this.getWWN_Alias(srcLunSec.getInitator().getEndPortPK()._wwn);
            this._host2 = new JLabel(host2);
            String es2 = "Existing Storage: " + this.getWWN_Alias(srcLunSec.getTaget().getEndPortPK()._wwn);
            this._esPort2 = new JLabel(es2);
            String ns2 = "New Storage: " + this.getWWN_Alias(destLunSec.getTaget().getEndPortPK()._wwn);
            this._nsPort2 = new JLabel(ns2);
            this._s1Table.setToolTipText("<html>" + es2 + "<br>" + ns2);
            sp2.setPreferredSize(new Dimension(250, 180));
            this._ssm2 = new JLabel("SSM: " + srcLunSec.getSwitch());
            JComponent[] sp2Comps = new JComponent[]{this._host2, this._esPort2, this._nsPort2, this._ssm2, sp2};
            this._sp2Panel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null, null, null, null}), sp2Comps);
        } else {
            this._loadBalance.setVisible(false);
        }
        this._container = new JPanel(null);
        this._container.setLayout(new BoxLayout(this._container, 0));
        this._container.add(this._sp1Panel);
        p.add("Center", this._container);
        this.add(p);
        this._hours2completeLabel.setVisible(false);
        this._hours2complete.setVisible(false);
        return true;
    }

    private String getWWN_Alias(Wwn wwn) {
        EndPort endPort = ClientController.findFabricEndPortByWwn(wwn);
        String device = wwn.toString();
        String alias = null;
        if (endPort != null && (alias = endPort.getAlias()) != null && !alias.equals("")) {
            device = device + " (" + alias + ")";
        }
        return device;
    }

    void loadTable(Array data, int startPos, int endPos, boolean primary) {
        DDMLun[] sLuns = null;
        DDMLun[] dLuns = null;
        boolean anyRowUnselect = false;
        if (primary) {
            sLuns = this._sLunsPri;
            dLuns = this._dLunsPri;
        } else {
            sLuns = this._sLunsSec;
            dLuns = this._dLunsSec;
        }
        for (int i = startPos; i < endPos && i < sLuns.length && i < dLuns.length; ++i) {
            Object[] row = new Object[_ColLabels.length + 1];
            row[0] = String.valueOf(i + 1);
            if (i < sLuns.length) {
                row[2] = sLuns[i];
            }
            if (i < dLuns.length) {
                row[3] = dLuns[i];
            }
            if (sLuns[i].getCapacity() <= dLuns[i].getCapacity()) {
                row[1] = Boolean.TRUE;
            } else {
                row[1] = Boolean.FALSE;
                anyRowUnselect = true;
            }
            data.addElement(row);
        }
        if (anyRowUnselect) {
            this._selectAllRows.setSelected(false);
        }
    }

    DDMLun[] getLunSel(DDMLun[] luns, int startPos, int endPos) {
        DDMLun[] lunSel = new DDMLun[endPos - startPos];
        for (int i = startPos; i < endPos; ++i) {
            lunSel[i - startPos] = luns[i];
        }
        return lunSel;
    }

    @Override
    public void doFinish() {
        Array data = this._s1TableModel.getData();
        boolean dataSel = this.isAnyRowSelected(data);
        if (dataSel && this._loadBalance.isSelected()) {
            data = this._s2TableModel.getData();
            dataSel = this.isAnyRowSelected(data);
        }
        if (!dataSel) {
            Util.errorMessage((Component)this, "No Sessions are selected!");
            return;
        }
        this._cfgThread = new ConfigSessionThread(this.getWizard());
        this._cfgThread.start();
    }

    boolean isAnyRowSelected(Array data) {
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            if (row[1] != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    void selectTableRow(Array data, boolean select) {
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            if (select) {
                DDMLun srcLun = (DDMLun)row[2];
                DDMLun destLun = (DDMLun)row[3];
                if (srcLun.getCapacity() <= destLun.getCapacity()) {
                    row[1] = Boolean.TRUE;
                    continue;
                }
                row[1] = Boolean.FALSE;
                continue;
            }
            row[1] = Boolean.FALSE;
        }
    }

    void selectAll(boolean selectAll) {
        this.selectTableRow(this._s1TableModel.getData(), selectAll);
        this._s1TableModel.fireTableDataChanged();
        if (this._loadBalance.isSelected()) {
            this.selectTableRow(this._s2TableModel.getData(), selectAll);
            this._s2TableModel.fireTableDataChanged();
        }
    }

    void createSession(Array data, ArrayList sessionList, DDMLunITL srcPath, DDMLunITL destPath) throws Exception {
        for (int i = 0; i < data.size(); ++i) {
            long destCap;
            Object[] row = (Object[])data.elementAt(i);
            if (row[1] != Boolean.TRUE) continue;
            long srcCap = ((DDMLun)row[2]).getMaxLba() * 512L;
            if (srcCap > (destCap = ((DDMLun)row[3]).getMaxLba() * 512L)) {
                throw new Exception("Source Capacity (" + srcCap + "B)" + " is greater than Destination Capacity (" + destCap + "B)" + " on row " + (i + 1));
            }
            DDMLun srcLun = (DDMLun)row[2];
            if (this._srcLunIds.contains(srcLun.getLunNumber())) {
                throw new Exception("The Existing LUN on row " + (i + 1) + " has been assigned to a New LUN already.");
            }
            this._srcLunIds.add(srcLun.getLunNumber());
            DDMLun destLun = (DDMLun)row[3];
            if (this._destLunIds.contains(destLun.getLunNumber())) {
                throw new Exception("The New LUN on row " + (i + 1) + " has been assigned to a Existing LUN already.");
            }
            this._destLunIds.add(destLun.getLunNumber());
            DDMLunITL srcLunITL = new DDMLunITL();
            srcLunITL.setInitator(srcPath.getInitator());
            srcLunITL.setTaget(srcPath.getTaget());
            srcLunITL.setSwitch(srcPath.getSwitch());
            srcLunITL.setLuns(new DDMLun[]{srcLun});
            DDMLunITL destLunITL = new DDMLunITL();
            destLunITL.setInitator(destPath.getInitator());
            destLunITL.setTaget(destPath.getTaget());
            destLunITL.setSwitch(destPath.getSwitch());
            destLunITL.setLuns(new DDMLun[]{destLun});
            DDMSession session = new DDMSession();
            session.setExistingLuns(srcLunITL);
            session.setNewLuns(destLunITL);
            sessionList.add(session);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("LB")) {
            if (this._loadBalance.isSelected()) {
                Array s1NewData = new Array();
                this.loadTable(s1NewData, 0, this._splitLbPos, true);
                this._s1TableModel.setData(s1NewData);
                this._s1Data = s1NewData;
                this._s1TableModel.fireTableDataChanged();
                DDMLun[] s1LunSel = this.getLunSel(this._sLunsPri, 0, this._sLunsPri.length);
                JComboBox<DDMLun> s1Combo = new JComboBox<DDMLun>(s1LunSel);
                s1Combo.setEditable(false);
                this._s1Table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(s1Combo));
                this._s1Table.getColumnModel().getColumn(2).setCellRenderer(new DataMigSessionTableRenderer());
                DDMLun[] d1LunSel = this.getLunSel(this._dLunsPri, 0, this._dLunsPri.length);
                JComboBox<DDMLun> d1Combo = new JComboBox<DDMLun>(d1LunSel);
                d1Combo.setEditable(false);
                this._s1Table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(d1Combo));
                this._s1Table.getColumnModel().getColumn(3).setCellRenderer(new DataMigSessionTableRenderer());
                Array s2NewData = new Array();
                this.loadTable(s2NewData, this._splitLbPos, this._totalDataRows, false);
                this._s2TableModel.setData(s2NewData);
                this._s2Data = s2NewData;
                DDMLun[] s2LunSel = this.getLunSel(this._sLunsSec, 0, this._sLunsSec.length);
                JComboBox<DDMLun> s2Combo = new JComboBox<DDMLun>(s2LunSel);
                s2Combo.setEditable(false);
                this._s2Table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(s2Combo));
                this._s2Table.getColumnModel().getColumn(2).setCellRenderer(new DataMigSessionTableRenderer());
                DDMLun[] d2LunSel = this.getLunSel(this._dLunsSec, 0, this._dLunsSec.length);
                JComboBox<DDMLun> d2Combo = new JComboBox<DDMLun>(d2LunSel);
                d2Combo.setEditable(false);
                this._s2Table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(d2Combo));
                this._s2Table.getColumnModel().getColumn(3).setCellRenderer(new DataMigSessionTableRenderer());
                this._container.removeAll();
                this._sp1Panel.setPreferredSize(new Dimension(250, 180));
                this._sp2Panel.setPreferredSize(new Dimension(250, 180));
                this._container.add(this._sp1Panel);
                this._container.add(Box.createHorizontalGlue());
                this._container.add(this._sp2Panel);
                this._container.validate();
            } else {
                this.loadNonLBTable();
                this._container.removeAll();
                this._container.add((Component)this._sp1Panel, "Center");
                this._container.validate();
            }
        } else if (cmd.equals("SA")) {
            this.selectAll(this._selectAllRows.isSelected());
        }
    }

    void loadNonLBTable() {
        Array s1NewData = new Array();
        this.loadTable(s1NewData, 0, this._totalDataRows, true);
        this._s1TableModel.setData(s1NewData);
        this._s1Data = s1NewData;
        this._s1TableModel.fireTableDataChanged();
        DDMLun[] s1LunSel = this.getLunSel(this._sLunsPri, 0, this._sLunsPri.length);
        JComboBox<DDMLun> s1Combo = new JComboBox<DDMLun>(s1LunSel);
        s1Combo.setEditable(false);
        this._s1Table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(s1Combo));
        this._s1Table.getColumnModel().getColumn(2).setCellRenderer(new DataMigSessionTableRenderer());
        DDMLun[] d1LunSel = this.getLunSel(this._dLunsPri, 0, this._dLunsPri.length);
        JComboBox<DDMLun> d1Combo = new JComboBox<DDMLun>(d1LunSel);
        d1Combo.setEditable(false);
        this._s1Table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(d1Combo));
        this._s1Table.getColumnModel().getColumn(3).setCellRenderer(new DataMigSessionTableRenderer());
    }

    class ConfigSessionThread
    extends DataMigConfigThread {
        public ConfigSessionThread(JWizard wizard) {
            super(wizard);
        }

        @Override
        public void run() {
            try {
                this.setupConfigStatus(true, false, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataMigSessionPanel.this.getWizard().setStatus("Sending Session information...");
                    }
                });
                ArrayList sessionList = new ArrayList();
                Array s1Data = DataMigSessionPanel.this._s1TableModel.getData();
                DDMLunITL srcPathPri = (DDMLunITL)DataMigSessionPanel.this.getModelValue("sourcePathPri");
                DDMLunITL destPathPri = (DDMLunITL)DataMigSessionPanel.this.getModelValue("destPathPri");
                DataMigSessionPanel.this._srcLunIds.clear();
                DataMigSessionPanel.this._destLunIds.clear();
                DataMigSessionPanel.this.createSession(s1Data, sessionList, srcPathPri, destPathPri);
                if (DataMigSessionPanel.this._loadBalance.isSelected()) {
                    Array s2Data = DataMigSessionPanel.this._s2TableModel.getData();
                    DDMLunITL srcPathSec = (DDMLunITL)DataMigSessionPanel.this.getModelValue("sourcePathSec");
                    DDMLunITL destPathSec = (DDMLunITL)DataMigSessionPanel.this.getModelValue("destPathSec");
                    DataMigSessionPanel.this.createSession(s2Data, sessionList, srcPathSec, destPathSec);
                }
                DDMCreationRif dmCreateRif = (DDMCreationRif)DataMigSessionPanel.this.getModelValue("CreateRif");
                dmCreateRif.createSessions(sessionList.toArray(new DDMSession[sessionList.size()]));
                dmCreateRif.finish();
                if (!this.keepRunning(DataMigSessionPanel.this._cfgThread)) {
                    return;
                }
                this.setupConfigStatus(false, false, null);
                DataMigSessionPanel.this._cfgThread = null;
                DataMigSessionPanel.this._finish = true;
                DataMigSessionPanel.this.cleanupSml();
                DataMigSessionPanel.this.getWizard().dispose();
                DataView dv = BrowserFrame.getDataView();
                DataViewModelIf dvModel = dv.getDataViewModelIf();
                if (dvModel instanceof DMMStatusTable) {
                    ((DMMStatusTable)dvModel).refresh();
                } else {
                    SmCommand.DMStatus(BrowserFrame.getDataView(), "Data Migration Status", null, null, null, null);
                }
            }
            catch (Exception ex) {
                if (!this.keepRunning(DataMigSessionPanel.this._cfgThread)) {
                    return;
                }
                this.setupConfigStatus(false, false, ex);
                return;
            }
        }
    }
}

