/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigThread;
import com.cisco.dcbu.sm.client.datamig.DataMigDPPVIPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigJobPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigWizard;
import com.cisco.dcbu.sm.client.datamig.DataMoverSSMPanel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.ddm.DDMJob;
import com.cisco.dcbu.sm.common.model.ddm.DDMSwitch;
import com.cisco.dcbu.sm.common.rif.DDMCreationRif;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.dmm.Mediator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DataMigSwitchPanel
extends DataMigConfigPanel {
    SnmpKTable _ssm1Table;
    SnmpKTable _ssm2Table;
    SmTableModel _ssm1TableModel;
    SmTableModel _ssm2TableModel;
    JLabel _ssm1;
    JLabel _ssm2;
    JCheckBox _noSSM2;
    boolean _isDualFabric;
    boolean _isSingleFabricMultiVsan;
    JPanel _ssm1Panel;
    JPanel _ssm2Panel;
    JCheckBox _manualPath;
    int _migType;
    static final String[] _ColLabels = new String[]{"Switch/Module(Type)", "# of Active Jobs"};

    public DataMigSwitchPanel(JWizard wizard, int migType) {
        super("", "The least-loaded SSMs are pre-selected for each fabric to perform migration. Click on a new row to change selection. This may take a few seconds.", wizard, migType == -86 ? DataMigWizard._Image_Server : DataMigWizard._Image_Storage);
        this._migType = migType;
    }

    @Override
    public boolean refresh() {
        block19: {
            this.removeAll();
            this.setTitle("Step " + ((DataMigWizard)this.getWizard()).getNextStep() + (((DataMigWizard)this.getWizard()).isMethod3() ? ": Select server SSM In Each Fabric" : ": Select SSM In Each Fabric"));
            this._isSingleFabricMultiVsan = (Boolean)this.getModelValue("singleFabricMultiVsan");
            this._ssm1TableModel = new SmTableModel();
            this._ssm1TableModel.setHeaders(_ColLabels);
            this._ssm1Table = new SnmpKTable(this._ssm1TableModel);
            this._ssm1Table.setSelectionMode(this._isSingleFabricMultiVsan ? 2 : 1);
            this._ssm1Table.setAutoResizeMode(3);
            this._ssm1Table.getTableHeader().addMouseListener(new HeaderListener());
            this._ssm1Table.setSortable(true);
            ((JLabel)((Object)this._ssm1Table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
            FabricPK[] fbs = (FabricPK[])this.getModelValue("fabricsConnected");
            FabricPK migFabric = null;
            FabricPK[] prodFabrics = null;
            if (((DataMigWizard)this.getWizard()).isMethod3()) {
                migFabric = ((FabricPK[])this.getModelValue("migrationFabric"))[0];
                prodFabrics = (FabricPK[])this.getModelValue("productionFabric");
                this._ssm1 = new JLabel(prodFabrics[0].getName() + ":");
                if (prodFabrics.length > 1) {
                    this._ssm2 = new JLabel(prodFabrics[1].getName() + ":");
                }
            } else {
                this._ssm1 = new JLabel("Fabric 1:");
                this._ssm2 = new JLabel("Fabric 2:");
            }
            this._ssm2TableModel = new SmTableModel();
            this._ssm2TableModel.setHeaders(_ColLabels);
            this._ssm2Table = new SnmpKTable(this._ssm2TableModel);
            this._ssm2Table.setSelectionMode(1);
            this._ssm2Table.setAutoResizeMode(3);
            this._ssm2Table.getTableHeader().addMouseListener(new HeaderListener());
            this._ssm2Table.setSortable(true);
            ((JLabel)((Object)this._ssm2Table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
            this._noSSM2 = new JCheckBox("none", false);
            JScrollPane sp1 = new JScrollPane(this._ssm1Table);
            sp1.setPreferredSize(new Dimension(200, 180));
            JComponent[] ssm1Comps = new JComponent[]{this._ssm1, sp1};
            this._ssm1Panel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), ssm1Comps);
            JScrollPane sp2 = new JScrollPane(this._ssm2Table);
            sp2.setPreferredSize(new Dimension(200, 180));
            JComponent[] ssm2Comps = new JComponent[2];
            if (this._ssm2 != null) {
                FieldPanel fp2 = new FieldPanel((JComponent)this._ssm2, (JComponent)this._noSSM2, null);
                ssm2Comps[0] = fp2;
            }
            ssm2Comps[1] = sp2;
            this._ssm2Panel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), ssm2Comps);
            try {
                EnclosureBase server = (EnclosureBase)this.getModelValue("server");
                DDMServerRif ddmServerRif = (DDMServerRif)this.getModelValue("ServerRif");
                Array<Object[]> ssm1data = new Array<Object[]>();
                this._ssm1TableModel.setData(ssm1data);
                DDMSwitch[] sws1 = (DDMSwitch[])this.getModelValue("fabrics1DMMSwitch");
                if (sws1 != null) {
                    for (int i = 0; i < sws1.length; ++i) {
                        Object[] row = new Object[]{sws1[i], new Integer(sws1[i].getNumJob())};
                        ssm1data.addElement(row);
                    }
                }
                if (ssm1data.size() > 0) {
                    if (this._isSingleFabricMultiVsan) {
                        int[] rows1 = (int[])this.getModelValue("singleFabricMultiVsanTable1RowSelectionList");
                        if (rows1 != null && rows1.length >= 1) {
                            this._ssm1Table.setRowSelectionInterval(rows1[0], rows1[0]);
                            if (rows1.length == 2) {
                                this._ssm1Table.addRowSelectionInterval(rows1[1], rows1[1]);
                            }
                        }
                    } else {
                        this._ssm1Table.setRowSelectionInterval(0, 0);
                    }
                }
                this._isDualFabric = (Boolean)this.getModelValue("dualFabric");
                Array<Object[]> ssm2data = new Array<Object[]>();
                this._ssm2TableModel.setData(ssm2data);
                if (this._isDualFabric) {
                    this._noSSM2.setVisible(false);
                    DDMSwitch[] sws2 = (DDMSwitch[])this.getModelValue("fabrics2DMMSwitch");
                    if (sws2 != null) {
                        for (int i = 0; i < sws2.length; ++i) {
                            Object[] row = new Object[]{sws2[i], new Integer(sws2[i].getNumJob())};
                            ssm2data.addElement(row);
                        }
                    }
                    if (ssm2data.size() > 0) {
                        this._ssm2Table.setRowSelectionInterval(0, 0);
                    }
                    JPanel _centerPanel = new JPanel();
                    _centerPanel.setLayout(new GridLayout());
                    _centerPanel.add(this._ssm1Panel);
                    _centerPanel.add(this._ssm2Panel);
                    this.add((Component)_centerPanel, "Center");
                } else {
                    this.add((Component)this._ssm1Panel, "Center");
                }
                JPanel localActPanel = new JPanel(new FlowLayout(2, 6, 4));
                if (!((DataMigWizard)this.getWizard()).isMethod3()) {
                    this._manualPath = new JCheckBox("Manual Migration Path", false);
                    localActPanel.add(this._manualPath);
                    this.add((Component)this._manualPath, "South");
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block19;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    public void doNext() {
        this._cfgThread = new ConfigSwitchThread(this.getWizard());
        this._cfgThread.start();
    }

    private boolean checks() {
        FabricPK[] fbs = (FabricPK[])this.getModelValue("migrationFabric");
        boolean available = false;
        try {
            DDMServerRif ddmServerRif = (DDMServerRif)this.getModelValue("ServerRif");
            DDMSwitch sw1 = (DDMSwitch)this.getModelValue("sw1");
            DDMSwitch sw2 = (DDMSwitch)this.getModelValue("sw2");
            FabricPK f1 = sw1.getFabric().getPK();
            FabricPK f2 = null;
            if (sw2 != null) {
                f2 = sw2.getFabric().getPK();
            }
            for (int i = 0; i < fbs.length; ++i) {
                if (!this._isSingleFabricMultiVsan && (fbs[i].equals(f1) || fbs[i].equals(f2))) continue;
                DDMSwitch[] sws = ddmServerRif.findAllDDMEnabledSwitch(fbs[i]);
                for (int j = 0; j < sws.length; ++j) {
                    DDMSwitch sw = sws[j];
                    if (sw.equals(this.getModelValue("sw1")) || sw.equals(this.getModelValue("sw2"))) continue;
                    available = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Util.errorMessage((Component)this, ex);
        }
        if (!available) {
            Util.errorMessage((Component)this, "No more DMM enabled cards available to use as Data Mover SSM. Please go back and deselect one of the server SSMs.");
        }
        return available || this._isSingleFabricMultiVsan;
    }

    class ConfigSwitchThread
    extends DataMigConfigThread {
        public ConfigSwitchThread(JWizard wizard) {
            super(wizard);
        }

        @Override
        public void run() {
            try {
                int ssm2Type;
                int ssm1Type;
                String jobModeS;
                this.setupConfigStatus(true, true, null);
                int migType = (Integer)DataMigSwitchPanel.this.getModelValue("dmType");
                if (migType == -69) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DataMigSwitchPanel.this.getWizard().setStatus("Getting DPP VI...");
                        }
                    });
                } else {
                    if (((DataMigWizard)DataMigSwitchPanel.this.getWizard()).isMethod3()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataMigSwitchPanel.this.getWizard().setStatus("Retrieving data-mover SSM information...");
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataMigSwitchPanel.this.getWizard().setStatus("Getting Lun Map Correlation and Preparing Session input...");
                            }
                        });
                    }
                    if (!this.keepRunning(DataMigSwitchPanel.this._cfgThread)) {
                        return;
                    }
                }
                DataMigSwitchPanel.this.setDataValid(false);
                DDMJob job = new DDMJob();
                DataMigSwitchPanel.this.setModelValue("jobData", job);
                job.setType((byte)((Integer)DataMigSwitchPanel.this.getModelValue("dmType") & 0xFF));
                job.setName((String)DataMigSwitchPanel.this.getModelValue("jobName"));
                job.setServerHosts((EnclosureBase)DataMigSwitchPanel.this.getModelValue("server"));
                EndPortBase[] serverPorts = (EndPortBase[])DataMigSwitchPanel.this.getModelValue("serverPorts");
                if (serverPorts != null) {
                    job.setServerEndPorts(serverPorts);
                }
                job.setExsitingStorages((EnclosureBase)DataMigSwitchPanel.this.getModelValue("oldStorage"));
                EndPortBase[] oldStoragePorts = (EndPortBase[])DataMigSwitchPanel.this.getModelValue("oldStoragePorts");
                if (oldStoragePorts != null) {
                    job.setExisitingStoragesEndPorts(oldStoragePorts);
                }
                job.setNewStorages((EnclosureBase)DataMigSwitchPanel.this.getModelValue("newStorage"));
                EndPortBase[] newStoragePorts = (EndPortBase[])DataMigSwitchPanel.this.getModelValue("newStoragePorts");
                if (newStoragePorts != null) {
                    job.setNewStoragesEndPorts(newStoragePorts);
                }
                byte jobMode = (jobModeS = (String)DataMigSwitchPanel.this.getModelValue("type")).equals(DataMigJobPanel._JobType[0]) ? (byte)-52 : -35;
                job.setJobMode(jobMode);
                String rateS = (String)DataMigSwitchPanel.this.getModelValue("rate");
                int rate = -35;
                if (rateS.equals(Mediator.DMM_JOB_Rates[1])) {
                    rate = -52;
                } else if (rateS.equals(Mediator.DMM_JOB_Rates[2])) {
                    rate = -69;
                } else if (rateS.equals(Mediator.DMM_JOB_Rates[3])) {
                    rate = -86;
                }
                job.setRate((byte)rate);
                job.setScheduleAction((Byte)DataMigSwitchPanel.this.getModelValue("jobScheduleAction"));
                if (DataMigSwitchPanel.this.getModelValue("jobDate") != null) {
                    Date schTime = (Date)DataMigSwitchPanel.this.getModelValue("jobDate");
                    job.setScheduledStartingTime(schTime);
                }
                job.setMethod((Byte)DataMigSwitchPanel.this.getModelValue("jobMethod"));
                DDMSwitch ssm1 = null;
                DDMSwitch ssm2 = null;
                int[] ssm1Rows = DataMigSwitchPanel.this._ssm1Table.getSelectedRows();
                if (DataMigSwitchPanel.this._isDualFabric || !DataMigSwitchPanel.this._isSingleFabricMultiVsan) {
                    if (ssm1Rows.length == 0) {
                        throw new Exception("Please select one switch from Fabric 1!");
                    }
                    ssm1 = (DDMSwitch)((Object[])DataMigSwitchPanel.this._ssm1TableModel.getData().elementAt(ssm1Rows[0]))[0];
                } else {
                    if (ssm1Rows.length > 2) {
                        throw new Exception("Please select up two switches from Fabric 1!");
                    }
                    ssm1 = (DDMSwitch)((Object[])DataMigSwitchPanel.this._ssm1TableModel.getData().elementAt(ssm1Rows[0]))[0];
                    short[] ssm1Vsans = ssm1.getSwitch().getVsanIds();
                    short[] ssm2Vsans = null;
                    if (ssm1Rows.length > 1) {
                        ssm2 = (DDMSwitch)((Object[])DataMigSwitchPanel.this._ssm1TableModel.getData().elementAt(ssm1Rows[1]))[0];
                        ssm2Vsans = ssm2.getSwitch().getVsanIds();
                    }
                    Integer[] hostStorageVsans = (Integer[])DataMigSwitchPanel.this.getModelValue("singleFabricMultiVsanHostStorageVsans");
                    for (int i = 0; i < hostStorageVsans.length; ++i) {
                        int j;
                        boolean findVsan = false;
                        if (ssm1Vsans != null && ssm1Vsans.length > 1) {
                            for (j = 0; j < ssm1Vsans.length; ++j) {
                                if (ssm1Vsans[j] != hostStorageVsans[i]) continue;
                                findVsan = true;
                                break;
                            }
                        }
                        if (!findVsan && ssm2Vsans != null && ssm2Vsans.length > 1) {
                            for (j = 0; j < ssm2Vsans.length; ++j) {
                                if (ssm2Vsans[j] != hostStorageVsans[i]) continue;
                                findVsan = true;
                                break;
                            }
                        }
                        if (findVsan) continue;
                        throw new Exception("Selected SSM(s) do not contain required VSAN membership!");
                    }
                }
                if (DataMigSwitchPanel.this._isDualFabric && !DataMigSwitchPanel.this._noSSM2.isSelected()) {
                    int ssm2Row = DataMigSwitchPanel.this._ssm2Table.getSelectedRow();
                    if (ssm2Row == -1) {
                        throw new Exception("Please select a switch from Fabric 2!");
                    }
                    ssm2 = (DDMSwitch)((Object[])DataMigSwitchPanel.this._ssm2TableModel.getData().elementAt(ssm2Row))[0];
                }
                if (ssm2 != null && (ssm1Type = ssm1.getSsmCard().getType()) != (ssm2Type = ssm2.getSsmCard().getType()) && (ssm1Type != 41 && ssm1Type != 39 && ssm1Type != 68 || ssm2Type != 41 && ssm2Type != 39 && ssm2Type != 68) && (ssm1Type != 5 && ssm1Type != 20 || ssm2Type != 5 && ssm2Type != 20)) {
                    throw new Exception("Please select modules of compatible type.");
                }
                job.setSsm1(ssm1);
                DataMigSwitchPanel.this.setModelValue("sw1", ssm1);
                job.setSsm2(ssm2);
                DataMigSwitchPanel.this.setModelValue("sw2", ssm2);
                DataMigSwitchPanel.this.setModelValue("dualSSMSelected", ssm1 != null && ssm2 != null);
                if (!((DataMigWizard)DataMigSwitchPanel.this.getWizard()).isMethod3()) {
                    DataMigSwitchPanel.this.setModelValue("displayManualMultiPath", new Boolean(DataMigSwitchPanel.this._manualPath.isSelected()));
                    if (job.getType() == -86) {
                        if (!((DataMigWizard)DataMigSwitchPanel.this.getWizard()).isCreateJobPduSend()) {
                            DDMServerRif ddmServerRif = (DDMServerRif)DataMigSwitchPanel.this.getModelValue("ServerRif");
                            DDMCreationRif dmCreateRif = ddmServerRif.createJob(job);
                            DataMigSwitchPanel.this.setModelValue("CreateRif", dmCreateRif);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DataMigSwitchPanel.this.getWizard().setStatus("Creating job, please wait...");
                                }
                            });
                            dmCreateRif.initialize();
                            ((DataMigWizard)DataMigSwitchPanel.this.getWizard()).setCreateJobPduSend(true);
                            job = dmCreateRif.getJobObject();
                            DataMigSwitchPanel.this.setModelValue("jobData", job);
                        }
                        ((DataMigWizard)DataMigSwitchPanel.this.getWizard()).getLunMap();
                    } else {
                        DataMigSwitchPanel.this.getWizard().addPanel("dppvi", new DataMigDPPVIPanel(DataMigSwitchPanel.this.getWizard(), DataMigSwitchPanel.this._migType));
                        DataMigSwitchPanel.this.setModelValue("jobData", job);
                    }
                    if (!this.keepRunning(DataMigSwitchPanel.this._cfgThread)) {
                        return;
                    }
                } else {
                    DataMigSwitchPanel.this.getWizard().addPanel("dataMoverSSM", new DataMoverSSMPanel(DataMigSwitchPanel.this.getWizard(), DataMigSwitchPanel.this._migType));
                }
                this.setupConfigStatus(false, true, null);
                DataMigSwitchPanel.this.goNext();
            }
            catch (Exception ex) {
                if (!this.keepRunning(DataMigSwitchPanel.this._cfgThread)) {
                    return;
                }
                this.setupConfigStatus(false, true, ex);
                return;
            }
        }
    }
}

