/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InsertIlcFlow
extends InsertForm
implements ListSelectionListener,
ItemListener {
    private static final int INDEX = 0;
    private static final int INITIATOR = 2;
    private static final int INITIATOR_VSAN = 3;
    private static final int TARGET = 5;
    private static final int TARGET_VSAN = 6;
    private static final int WRTACC = 8;
    private static final int BUFCNT = 9;
    private static final int STATSENABLED = 10;
    private JList _initiators;
    private JList _targets;
    private JTextField _initiator;
    private JTextField _target;

    public InsertIlcFlow(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._labels[0].setVisible(false);
        this._values[0].setVisible(false);
        this.setEnabled(9, false);
        ((JCheckBox)this._values[8]).addItemListener(this);
        ((JCheckBox)this._values[10]).setText("Enable Statistics");
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 2) {
            this._initiators = new JList(this.fetchValidInitiators());
            this._initiators.addListSelectionListener(this);
            this._initiator = new JTextField();
            return this.createList(this._initiators, this._initiator);
        }
        if (index == 5) {
            this._targets = new JList();
            this._targets.addListSelectionListener(this);
            this._target = new JTextField();
            return this.createList(this._targets, this._target);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    private JComponent createList(JList list, JTextField wwn) {
        JPanel panel = new JPanel(new BorderLayout(1, 2));
        JScrollPane sp = new JScrollPane(list);
        sp.setPreferredSize(new Dimension(400, 100));
        panel.add("Center", sp);
        panel.add("South", wwn);
        return panel;
    }

    private Vector fetchValidInitiators() {
        Vector<EndPort> initiators = new Vector<EndPort>();
        EndPort[] ep = ClientController.getInstance().getFabric().getEndPorts();
        for (int i = 0; i < ep.length; ++i) {
            boolean isEmcOrHds;
            Switch sw = ep[i].getSwitch();
            boolean bl = isEmcOrHds = WwnDictionary.isEMCWwn(ep[i].getPortWwn().getValue()) || WwnDictionary.isHDSWwn(ep[i].getPortWwn().getValue());
            if (ep[i].isTarget() && (!ep[i].isTarget() || !isEmcOrHds) || !sw.isMDS() || !sw.isManageable() || sw.getVersion().compareTo("2.0") < 0 || !this.ilcAttached(ep[i], sw)) continue;
            initiators.addElement(ep[i]);
        }
        return initiators;
    }

    private boolean ilcAttached(EndPort ep, Switch sw) {
        int cardNo = ep.getIfIndex() >> 19 & 0x1F;
        Card card = sw.getCard(cardNo + 1);
        return card != null && (card.getType() == 5 || card.getType() == 20);
    }

    private Vector fetchValidTargets(Object initiator) {
        Vector targets = new Vector();
        if (initiator != null) {
            EndPort init = (EndPort)initiator;
            this._choice.setSelectedItem(init.getSwitch().getPeer());
            Fabric f = ClientController.getInstance().getFabric();
            Vsan[] vsans = f.getVsansById(init.getFirstVsanId());
            try {
                for (int vid = 0; vid < vsans.length; ++vid) {
                    Vsan vsan = vsans[vid];
                    EnforcedZone[] ez = vsan.getEnforcedZones();
                    if (ez == null) continue;
                    block3: for (int i = 0; i < ez.length; ++i) {
                        Array members = ez[i].getMembers();
                        for (int j = 0; j < members.size(); ++j) {
                            EnforcedZoneMember ezm = (EnforcedZoneMember)members.elementAt(j);
                            EndPort ep = ezm.getEndPort(vsan.getFabric());
                            if (ep != init) continue;
                            this.addTargets(targets, members, init, vsan);
                            continue block3;
                        }
                    }
                }
                EnforcedZone[] ivrez = f.getIvrEnforcedZones();
                if (ivrez != null) {
                    block5: for (int i = 0; i < ivrez.length; ++i) {
                        Array members = ivrez[i].getMembers();
                        for (int j = 0; j < members.size(); ++j) {
                            EnforcedZoneMember ezm = (EnforcedZoneMember)members.elementAt(j);
                            EndPort ep = ezm.getEndPort(f);
                            if (ep != init) continue;
                            this.addTargets(targets, members, init, null);
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return targets;
    }

    private void addTargets(Vector targets, Array members, EndPort init, Vsan vsan) {
        for (int j = 0; j < members.size(); ++j) {
            Fabric f;
            EnforcedZoneMember ezm = (EnforcedZoneMember)members.elementAt(j);
            EndPort ep = ezm.getEndPort(f = vsan != null ? vsan.getFabric() : ClientController.getInstance().getFabric());
            if (ep == null || !ep.isTarget() || targets.contains(ep)) continue;
            targets.addElement(ep);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        EndPort ep;
        if (e.getSource() == this._initiators) {
            EndPort ep2 = (EndPort)this._initiators.getSelectedValue();
            if (ep2 != null) {
                this._targets.setListData(this.fetchValidTargets(ep2));
                this._initiator.setText(SnmpString.toHexString(ep2.getPortWwn().getValue()));
                ((FieldPanel)this._values[3]).setText(Short.toString(ep2.getFirstVsanId()));
            }
        } else if (e.getSource() == this._targets && (ep = (EndPort)this._targets.getSelectedValue()) != null) {
            this._target.setText(SnmpString.toHexString(ep.getPortWwn().getValue()));
            ((FieldPanel)this._values[6]).setText(Short.toString(ep.getFirstVsanId()));
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        switch (index) {
            case 0: {
                SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                VarBindList vbl = new VarBindList();
                vbl.add(MibNode.get("ciscoScsiFlowNextIndexAvail").getOid(), 0);
                SnmpPDU req = new SnmpPDU(-96, vbl);
                SnmpPDU resp = peer.send(req);
                return resp.getVar(0);
            }
            case 2: {
                return new SnmpWWN(this._initiator.getText(), false);
            }
            case 5: {
                return new SnmpWWN(this._target.getText(), false);
            }
        }
        return super.getComponentValue(index);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected = e.getStateChange() == 1;
        JComponent comp = (JComponent)e.getSource();
        if (comp == this._values[8]) {
            this.setEnabled(9, isSelected);
        }
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 3 || index == 6) {
            return new JLabel("VSAN:");
        }
        return super.createFormLabel(mibVar, index);
    }
}

