/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class InsertSvcPort
extends InsertForm {
    private static final int INTERFACE = 0;
    private static final int VSANID = 2;
    private static final int PWWN = 3;

    public InsertSvcPort(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this.setComponentText(0, "svc");
        this.setComponentVisibleAt(3, false);
    }

    @Override
    protected boolean toGetComponentValue(int index) {
        return index != 3 && super.toGetComponentValue(index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            return new FieldPanel(mibNode.getMaxWidth());
        }
        if (index == 2) {
            Collection<Vsan> vsanCollection = ClientController.getInstance().getFabric().getVsansCollection();
            ArrayList<Vsan> vsanList = new ArrayList<Vsan>(vsanCollection);
            Collections.sort(vsanList);
            return new JComboBox<Vsan>(vsanList.toArray(new Vsan[vsanList.size()]));
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Svc Interface:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            String ifName = ((FieldPanel)this._values[index]).getText();
            if (ifName.length() == 0) {
                throw new Exception("Interface: invalid entry");
            }
            return new SnmpInt(this.getSelectedIfIndexIf().nameToIfIndex(ifName));
        }
        if (index == 2) {
            Vsan vsan = (Vsan)((JComboBox)this._values[index]).getSelectedItem();
            return new SnmpInt(vsan.getId());
        }
        return super.getComponentValue(index);
    }
}

