/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCrypto;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.UserData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

class PasswordDialog
extends JDialog
implements ActionListener {
    static final String[] _BtnLabels = new String[]{"Apply", "Close"};
    JComponent[] _values;
    JLabel[] _labels;
    JButton[] _buttons;
    JLabel _status;
    String[] _vars;
    SnmpPeer[] _peers;
    JPanel _actPanel;
    JPanel _userPanel;
    JList _switchSelection;
    JList _userSelection;
    JComboBox _choice;
    JComboBox _users;
    static final String[] _Labels = new String[]{null, null, "Old Password:", "New Password:", "Confirm Password:", null, "Old Password:", "New Password:", "Confirm Password:"};
    static final int AUTH_PANEL = 1;
    static final int OLD_AUTHPWD = 2;
    static final int NEW_AUTHPWD = 3;
    static final int CONFIRM_AUTHPWD = 4;
    static final int PRIV_PANEL = 5;
    static final int OLD_PRIVPWD = 6;
    static final int NEW_PRIVPWD = 7;
    static final int CONFIRM_PRIVPWD = 8;
    protected JCheckBox _privLevel;
    protected JCheckBox _authLevel;
    protected JCheckBox _authSHA;
    protected JCheckBox _privAES;
    boolean _isPrivEnabled = false;
    boolean _isAuthEnabled = true;
    public static final int AUTH = 1;
    public static final int PRIV = 2;
    public static final int AUTHPRIV = 3;
    static final int NONE = 4;
    HashMap _peer2User;

    public PasswordDialog(JFrame parent, SnmpPeer[] peers, HashMap peer2User) {
        super((Frame)parent, "Change Passwords");
        this._peer2User = peer2User;
        this._peers = peers;
        this._labels = DialogUtil.buildLabels(_Labels);
        this._values = new JComponent[this._labels.length];
        this._values[0] = new JLabel("");
        JPanel authPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._authLevel = new JCheckBox("Authentication", false);
        authPanel.add(this._authLevel);
        this._authSHA = new JCheckBox("SHA", false);
        authPanel.add(this._authSHA);
        this._values[1] = authPanel;
        JPanel privacyPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._privLevel = new JCheckBox("Privacy", false);
        privacyPanel.add(this._privLevel);
        this._privAES = new JCheckBox("AES", false);
        privacyPanel.add(this._privAES);
        this._values[5] = privacyPanel;
        this._authSHA.setVisible(false);
        this._privAES.setVisible(false);
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i] != null) continue;
            this._values[i] = new JPasswordField(20);
        }
        this._privLevel.setSelected(false);
        this._authLevel.setSelected(true);
        this._privLevel.addActionListener(this);
        this._authLevel.addActionListener(this);
        this._values[6].setEnabled(false);
        this._values[7].setEnabled(false);
        this._values[8].setEnabled(false);
        this._labels[6].setEnabled(false);
        this._labels[7].setEnabled(false);
        this._labels[8].setEnabled(false);
        this._isAuthEnabled = true;
        this._isPrivEnabled = false;
        JPanel fields = DialogUtil.buildPanel(this._labels, this._values);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = DialogUtil.getInsets();
        this._choice = new JComboBox<SnmpPeer>(this._peers);
        JLabel _switchLabel = new JLabel("Switch:");
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        DialogUtil.constrain(fields, this._choice, gbc, 1, 0, 2, 17);
        DialogUtil.constrain(fields, _switchLabel, gbc, 0, 0, 0, 13);
        this._users = new JComboBox<UserData>(this.getUserList(this._peers[0]));
        this._users.addActionListener(this);
        this._authSHA.setSelected(this._users.getItemCount() == 0 ? false : ((UserData)this._users.getSelectedItem()).isSHA());
        this._privAES.setSelected(this._users.getItemCount() == 0 ? false : ((UserData)this._users.getSelectedItem()).isAES());
        JLabel _userLabel = new JLabel("User:");
        DialogUtil.constrain(fields, this._users, gbc, 1, 1, 2, 17);
        DialogUtil.constrain(fields, _userLabel, gbc, 0, 1, 0, 13);
        JPanel p = new JPanel(new BorderLayout());
        p.add("Center", fields);
        this._status = new JLabel(" ");
        p.add("South", this._status);
        this._buttons = DialogUtil.buildButtons(_BtnLabels, (ActionListener)this);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)p, (AbstractButton[])this._buttons);
        this.setResizable(true);
    }

    UserData[] getUserList(SnmpPeer peer) {
        Array userIndices = (Array)this._peer2User.get(peer);
        if (userIndices == null) {
            return new UserData[0];
        }
        UserData[] list = new UserData[userIndices.size()];
        for (int i = 0; i < userIndices.size(); ++i) {
            list[i] = (UserData)userIndices.elementAt(i);
        }
        return list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block15: {
            if (e.getSource() == this._privLevel || e.getSource() == this._authLevel) {
                int confirmPos;
                int newPos;
                int oldPos;
                boolean isEnabled;
                if (e.getSource() == this._authLevel) {
                    isEnabled = ((JCheckBox)e.getSource()).isSelected();
                    this._isAuthEnabled = isEnabled;
                    oldPos = 2;
                    newPos = 3;
                    confirmPos = 4;
                } else {
                    isEnabled = ((JCheckBox)e.getSource()).isSelected();
                    this._isPrivEnabled = isEnabled;
                    oldPos = 6;
                    newPos = 7;
                    confirmPos = 8;
                }
                if (e.getSource() != this._authLevel || isEnabled) {
                    this._values[oldPos].setEnabled(isEnabled);
                }
                this._values[newPos].setEnabled(isEnabled);
                this._values[confirmPos].setEnabled(isEnabled);
                if (e.getSource() != this._authLevel || isEnabled) {
                    this._labels[oldPos].setEnabled(isEnabled);
                }
                this._labels[newPos].setEnabled(isEnabled);
                this._labels[confirmPos].setEnabled(isEnabled);
                return;
            }
            if (e.getSource() == this._choice) {
                SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                if (peer != null) {
                    UserData[] userList = this.getUserList(peer);
                    this._users.setModel(new DefaultComboBoxModel<UserData>(userList));
                    if (userList.length > 0) {
                        this._users.setSelectedIndex(0);
                    }
                    this._authSHA.setSelected(((UserData)this._users.getSelectedItem()).isSHA());
                    this._privAES.setSelected(((UserData)this._users.getSelectedItem()).isAES());
                }
                return;
            }
            if (e.getSource() == this._users) {
                this._authSHA.setSelected(((UserData)this._users.getSelectedItem()).isSHA());
                this._privAES.setSelected(((UserData)this._users.getSelectedItem()).isAES());
                return;
            }
            try {
                switch (((AbstractButton)e.getSource()).getText().charAt(0)) {
                    case 'A': {
                        if (this.applyAction()) break;
                        return;
                    }
                    case 'C': {
                        this.dispose();
                    }
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block15;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    void passwordConfirmed() throws Exception {
        String auth_pwd = ((JTextComponent)this._values[3]).getText();
        String priv_pwd = ((JTextComponent)this._values[7]).getText();
        String auth_cfm_pwd = ((JTextComponent)this._values[4]).getText();
        String priv_cfm_pwd = ((JTextComponent)this._values[8]).getText();
        String confirm_fail_msg = "Passwords do not match";
        String length_fail_msg = "Password needs to be at least 8 characters long";
        if (this._values[7].isEnabled()) {
            if (priv_pwd.length() < 8) {
                throw new Exception(length_fail_msg);
            }
            if (!priv_pwd.equals(priv_cfm_pwd)) {
                throw new Exception(confirm_fail_msg);
            }
        } else if (this._values[3].isEnabled()) {
            if (auth_pwd.length() < 8) {
                throw new Exception(length_fail_msg);
            }
            if (!auth_pwd.equals(auth_cfm_pwd)) {
                throw new Exception(confirm_fail_msg);
            }
        }
        if (!this._isAuthEnabled && ((JTextComponent)this._values[2]).getText().equals("")) {
            throw new Exception("Old Authentication Password needed to validate old Privacy Password");
        }
        if (!PasswordDialog.validateUSMUserPassword((SnmpPeer)this._choice.getSelectedItem(), ((UserData)this._users.getSelectedItem()).getUser(), this._authSHA.isSelected() ? 1 : 0, ((JTextComponent)this._values[2]).getText().equals("") ? null : ((JTextComponent)this._values[2]).getText(), this._privAES.isSelected() ? 1 : 0, ((JTextComponent)this._values[6]).getText().equals("") ? null : ((JTextComponent)this._values[6]).getText())) {
            throw new Exception("Invalid old password");
        }
    }

    boolean applyAction() throws Exception {
        String userName;
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        String string = userName = this._users.getItemCount() == 0 ? null : ((UserData)this._users.getSelectedItem()).getUser();
        if (peer == null || userName == null) {
            Util.errorMessage((Component)this, "Please select switch and user");
            this._status.setText(" ");
            return false;
        }
        int[] index = new int[peer.getEngineId().length + userName.length() + 2];
        index[0] = peer.getEngineId().length;
        for (int i = 1; i <= peer.getEngineId().length; ++i) {
            index[i] = peer.getEngineId()[i - 1] & 0xFF;
        }
        index[i++] = userName.length();
        for (int j = 0; j < userName.length(); ++j) {
            index[i++] = userName.charAt(j);
        }
        byte[] engineId = peer.getEngineId();
        String sessionAuthPwd = ((JTextComponent)this._values[2]).getText();
        String newAuthPassword = ((JTextComponent)this._values[3]).getText();
        String sessionPrivPwd = ((JTextComponent)this._values[6]).getText();
        String newPrivPassword = ((JTextComponent)this._values[7]).getText();
        try {
            this.passwordConfirmed();
            try {
                byte[] keyChange;
                int flag;
                int n = this._isAuthEnabled ? (this._isPrivEnabled ? 3 : 1) : (flag = this._isPrivEnabled ? 2 : 0);
                if (flag == 0) {
                    Util.errorMessage((Component)this, "Please select security level");
                    this._status.setText(" ");
                    return false;
                }
                this._status.setText("changing password(s)...");
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                if (flag == 1 || flag == 3) {
                    keyChange = SnmpCrypto.getKeyChange(sessionAuthPwd, newAuthPassword, engineId, this._authSHA.isSelected() ? 1 : 0);
                    pdu.addVar(new SnmpOID(MibNode.get("usmUserAuthKeyChange").getOid(), index), new SnmpString(keyChange));
                }
                if (flag == 2 || flag == 3) {
                    keyChange = SnmpCrypto.getKeyChange(sessionPrivPwd, newPrivPassword, engineId, this._authSHA.isSelected() ? 1 : 0);
                    pdu.addVar(new SnmpOID(MibNode.get("usmUserPrivKeyChange").getOid(), index), new SnmpString(keyChange));
                }
                peer.set(pdu);
                this._status.setText("ok");
                if (userName.equals(peer.getUserName())) {
                    peer.setCredentials(peer.getSession(), peer.getUserName(), newAuthPassword, peer.getAuthProtocol(), newPrivPassword, peer.getPrivProtocol());
                }
            }
            catch (Exception ex) {
                if (ex.getMessage().indexOf("commitFailed") != -1) {
                    throw new SnmpException("Clone Privacy Password non-existing");
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        return true;
    }

    public static boolean validateUSMUserPassword(SnmpPeer peer, String userName, int authProtocol, String authPassword, int privProtocol, String privPassword) {
        SnmpPeer tmpPeer = null;
        try {
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
            pdu.addNull(new SnmpOID(MibNode.get("sysObjectID").getOid(), 0));
            tmpPeer = new SnmpPeer(peer.getAddress(), peer.getSession(), userName, authPassword, authProtocol, privPassword, privProtocol);
            SnmpPeer.addPeer(tmpPeer);
            tmpPeer.send(pdu);
        }
        catch (SnmpException ex) {
            if (tmpPeer != null) {
                SnmpPeer.removePeer(tmpPeer);
            }
            SnmpPeer.addPeer(peer);
            return false;
        }
        if (tmpPeer != null) {
            SnmpPeer.removePeer(tmpPeer);
        }
        SnmpPeer.addPeer(peer);
        return true;
    }
}

