/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.util.ArrayList;

public class SmAsmBaseTableModel
extends SmTableModel {
    protected int _asmTimeout = -1;

    @Override
    protected SnmpPeer[] getWrkingPeers(SnmpPeer[] peers) {
        ArrayList<SnmpPeer> ssmPeer = new ArrayList<SnmpPeer>();
        block0: for (int i = 0; i < peers.length; ++i) {
            Card[] cards;
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peers[i].getAddress());
            if (sw == null || (cards = sw.getCards()) == null) continue;
            for (int j = 0; j < cards.length; ++j) {
                if (cards[j] == null || !this.isValidCard(sw, cards[j])) continue;
                ssmPeer.add(peers[i]);
                continue block0;
            }
        }
        if (ssmPeer.size() == 0) {
            return null;
        }
        peers = ssmPeer.toArray(new SnmpPeer[ssmPeer.size()]);
        return super.getWrkingPeers(peers);
    }

    protected boolean isValidCard(Switch sw, Card card) {
        return card.getType() == 5 || card.getType() == 20;
    }

    @Override
    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        SnmpPDU newPdu = super.processDeleteRow(node, pdu, rowN);
        if (this._asmTimeout != -1) {
            newPdu.setTimeout(this._asmTimeout);
        }
        return newPdu;
    }

    @Override
    protected SnmpAggregrate getDeleteSnmpAggregrate() {
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        if (this._asmTimeout != -1) {
            aggregrate.setTimeOut(this._asmTimeout);
        }
        return aggregrate;
    }
}

