/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.portland.lib.util.CommonRoleExtUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmCommonRoleTableModel;
import com.cisco.dcbu.sm.client.dialogs.SmRoleUtil;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;
import java.util.HashMap;

public class SmCommonRoleExtTableModel
extends SmCommonRoleTableModel {
    static final int PEER_MDL_COL_IDX = 0;
    static final int NAME_MDL_COL_IDX = 1;
    static final int DESC_MDL_COL_IDX = 2;
    static final int VSAN_SCOPE_ENABLE_MDL_COL_IDX = 3;
    static final int VSAN_SCOPE_MDL_COL_IDX = 4;
    static final int VLAN_SCOPE_ENABLE_MDL_COL_IDX = 5;
    static final int VLAN_SCOPE_MDL_COL_IDX = 6;
    static final int INTFACE_SCOPE_ENABLE_MDL_COL_IDX = 7;
    static final int INTFACE_SCOPE_MDL_COL_IDX = 8;
    static final int VSAN_BIT = 0;
    static final int VLAN_BIT = 1;
    static final int INTFACE_BIT = 2;
    protected static final int[] ccreRowStatus = MibNode.get("ccreRoleRowStatus").getOid();

    public SmCommonRoleExtTableModel() {
        this.setCfsFeatureName("role");
    }

    private boolean isN5K(SnmpPeer node) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        return sw.isN5K();
    }

    @Override
    protected MibNode[] getMibNodes(Switch sw) {
        MibNode[] mibNodes = null;
        if (sw.isN5K() || !sw.isMDS()) {
            if (this._switch2MibNodes != null) {
                mibNodes = (MibNode[])this._switch2MibNodes.get(sw.getModelType());
            }
        } else {
            mibNodes = this._mibNodes;
        }
        return mibNodes;
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        if (this.isN5K(node)) {
            int[] indexOid = index.getValue();
            SmRoleUtil.getInstance().addRole(node, SnmpString.toString(indexOid, 1, indexOid.length));
            Object[] lRow = this.createRow();
            this._responseData.addElement(lRow);
            lRow[0] = node;
            if (index != null) {
                lRow[1] = index;
            }
            SnmpString lDesc = (SnmpString)vbl.get(0).getVar();
            lDesc.cacheString(true);
            lRow[2] = lDesc;
            SnmpString lPolicies = (SnmpString)vbl.get(1).getVar();
            lRow[3] = !SnmpString.getBitBase0(lPolicies.getValue(), 0);
            lRow[5] = !SnmpString.getBitBase0(lPolicies.getValue(), 1);
            lRow[7] = !SnmpString.getBitBase0(lPolicies.getValue(), 2);
            HashMap<Integer, ArrayList<CommonRoleExtUtil.CommonRoleExtScope>> lScopesHash = CommonRoleExtUtil.getInstance().getScopesForRole(node, index.getValue());
            if (lScopesHash != null) {
                lRow[4] = StringUtil.getRangeString(this.getScopes(lScopesHash, 1));
                lRow[6] = StringUtil.getRangeString(this.getScopes(lScopesHash, 2));
                lRow[8] = new SnmpIntList(SnmpIntList.valueOf(this.getScopes(lScopesHash, 3)), (IfIndexIf)ClientController.findFabricSwitchByIpAddress(node.getAddress()));
            }
            return lRow;
        }
        Object[] lRow = super.addElement(vbl, node, index);
        lRow[7] = false;
        lRow[5] = false;
        lRow[8] = "n/a";
        lRow[6] = "n/a";
        return lRow;
    }

    private int[] getScopes(HashMap<Integer, ArrayList<CommonRoleExtUtil.CommonRoleExtScope>> scopesHash, int scopeRestriction) {
        if (scopesHash == null) {
            return new int[0];
        }
        ArrayList<CommonRoleExtUtil.CommonRoleExtScope> lList = scopesHash.get(scopeRestriction);
        if (lList == null) {
            return new int[0];
        }
        int[] lScopes = new int[lList.size()];
        int i = 0;
        for (CommonRoleExtUtil.CommonRoleExtScope lScope : lList) {
            lScopes[i] = lScope.getValue();
            ++i;
        }
        return lScopes;
    }

    @Override
    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (sw.isN5K()) {
            pdu.addVar(new SnmpOID(ccreRowStatus, this.getIndex(rowN)), new SnmpInt(this._deleteValue));
            return pdu;
        }
        return super.processDeleteRow(node, pdu, rowN);
    }

    protected void validateChanges(Array cells) throws Exception {
        for (int i = 0; i < cells.size(); ++i) {
            Cell lCell = (Cell)cells.elementAt(i);
            if (lCell._col == 4 || lCell._col == 6) {
                String scopes = (String)this.getValueAt(lCell._row, lCell._col);
                if (lCell._col == 4) {
                    CommonRoleExtUtil.validateVlanVsanScopes(scopes, "Vsan Scope");
                    continue;
                }
                if (lCell._col != 6) continue;
                CommonRoleExtUtil.validateVlanVsanScopes(scopes, "Vlan Scope");
                continue;
            }
            if (lCell._col != 8) continue;
            SnmpIntList lScopes = (SnmpIntList)this.getValueAt(lCell._row, lCell._col);
            SnmpPeer peer = (SnmpPeer)this.getValueAt(lCell._row, 0);
            if (peer == null) continue;
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            CommonRoleExtUtil.validateIntFaceScopes(lScopes, "Interface Scope", sw);
        }
    }

    @Override
    public Class getColumnClass(int r, int c) {
        if (c == 8) {
            return SnmpIntList.class;
        }
        return super.getColumnClass(r, c);
    }

    @Override
    public Object getSetValueAt(Object aValue, int row, int col) {
        if (col == 8) {
            try {
                aValue = new SnmpIntList(aValue.toString().trim(), this.getIfIndexIf(row));
            }
            catch (SnmpException ex) {
                Util.errorMessage(this.getErrorComponent(), ex);
            }
        } else {
            aValue = super.getSetValueAt(aValue, row, col);
        }
        return aValue;
    }

    protected SnmpPDU getPDU(HashMap pdus, SnmpPeer node) {
        SnmpPDU lPdu = (SnmpPDU)pdus.get(node);
        if (lPdu == null) {
            lPdu = new SnmpPDU(-93, new VarBindList());
            lPdu.setAddress(node.getAddress());
            pdus.put(node, lPdu);
        }
        return lPdu;
    }

    @Override
    protected void addChangedCells2Pdu(HashMap pdus, Array cells, Array warningMsg) throws Exception {
        this.validateChanges(cells);
        ArrayList<Integer> lScopeEnableForRows = new ArrayList<Integer>();
        ArrayList<Integer> lScopesSetForRows = new ArrayList<Integer>();
        HashMap N5KRolePDUs = new HashMap();
        for (int i = 0; i < cells.size(); ++i) {
            Cell lCell = (Cell)cells.elementAt(i);
            int lCol = lCell._col;
            int lRow = lCell._row;
            SnmpPeer node = this.getRowPeer(lRow);
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            if (sw.isN5K()) {
                SnmpPDU lScopePdu = this.getPDU(pdus, node);
                SnmpPDU lPdu = this.getPDU(N5KRolePDUs, node);
                int[] lRoleNameIndex = this.getCellSetIndex(lCell);
                SnmpOID lOid = this.getCellOid(lCell, lRoleNameIndex, node);
                if (lCol == 4 || lCol == 6 || lCol == 8) {
                    if (lScopesSetForRows.contains(lRow)) continue;
                    lScopesSetForRows.add(lRow);
                    this.deleteScopes(lRoleNameIndex, node);
                    this.addScopes(lScopePdu, lRow);
                    continue;
                }
                if (lCol == 3 || lCol == 5 || lCol == 7) {
                    if (lScopeEnableForRows.contains(lRow)) continue;
                    lScopeEnableForRows.add(lRow);
                    lPdu.addVar(lOid, this.getUpdatedPolicyString(lRow));
                    continue;
                }
                lPdu.addVar(lOid, this.getChangedCellVar(lRow, lCol, null, null));
                continue;
            }
            this.addCell2Pdu(pdus, cells, lCell, warningMsg);
        }
        for (SnmpPeer node : N5KRolePDUs.keySet()) {
            SnmpPDU lPdu = (SnmpPDU)N5KRolePDUs.get(node);
            if (lPdu == null) continue;
            node.set(lPdu);
        }
    }

    private int[] getScopesToBeInserted(Object o, int col) throws Exception {
        int[] lScopeValues = null;
        if (col == 4 || col == 6) {
            Array ids = StringUtil.tokenize(o.toString(), ",", "-", 10, true, 1, 4096, true);
            lScopeValues = new int[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                lScopeValues[i] = (Integer)ids.elementAt(i);
            }
        } else if (col == 8) {
            lScopeValues = SnmpIntList.valueOf(((SnmpIntList)o).getValue());
        }
        return lScopeValues;
    }

    private int getRestrictionToBeInserted(int col) {
        switch (col) {
            case 4: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Scope Restriction not defined for col: " + col);
    }

    private void addScopes(SnmpPDU pdu, int row) throws Exception {
        int[] lRoleNameIndex = this.getIndex(row);
        ArrayList pduList = new ArrayList();
        int[] lCols = new int[]{4, 6, 8};
        int lCount = 1;
        for (int lCol : lCols) {
            Object o = this.getValueAt(row, lCol);
            if (o == null || o.toString() == null || o.toString().length() == 0) continue;
            int[] lValues = this.getScopesToBeInserted(o, lCol);
            int rest = this.getRestrictionToBeInserted(lCol);
            if (lValues == null) continue;
            for (int value : lValues) {
                SnmpOID index = new SnmpOID(lRoleNameIndex, lCount);
                CommonRoleExtUtil.getInstance().createNewScope(pdu, index.getValue(), new SnmpInt(rest), new SnmpInt(value));
                ++lCount;
            }
        }
    }

    private void deleteScopes(int[] roleNameIndex, SnmpPeer node) throws SnmpException {
        HashMap<Integer, ArrayList<CommonRoleExtUtil.CommonRoleExtScope>> lScopesHash = CommonRoleExtUtil.getInstance().getScopesForRole(node, roleNameIndex);
        if (lScopesHash != null) {
            for (int lRestType : lScopesHash.keySet()) {
                ArrayList<CommonRoleExtUtil.CommonRoleExtScope> lScopesList = lScopesHash.get(lRestType);
                if (lScopesList == null) continue;
                SnmpPDU lPdu = new SnmpPDU(-93, new VarBindList(lScopesList.size()));
                int[] lRowStatusOid = MibNode.get("ccreRoleScopeRowStatus").getOid();
                int[] lFullScopeIndex = new int[roleNameIndex.length + 1];
                System.arraycopy(roleNameIndex, 0, lFullScopeIndex, 0, roleNameIndex.length);
                for (CommonRoleExtUtil.CommonRoleExtScope scope : lScopesList) {
                    lFullScopeIndex[lFullScopeIndex.length - 1] = scope.getIndex();
                    SnmpOID lOid = new SnmpOID(lRowStatusOid, lFullScopeIndex);
                    lPdu.addVar(lOid, new SnmpInt(this._deleteValue));
                }
                node.set(lPdu);
            }
        }
    }

    private SnmpString getUpdatedPolicyString(int row) {
        byte[] b = new byte[1];
        if (!((Boolean)this.getValueAt(row, 3)).booleanValue()) {
            SnmpString.setBitBase0(b, 0);
        }
        if (!((Boolean)this.getValueAt(row, 5)).booleanValue()) {
            SnmpString.setBitBase0(b, 1);
        }
        if (!((Boolean)this.getValueAt(row, 7)).booleanValue()) {
            SnmpString.setBitBase0(b, 2);
        }
        return new SnmpString(b);
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (this.isN5K(this.getRowPeer(row))) {
            if (col == 4 || col == 6 || col == 8) {
                Object o = this.getValueAt(row, col - 1);
                return o != null && (Boolean)o != false;
            }
        } else if (col > 4) {
            return false;
        }
        return super.isCellActive(row, col);
    }
}

