/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.VshDump;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmDpvmTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmCfsUtil;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SmDpvmActiveTableModel
extends SmDpvmTableModel
implements ActionListener {
    JPanel _newToolbar;
    JPanel _actPanel;
    JComboBox _compareList;
    static final String[] CompareList = new String[]{"None", "Config"};
    static final String[] CompareList_2_1_2 = new String[]{"None", "Config", "Pending"};
    static final int COMPARE_W_NONE = 0;
    static final int COMPARE_W_CONFIG = 1;
    static final int COMPARE_W_PENDNG = 2;

    public void addCompare() {
        SnmpPeer master = SmCfsUtil.getInstance().getMaster("dpvm");
        if (master != null) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(master.getAddress());
            boolean isMasterGreaterEqual211 = sw.isVersionGreaterThanEqual("2.1(1.84)");
            DataView dataView = BrowserFrame.getDataView();
            this._actPanel = new JPanel(new FlowLayout(0, 2, 2));
            this._actPanel.add(new JLabel("Compare with:"));
            this._compareList = new JComboBox<String>(isMasterGreaterEqual211 ? CompareList_2_1_2 : CompareList);
            this._compareList.setSelectedIndex(0);
            this._compareList.addActionListener(this);
            this._compareList.setActionCommand("CP");
            this._actPanel.add(this._compareList);
            JPanel _newToolbar = new JPanel(new FlowLayout(2, 2, 2));
            _newToolbar.add(dataView.getDefaultButtonPanel());
            _newToolbar.add(this._actPanel);
            dataView.replaceButtonPanel(_newToolbar);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (e.getActionCommand().equals("CP")) {
            int compareCmd = this._compareList.getSelectedIndex();
            CompareDBDiffAction thread = new CompareDBDiffAction(compareCmd);
            thread.start();
            return;
        }
    }

    @Override
    public void translatePwwn(Object[] row, VarBindList vbl) {
        this.MAC_COL = 8;
        this.DEVICE_ALIAS_COL = 7;
        super.translatePwwn(row, vbl);
    }

    @Override
    public int compare(Object first, Object second) {
        if (first instanceof Wwn || second instanceof Wwn) {
            if (first.toString().equals(second.toString())) {
                return 0;
            }
            if (first.toString() == null) {
                return -1;
            }
            if (second.toString() == null) {
                return 1;
            }
            return first.toString().compareToIgnoreCase(second.toString());
        }
        return super.compare(first, second);
    }

    class CompareDBDiffAction
    extends Thread {
        int _compareCmd;

        CompareDBDiffAction(int compareCmd) {
            this._compareCmd = compareCmd;
        }

        @Override
        public void run() {
            try {
                if (this._compareCmd == 1) {
                    String[] cmd = new String[]{"dpvm database diff active config \n"};
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._DefLogger.debug((Object)("Command :" + cmd[0]));
                    }
                    VshDump dlg = new VshDump(BrowserFrame.getInstance(), "DPVM: Database Differences Between Active and Config", cmd, SmCfsUtil.getInstance().getMaster("dpvm"));
                    dlg.setVisible(true);
                } else if (this._compareCmd == 2) {
                    String[] cmd = new String[]{"dpvm database diff active pending \n"};
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._DefLogger.debug((Object)("Command :" + cmd[0]));
                    }
                    VshDump dlg = new VshDump(BrowserFrame.getInstance(), "DPVM: Database Differences Between Active and Pending", cmd, SmCfsUtil.getInstance().getMaster("dpvm"));
                    dlg.setVisible(true);
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Fail to display DPVM Database differences");
            }
        }
    }
}

