/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.FileNameCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.common.model.ScsiTarget;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputAdapter;

public class SmEnclosureTableModel
extends SmTableModel {
    static final String[] INSERT_LABELS = new String[]{"Name"};
    static final String[] LABELS = new String[]{"Name", "IP Address", "<html>Elem.Mgr<br>Use HTTP", "<html>Elem.Mgr<br>URL/Path", "Device Type", "OS", "Port Count", "VM Count", "VCluster", "VM MultiPath", "CPUs", "Memory", "UCS Service Profile", "UCS Blade", "Other Info", "Vendor", "Serial Number", "Model", "Firmware Ver", "Driver Ver"};
    public static final String EMPTY_STRING = "";
    public static final String SEMI_COLON_STRING = "; ";
    public static final int NAME = 0;
    public static final int ENCIPADDR = 1;
    public static final int DM_HTTP = 2;
    public static final int DM_PATH = 3;
    public static final int DEVICE_TYPE = 4;
    public static final int OS = 5;
    public static final int PORT_COUNT = 6;
    public static final int VM_COUNT = 7;
    public static final int CLUSTER_NAME = 8;
    public static final int MULTIPATH = 9;
    public static final int CPU_COUNT = 10;
    public static final int MEM_SIZE = 11;
    public static final int UCS_PROFILE = 12;
    public static final int UCS_BLADE = 13;
    public static final int OTHER_INFO = 14;
    public static final int VENDOR_ID = 15;
    public static final int SERIAL_NUM = 16;
    public static final int MODEL = 17;
    public static final int VERSION = 18;
    public static final int DRIVER_VERSION = 19;
    protected ArrayList _enclosures = null;
    protected MgmtDomainIf _mgmtDomain;
    protected DecimalFormat _formatter;
    static TableMouseListener _tableMouseListener;
    private boolean _selectAction = true;

    public SmEnclosureTableModel(MgmtDomainIf mgmtDomain) {
        this._mgmtDomain = mgmtDomain;
        this._formatter = new DecimalFormat("#0.##");
    }

    public SmEnclosureTableModel(MgmtDomainIf mgmtDomain, ArrayList enclosures) {
        this(mgmtDomain);
        this._enclosures = enclosures;
    }

    @Override
    public String[] getInsertVars() {
        return INSERT_LABELS;
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public boolean deleteRowsAction(int[] rows) throws Exception {
        if (DataView._ConfirmRowDeletion && JOptionPane.showConfirmDialog(BrowserFrame.getDataView(), "Please confirm deletion", "DCNM-SAN", 0) != 0) {
            return false;
        }
        this._setErrMsg.clear();
        this.deleteRows(rows);
        this.postErrorMsg();
        return true;
    }

    @Override
    public void deleteRows(int[] rows) throws Exception {
        if (rows == null || rows.length == 0) {
            return;
        }
        int row = 0;
        Enclosure[] enclosures = new Enclosure[rows.length];
        Array data = this.getData();
        for (int i = 0; i < rows.length; ++i) {
            row = rows[i];
            Object[] rowData = (Object[])data.elementAt(row);
            enclosures[i] = (Enclosure)this.getDevicebject(rowData);
        }
        try {
            ClientController.getInstance().removeEnclosures(enclosures);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    public ArrayList getEnclosures(ArrayList list) {
        return list;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row >= this.getRowCount() || col >= this.getColumnCount()) {
            return false;
        }
        if (col == 1 || col == 2 || col == 3 || col == 4 || col == 17 || col == 15 || col == 18) {
            boolean isHttp;
            String nm = (String)this.getValueAt(row, 0);
            if (nm == null || nm.length() == 0) {
                return false;
            }
            return col != 3 || !(isHttp = ((Boolean)this.getValueAt(row, 2)).booleanValue());
        }
        return super.isCellEditable(row, col);
    }

    public MouseListener getMouseListener() {
        if (_tableMouseListener == null) {
            _tableMouseListener = new TableMouseListener();
        }
        return _tableMouseListener;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._prefixes = prefixes;
        String[] labels = this.getLabels();
        String[] headers = new String[labels.length];
        System.arraycopy(labels, 0, headers, 0, labels.length);
        boolean[] editable = new boolean[headers.length];
        this._isEditable = true;
        editable[0] = true;
        editable[1] = true;
        editable[2] = true;
        editable[3] = true;
        editable[17] = true;
        editable[15] = true;
        editable[18] = true;
        editable[4] = true;
        editable[5] = true;
        editable[6] = false;
        this.setHeaders(headers);
        this.setEditable(editable);
        boolean[] emptyColumnsHidable = new boolean[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            emptyColumnsHidable[i] = true;
        }
        this.setEmptyColumnsHidable(emptyColumnsHidable);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        return this.getTableVars();
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        return this.getTableVars();
    }

    public String[] getLabels() {
        return LABELS;
    }

    Array getTableVars() throws SnmpException {
        this._responseData = new Array();
        if (this._mgmtDomain == null) {
            this._mgmtDomain = ClientController.getInstance().getSelectedDomain();
        }
        HashedArrayList<Enclosure> enclosureList = null;
        if (this._enclosures == null) {
            enclosureList = this.getEnclosures(null);
        } else if (this._enclosures.get(0) != null && this._enclosures.get(0) instanceof EndPort) {
            enclosureList = new HashedArrayList<Enclosure>();
            for (int i = 0; i < this._enclosures.size(); ++i) {
                Enclosure encl;
                EndPort ep = (EndPort)this._enclosures.get(i);
                if (ep == null || (encl = ep.getEnclosure()) == null || ((ArrayList)enclosureList).contains(encl)) continue;
                ((ArrayList)enclosureList).add(encl);
            }
        } else {
            enclosureList = this._enclosures;
        }
        if (enclosureList == null || enclosureList.size() == 0) {
            return this._responseData;
        }
        Collections.sort(enclosureList);
        String[] labels = this.getLabels();
        StringBuffer deviceType = new StringBuffer(128);
        StringBuffer vendorId = new StringBuffer(128);
        StringBuffer serNum = new StringBuffer(128);
        StringBuffer drVersion = new StringBuffer(128);
        StringBuffer otherInfo = new StringBuffer(128);
        for (int i = 0; i < enclosureList.size(); ++i) {
            Enclosure encl = (Enclosure)enclosureList.get(i);
            if (encl == null) continue;
            Object[] row = new Object[labels.length + 2];
            row[0] = encl.getEnclosureName();
            row[1] = encl.getIpAddress();
            String path = encl.getDMPath();
            row[2] = path == null ? Boolean.FALSE : Boolean.valueOf(path.startsWith("http://"));
            row[3] = path == null ? EMPTY_STRING : path;
            row[15] = encl.getVendor();
            row[17] = encl.getModel();
            row[18] = encl.getVersion();
            row[5] = encl.getOSInfo();
            row[6] = encl.getMemberCount();
            row[12] = encl.getServiceProfile();
            row[13] = encl.getServerBlade();
            if (encl.isVmHost()) {
                row[7] = encl.getNumVms();
                row[8] = encl.getCluster() == null ? " " : encl.getCluster();
                row[9] = encl.getMultiPath();
                row[10] = encl.getCpuCount();
                row[11] = MibVariableFormat.convertMemoryUnit(encl.getMemorySize(), this._formatter);
            }
            deviceType.setLength(0);
            serNum.setLength(0);
            drVersion.setLength(0);
            otherInfo.setLength(0);
            if (encl.isTarget()) {
                ScsiTarget scsiTarget = encl.getScsiTarget();
                if (scsiTarget != null) {
                    if (scsiTarget.getDevTypeName() != null) {
                        deviceType.append(scsiTarget.getDevTypeName().trim());
                    }
                    if (scsiTarget.getOtherInfo() != null) {
                        otherInfo.append(scsiTarget.getOtherInfo().trim());
                    }
                    deviceType.append(SEMI_COLON_STRING);
                    serNum.append(SEMI_COLON_STRING);
                    drVersion.append(SEMI_COLON_STRING);
                    otherInfo.append(SEMI_COLON_STRING);
                } else {
                    vendorId.append(encl.getVendor());
                    deviceType.append(encl.getTypeName());
                }
            } else {
                deviceType.append(encl.getTypeName());
                vendorId.append(encl.getVendor());
            }
            while (deviceType.length() > 1 && deviceType.charAt(deviceType.length() - 2) == ';') {
                deviceType.setLength(deviceType.length() - 2);
            }
            while (serNum.length() > 1 && serNum.charAt(serNum.length() - 2) == ';') {
                serNum.setLength(serNum.length() - 2);
            }
            while (drVersion.length() > 1 && drVersion.charAt(drVersion.length() - 2) == ';') {
                drVersion.setLength(drVersion.length() - 2);
            }
            while (otherInfo.length() > 1 && otherInfo.charAt(otherInfo.length() - 2) == ';') {
                otherInfo.setLength(otherInfo.length() - 2);
            }
            row[4] = deviceType == null ? EMPTY_STRING : deviceType.toString();
            row[16] = serNum.length() == 0 ? EMPTY_STRING : serNum.toString();
            row[19] = drVersion.length() == 0 ? EMPTY_STRING : drVersion.toString();
            row[14] = otherInfo.length() == 0 ? EMPTY_STRING : otherInfo.toString();
            row[labels.length + 1] = encl;
            this._responseData.addElement(row);
        }
        return this._responseData;
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        if (!this._selectAction) {
            return;
        }
        this.mapSelectDevice(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(int sortColumn, boolean ascending, ListSelectionModel selection) {
        try {
            this._selectAction = false;
            super.sort(sortColumn, ascending, selection);
        }
        catch (Throwable th) {
        }
        finally {
            this._selectAction = true;
        }
    }

    @Override
    protected boolean RefreshBtnOn() {
        return true;
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[this.getLabels().length + 1];
    }

    @Override
    public void resetChanges(boolean undo) {
        super.resetChanges(undo);
        try {
            this.setData(this.getTableVars());
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    @Override
    public boolean applyChanges() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return true;
        }
        if (cells.size() > 0) {
            int i;
            int row = 0;
            int prevRow = -1;
            for (int i2 = 0; i2 < cells.size(); ++i2) {
                Cell c = (Cell)cells.elementAt(i2);
                if (c._row == prevRow) continue;
                ++row;
                prevRow = c._row;
            }
            Enclosure[] enclosures = new Enclosure[row];
            String[] encNames = new String[row];
            String[] encIpAddr = new String[row];
            String[] dmPath = new String[row];
            int[] type = new int[row];
            String[] vendor = new String[row];
            String[] model = new String[row];
            String[] version = new String[row];
            String[] osInfo = new String[row];
            Fabric fabric = this._mgmtDomain != null ? this._mgmtDomain.getFabric() : ClientController.getInstance().getFabric();
            prevRow = -1;
            row = -1;
            ArrayList<EnclosureRow> deletedList = new ArrayList<EnclosureRow>();
            Array data = this.getData();
            EnclosureRow prevDeleted = null;
            for (i = 0; i < cells.size(); ++i) {
                Object[] rowData;
                Cell c = (Cell)cells.elementAt(i);
                String nm = (String)this.getValueAt(c._row, 0);
                if (nm != null) {
                    nm = nm.trim();
                }
                if (nm == null || nm.length() == 0) {
                    rowData = (Object[])data.elementAt(c._row);
                    prevDeleted = new EnclosureRow((Enclosure)this.getDevicebject(rowData), c._row);
                    deletedList.add(prevDeleted);
                    continue;
                }
                if (prevDeleted != null && c._row == prevDeleted._row || c._row == prevRow) continue;
                prevRow = c._row;
                String ip = (String)this.getValueAt(c._row, 1);
                if (ip != null && ip.length() != 0) {
                    byte[] ipaddress = SnmpIpAddress.parse(ip);
                }
                encNames[++row] = nm;
                encIpAddr[row] = ip;
                dmPath[row] = (String)this.getValueAt(c._row, 3);
                rowData = (Object[])data.elementAt(c._row);
                enclosures[row] = (Enclosure)this.getDevicebject(rowData);
                String tp = (String)this.getValueAt(c._row, 4);
                type[row] = Enclosure.getDeviceType(enclosures[row], tp);
                vendor[row] = (String)this.getValueAt(c._row, 15);
                model[row] = (String)this.getValueAt(c._row, 17);
                version[row] = (String)this.getValueAt(c._row, 18);
                osInfo[row] = (String)this.getValueAt(c._row, 5);
            }
            if (deletedList.size() > 0) {
                Enclosure[] encls = new Enclosure[deletedList.size()];
                for (int i3 = 0; i3 < deletedList.size(); ++i3) {
                    encls[i3] = ((EnclosureRow)deletedList.get((int)i3))._enclosure;
                }
                ClientController.getInstance().removeEnclosures(encls);
            }
            if (row >= 0) {
                ClientController.getInstance().updateEnclosure(fabric, enclosures, encNames, encIpAddr, type, dmPath, vendor, model, version, osInfo);
            }
            for (i = deletedList.size() - 1; i >= 0; --i) {
                EnclosureRow er = (EnclosureRow)deletedList.get(i);
                this.removeRow(er._row);
                this.fireTableRowsDeleted(er._row, er._row);
            }
            if (row >= 0 || deletedList.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public static SmFilter createFilter(SnmpPeer peer, int[][] indeces, int numIndeces) {
        int[][] index = new int[numIndeces][1];
        for (int j = 0; j < numIndeces; ++j) {
            index[j][0] = indeces[j][0];
        }
        return new SmFilter(peer, index);
    }

    class TableMouseListener
    extends MouseInputAdapter {
        TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            SnmpKTable t = (SnmpKTable)e.getSource();
            if (t.getModel() instanceof SmEnclosureTableModel) {
                SmEnclosureTableModel tm = (SmEnclosureTableModel)t.getModel();
                int row = t.rowAtPoint(p);
                int col = t.columnAtPoint(p);
                int ncol = t.convertColumnIndexToModel(col);
                boolean isHttp = (Boolean)tm.getValueAt(row, 2);
                if (ncol == 3) {
                    if (!isHttp && tm.isCellEditable(row, ncol)) {
                        String s;
                        FileNameCellRenderer renderer = (FileNameCellRenderer)t.getCellRenderer(row, col);
                        Rectangle r = t.getCellRect(row, col, true);
                        if (r.getX() + r.getWidth() - p.getX() < (double)renderer.getButtonWidth() && (s = Util.getFileName(BrowserFrame.getInstance(), "*.*", 0)) != null && s.length() > 0) {
                            tm.setValueAt(s, row, 3);
                        }
                    }
                } else if (ncol == 2) {
                    if (isHttp) {
                        tm.setValueAt("http://", row, 3);
                    } else {
                        String http = (String)tm.getValueAt(row, 3);
                        if (http != null && http.equals("http://")) {
                            tm.setValueAt(SmEnclosureTableModel.EMPTY_STRING, row, 3);
                        }
                    }
                }
            }
        }
    }

    class EnclosureRow {
        Enclosure _enclosure;
        int _row;

        EnclosureRow(Enclosure encl, int row) {
            this._enclosure = encl;
            this._row = row;
        }
    }
}

