/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.map.PlatformNode;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;

public class SmEnfZoneTableModel
extends SmTableModel
implements ActionListener {
    static final String[] LABELS = new String[]{"VSAN Id", "Zone", "Type", "Switch Interface", "Name", "WWN", "FcId", "LUNs", "Status"};
    private String _zoneName;
    private EndPort[] _endPorts;
    private MgmtDomainIf _mgmtDomain;
    static final int VSANID = 0;
    static final int ZONE = 1;
    static final int TYPE = 2;
    static final int SWITCHPORT = 3;
    static final int PWWN = 5;
    static final int NAME = 4;
    static final int FCID = 6;
    static final int LUN = 7;
    static final int INFO = 8;
    static final int ROWOBJ = 9;
    public static final String[] Wizard_BUTTON = new String[]{"icons/AAA_rule.gif", "Wizard...", "editZones"};

    public SmEnfZoneTableModel(String zone, MgmtDomainIf mgmtDomain, EndPort[] endPorts) {
        this._zoneName = zone;
        DataView dataView = BrowserFrame.getDataView();
        dataView.insertButton(3, new String[][]{Wizard_BUTTON}, new ActionListener[]{this});
        this._endPorts = endPorts;
        this._mgmtDomain = mgmtDomain;
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._prefixes = prefixes;
        this.setHeaders(LABELS);
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(SnmpPeer[] peers) throws SnmpException {
        return this.getZoneVars();
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        return this.getZoneVars();
    }

    public Array getZoneVars() throws SnmpException {
        int j;
        this._responseData = new Array();
        if (this._mgmtDomain == null) {
            return this._responseData;
        }
        EnforcedZone[] zones = null;
        if (this._mgmtDomain.isVsan()) {
            zones = ((Vsan)this._mgmtDomain).getEnforcedZones();
        } else if (this._mgmtDomain.isZone()) {
            zones = new EnforcedZone[]{(EnforcedZone)this._mgmtDomain};
        } else {
            Fabric[] fs = null;
            fs = this._mgmtDomain.isSan() ? ((San)this._mgmtDomain).getFabrics() : new Fabric[]{(Fabric)this._mgmtDomain};
            ArrayList<EnforcedZone> ez = new ArrayList<EnforcedZone>();
            for (int i = 0; i < fs.length; ++i) {
                Vsan[] vs = fs[i].getVsans();
                if (vs == null || vs.length == 0) continue;
                for (j = 0; j < vs.length; ++j) {
                    ez = vs[j].getEnforcedZones(ez);
                }
            }
            zones = new EnforcedZone[ez.size()];
            zones = ez.toArray(zones);
        }
        try {
            for (int i = 0; i < zones.length; ++i) {
                EnforcedZone zn = zones[i];
                if (this._zoneName != null && !this._zoneName.equals(zn.toString())) continue;
                String zoneName = zn.getName();
                Array mem = zn.getMembers();
                int maxj = mem.size();
                for (j = 0; j < maxj; ++j) {
                    EnforcedZoneMember zmem = (EnforcedZoneMember)mem.elementAt(j);
                    if (zmem.getType() == 4 || zmem.getType() == 6 || zmem.getType() == 7 || zmem.getType() == 2 || zmem.getType() == 8 || zmem.getType() == 9) {
                        ArrayList ports = zmem.getAttachedEndPorts();
                        if (ports != null && ports.size() > 0) {
                            for (int k = 0; k < ports.size(); ++k) {
                                this.addRow((EndPort)ports.get(k), zoneName, zmem, zn.getVsan());
                            }
                            continue;
                        }
                        this.addRow(null, zoneName, zmem, zn.getVsan());
                        continue;
                    }
                    this.addRow(zmem.getEndPort(zn.getFabric()), zoneName, zmem, zn.getVsan());
                }
            }
        }
        catch (Exception ex) {
            throw new SnmpException(ex.getMessage());
        }
        return this._responseData;
    }

    private void addRow(EndPort p, String zoneName, EnforcedZoneMember zmem, Vsan vsan) {
        if (this._endPorts != null) {
            boolean showport = false;
            for (int e = 0; e < this._endPorts.length; ++e) {
                if (p == null || !p.equals(this._endPorts[e])) continue;
                showport = true;
                break;
            }
            if (!showport) {
                return;
            }
        }
        Object[] row = new Object[10];
        row[1] = zoneName;
        row[4] = p != null ? p : zmem.getName(p, vsan);
        Wwn pWWN = zmem.getPortWWN(p);
        row[5] = pWWN != null ? SnmpString.toHexString(zmem.getPortWWN(p).getValue()) : "";
        row[0] = vsan != null ? Integer.toString(vsan.getId()) : null;
        row[6] = zmem.getFcid(p);
        row[3] = zmem.getSwitchPort(p);
        row[2] = zmem.getConType();
        row[7] = zmem.getLun();
        row[8] = EnforcedZoneMember.getInfo(p, vsan.getId(), zmem.getType(), vsan.getPrincipalSwitchWwn());
        row[9] = p;
        this._responseData.addElement(row);
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        this.mapSelectDevice(table);
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[4];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIControls.getInstance().actionPerformed(e);
    }

    @Override
    public JMenuItem[] getMapMenuItems() {
        return PlatformNode.getMenuItemsForZone(null);
    }
}

