/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmFeatureControlTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmFeatureControlSDVTableModel
extends SmFeatureControlTableModel {
    final int[] _cfcFeatureCtrlActionOid = MibNode.get("cfcFeatureCtrlAction").getOid();

    public SmFeatureControlSDVTableModel(int[][] ownerIndices) {
        super(ownerIndices);
    }

    @Override
    public boolean applyChanges() throws Exception {
        Array cells = super.getChanged();
        Array data = this.getData();
        int nRow = data.size();
        int nDisableAction = 0;
        for (int i = 0; i < cells.size(); ++i) {
            Switch sw;
            SnmpVar var;
            int action;
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            int[] index = this.getCellSetIndex(cell);
            SnmpOID oid = this.getCellOid(cell, index, node);
            if (!oid.startsWith(this._cfcFeatureCtrlActionOid) || (action = ((SnmpInt)(var = this.getChangedCell(cell._row, cell._col, this.getMibNodes(sw = ClientController.findFabricSwitchByIpAddress(node.getAddress()))))).getValue()) != 3) continue;
            ++nDisableAction;
        }
        if (nDisableAction != 1 && nDisableAction == nRow) {
            throw new Exception("SDV does not support disable all " + nRow + " switches simultaneously in the fabric. Please select to disable only " + (nRow - 1) + " switches in the fabric.");
        }
        return super.applyChanges();
    }
}

