/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SmFlowTableModel
extends SmTableModel
implements ActionListener {
    static final int TYPE = 2;
    static final int VSANID = 3;
    static final int SRC = 4;
    static final int DST = 5;
    static final int MASK = 6;
    static final int FRAMES_VB = 5;
    static final int BYTES_VB = 6;
    static final int TIMESTAMP_VB = 7;
    public static final String[] Wizard_BUTTON = new String[]{"icons/RouteFlow16.gif", "Wizard...", "flowConfig"};

    public SmFlowTableModel() {
        DataView dataView = BrowserFrame.getDataView();
        dataView.insertButton(3, new String[][]{Wizard_BUTTON}, new ActionListener[]{this});
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        String type = row[2].toString();
        if (type.indexOf("dest") != -1) {
            String mask = row[6].toString();
            int vsanId = Integer.parseInt(row[3].toString());
            int srcId = Integer.parseInt(row[4].toString().substring(2), 16);
            int dstId = Integer.parseInt(row[5].toString().substring(2), 16);
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            Fabric fb = sw.getFabric();
            if (mask.equals("0xffffff")) {
                EndPort sp = fb.findEndPortByVsanFcId(vsanId, srcId);
                EndPort dp = fb.findEndPortByVsanFcId(vsanId, dstId);
                if (sp != null) {
                    row[4] = sp + "(" + row[4] + ")";
                }
                if (dp != null) {
                    row[5] = dp + "(" + row[5] + ")";
                }
            } else if (mask.equals("0xff0000")) {
                Switch ssw = fb.findSwitchByVsanDomainId(vsanId, srcId >> 16);
                Switch dsw = fb.findSwitchByVsanDomainId(vsanId, dstId >> 16);
                if (ssw != null) {
                    row[4] = ssw;
                }
                if (dsw != null) {
                    row[5] = dsw;
                }
            }
        }
        row[5] = row[5].toString();
        row[4] = row[4].toString();
        return row;
    }

    @Override
    protected boolean isSkip(SnmpPeer peer, int[] req, SnmpVarBind firstVb, int[] index, VarBindList vbl, int reqId) {
        short id;
        int vsanId = vbl.intValue(3 - this._offset);
        MgmtDomainIf domain = ClientController.getInstance().getSelectedDomain();
        return domain instanceof Vsan && vsanId != (id = ((Vsan)domain).getId());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIControls.getInstance().actionPerformed(e);
    }
}

