/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.TextOutputDialog;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.table.SeverityRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.EnclosureChangeDetailHolder;
import com.cisco.dcbu.sm.client.dialogs.SmCFSControlTableModel;
import com.cisco.dcbu.sm.client.dialogs.SwitchPortComparer;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmCfsUtil;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.renderers.RawWWNRenderer;
import com.cisco.dcbu.sm.client.map.PlatformNode;
import com.cisco.dcbu.sm.client.map.actions.ShowPathAction;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SmHostTableModel
extends SmTableModel
implements ActionListener {
    public static final String STRING_NAME = "Enclosure Name";
    public static final String STRING_PORTWWN = "Port WWN";
    public static final String STRING_DEVICE_ALIAS = "Device Alias";
    static final String[] LABELS = new String[]{"Fabric", "VSAN Id", "Enclosure Name", "Alias", "Port WWN", "FcId", "Switch Interface", "Link Status", "Vendor", "Serial Number", "Model", "Firmware Ver", "Driver Ver", "Information", "Region Id"};
    static final String[] STORAGE_LABELS = new String[]{"Type", "VendorId", "ProductId", "RevLevel"};
    static final String[] HOST_LABELS = new String[]{"OsDevName", "HostName"};
    public static final int TYPE_MIX = -1;
    public static final int TYPE_HOST = 0;
    public static final int TYPE_STORAGE = 1;
    public static final int FAB_NAME = 0;
    public static final int VSANID = 1;
    public static final int NAME = 2;
    public static final int ALIAS = 3;
    public static final int PORTWWN = 4;
    public static final int FCID = 5;
    public static final int ATTACH = 6;
    public static final int LINKSTATUS = 7;
    public static final int VENDOR_ID = 8;
    public static final int SERIAL_NUMBER = 9;
    public static final int MODEL = 10;
    public static final int FIRMWARE_VER = 11;
    public static final int DRIVER_VER = 12;
    public static final int SYMNAME = 13;
    public static final int REGION_ID = 14;
    public static boolean _PromptAliasEnclosureInfo = true;
    int _endPortCol;
    boolean _needTarget;
    ArrayList _endPorts = null;
    boolean _showScsiTarget;
    boolean _isFdmi;
    MgmtDomainIf _mgmtDomain;
    HashMap<String, HashSet<AliasRegion>> _fabricRegionsMap = new HashMap();
    ArrayList<String> _changedFabricsList = new ArrayList();
    ArrayList<SnmpPeer> _failedPeers = new ArrayList();
    short _cfsFabricCount = 0;
    boolean _isAliasEditable;
    boolean _bAliasChanged;
    JButton[] _customeBtns;
    JCheckBox _cbNoDisp;
    JButton _alias2EnclosureBtn;
    JButton _zone2AliasBtn;
    JButton _restrictedTopologyBtn;
    public static Logger _Logger = Logger.getLogger(SmHostTableModel.class);
    private static final int[] _cfdaConfigRowStatusOid = MibNode.get("cfdaConfigRowStatus").getOid();
    private static final int[] _cfdaConfigDeviceTypeOid = MibNode.get("cfdaConfigDeviceType").getOid();
    private static final int[] _cfdaConfigDeviceIdOid = MibNode.get("cfdaConfigDeviceId").getOid();
    private static final int ALIAS_DEV_TYPE_PWWN = 1;
    ArrayList _changedAliasList = new ArrayList();
    static final String ALIAS_2_ENCLOSURE_BTN_TEXT = "Alias->Enclosure...";
    static final String ALIAS_2_ENCLOSURE_BTN_TEXT_NO_DISP = "Alias->Enclosure";
    static final String ZONE_2_ALIAS_BTN_TEXT = "Zone->Alias...";
    static final String ZONE_2_ALIAS_BTN_TEXT_NO_DISP = "Zone->Alias";
    static final String RESTRICTED_TOPOLOGY_BTN_TEXT = "Show Path";
    private static final String[][] ALIAS_ENCLOSURE_BUTTON = new String[][]{{null, "Alias->Enclosure...", "T"}};
    private static final String[][] ZONE_ALIAS_BUTTON = new String[][]{{null, "Zone->Alias...", "Z"}};
    private static final String[][] RESTRICTED_TOPOLOGY_BUTTON = new String[][]{{null, "Show Path", "FROM_ENDPORT_TABLE"}};
    private static final String ALISBTN_TOOLTIP = "<html><p>Sets the Enclosure Name of selected rows using the selected regular expression pattern list.</p><p>You can enable the pattern list editor from \"File->Preferences...\" dialog window</p></html>";
    private static final String ZONEBTN_TOOLTIP = "<html><p>Sets the Alias of the selected rows from zone names using the selected regular expression pattern list.</p><p>You can enable the pattern list editor from \"File->Preferences...\" dialog window</p></html>";
    private static final String FC_ALIAS = "FC Alias";
    private static final String DEVICE_ALIAS = "Device Alias";
    private static final String BOTH_ALIAS = "Alias";
    private boolean _isFcAlias;
    private boolean _isSan;
    private boolean _selectAction = true;
    Alias2EnclosureDlg _alias2EnclosureDlg = null;
    Zone2AliasDlg _zone2AliasDlg = null;
    private static TextOutputDialog _logDialog;
    RawWWNRenderer _rawWwnRenderer;

    private SmHostTableModel(boolean showZoneAliasButton, boolean showRestrictedTopologyButton) {
        DataView dataView = BrowserFrame.getDataView();
        Fabric fabric = ClientController.getInstance().getFabric();
        if (fabric != null) {
            this._isFcAlias = fabric.isFcAlias();
        }
        if (showZoneAliasButton && showRestrictedTopologyButton) {
            String[][] all_buttons = new String[3][4];
            all_buttons[0] = ALIAS_ENCLOSURE_BUTTON[0];
            all_buttons[1] = ZONE_ALIAS_BUTTON[0];
            all_buttons[2] = RESTRICTED_TOPOLOGY_BUTTON[0];
            JButton[] buttons = dataView.insertButtons(0, all_buttons, new ActionListener[]{this, this, this});
            this._alias2EnclosureBtn = buttons[0];
            this._zone2AliasBtn = buttons[1];
            this._restrictedTopologyBtn = buttons[2];
            this._restrictedTopologyBtn.setActionCommand(RESTRICTED_TOPOLOGY_BUTTON[0][2]);
        } else if (showZoneAliasButton) {
            String[][] all_buttons = new String[2][4];
            all_buttons[0] = ALIAS_ENCLOSURE_BUTTON[0];
            all_buttons[1] = ZONE_ALIAS_BUTTON[0];
            JButton[] buttons = dataView.insertButtons(0, all_buttons, new ActionListener[]{this, this});
            this._alias2EnclosureBtn = buttons[0];
            this._zone2AliasBtn = buttons[1];
        } else if (showRestrictedTopologyButton) {
            String[][] all_buttons = new String[2][4];
            all_buttons[0] = ALIAS_ENCLOSURE_BUTTON[0];
            all_buttons[1] = RESTRICTED_TOPOLOGY_BUTTON[0];
            JButton[] buttons = dataView.insertButtons(0, all_buttons, new ActionListener[]{this, this});
            this._alias2EnclosureBtn = buttons[0];
            this._restrictedTopologyBtn = buttons[1];
            this._restrictedTopologyBtn.setActionCommand(RESTRICTED_TOPOLOGY_BUTTON[0][2]);
        } else {
            this._alias2EnclosureBtn = dataView.insertButton(0, ALIAS_ENCLOSURE_BUTTON, new ActionListener[]{this});
        }
        this.initAliasBtn();
        this.initZoneBtn();
        this.setNeedQuailPeer(true);
    }

    public SmHostTableModel(MgmtDomainIf mgmtDomain, int type) {
        this(type == 0, true);
        this._mgmtDomain = mgmtDomain;
        this._needTarget = type == 1;
        this.checkMgmtDomain();
    }

    public SmHostTableModel(ArrayList endPorts) {
        this(false, true);
        this._endPorts = endPorts;
        this.checkMgmtDomain();
    }

    protected void checkMgmtDomain() {
        if (this._mgmtDomain == null) {
            this._mgmtDomain = ClientController.getInstance().getSelectedDomain();
        }
        if (this._mgmtDomain != null) {
            if (this._mgmtDomain.isDataCenter()) {
                this._mgmtDomain = San.getInstance();
            }
            this._isSan = this._mgmtDomain.isSan();
        }
    }

    @Override
    public JMenuItem[] getMapMenuItems() {
        return PlatformNode.getMenuItemsForTable(null);
    }

    protected void initAliasBtn() {
        if (SmHostTableModel.getPromptAliasEnclosureFlag()) {
            this._alias2EnclosureBtn.setText(ALIAS_2_ENCLOSURE_BTN_TEXT);
            this._alias2EnclosureBtn.setToolTipText(null);
        } else {
            this._alias2EnclosureBtn.setText(ALIAS_2_ENCLOSURE_BTN_TEXT_NO_DISP);
            this._alias2EnclosureBtn.setToolTipText(ALISBTN_TOOLTIP);
        }
    }

    protected void initZoneBtn() {
        if (this._zone2AliasBtn != null) {
            this._zone2AliasBtn.setText(ZONE_2_ALIAS_BTN_TEXT);
            this._zone2AliasBtn.setToolTipText(null);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            if (ALIAS_ENCLOSURE_BUTTON[0][1].startsWith(e.getActionCommand()) || e.getActionCommand().equals(ALIAS_ENCLOSURE_BUTTON[0][2])) {
                this.Alias2Enclosure();
            } else if (ZONE_ALIAS_BUTTON[0][1].startsWith(e.getActionCommand()) || e.getActionCommand().equals(ZONE_ALIAS_BUTTON[0][2])) {
                this.zone2Alias();
            } else if (RESTRICTED_TOPOLOGY_BUTTON[0][1].startsWith(e.getActionCommand()) || e.getActionCommand().equals(RESTRICTED_TOPOLOGY_BUTTON[0][2])) {
                try {
                    ShowPathAction.getInstance().actionPerformed(e);
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
                }
            }
        }
    }

    void Alias2Enclosure() {
        try {
            String aliasRE = ClientController.getInstance().assertSession().getServerProperty("fabric.aliasRE");
            if (SmHostTableModel.getPromptAliasEnclosureFlag()) {
                if (this._alias2EnclosureDlg == null) {
                    this._alias2EnclosureDlg = new Alias2EnclosureDlg(aliasRE);
                } else {
                    this._alias2EnclosureDlg.reloadData();
                    this._alias2EnclosureDlg.refreshAliasREDisplay(aliasRE);
                }
                this._alias2EnclosureDlg.setVisible(true);
            } else {
                this.applyChangesToSelectedRowsNoDialog(aliasRE);
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
        }
    }

    void zone2Alias() {
        try {
            int[] sels = BrowserFrame.getDataView()._table.getSelectedRows();
            if (sels.length == 0) {
                Util.errorMessage((Component)BrowserFrame.getDataView(), new Exception("Please select rows to alias."));
                return;
            }
            String zoneRE = ClientController.getInstance().assertSession().getServerProperty("fabric.zoneRE");
            if (zoneRE == null) {
                zoneRE = ".*[_-]VSAN\\d+[_-](.*)";
            }
            if (this._zone2AliasDlg == null) {
                this._zone2AliasDlg = new Zone2AliasDlg(zoneRE);
            } else {
                this._zone2AliasDlg.reloadData();
                this._zone2AliasDlg.refreshZoneREDisplay(zoneRE);
            }
            this._zone2AliasDlg.setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
        }
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row >= this.getRowCount() || col >= this.getColumnCount()) {
            return false;
        }
        SnmpPeer peer = this.getRowPeer(row);
        if (peer != null || col == 2) {
            return super.isCellEditable(row, col);
        }
        return false;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._prefixes = prefixes;
        Fabric[] fabrics = new Fabric[1];
        if (this._isSan) {
            fabrics = ClientController.getInstance().getFabrics();
        } else {
            Fabric f = ClientController.getInstance().getFabric();
            if (f != null) {
                fabrics[0] = f;
            } else {
                fabrics = null;
            }
        }
        if (fabrics != null && fabrics.length > 0) {
            for (int i = 0; i < fabrics.length; ++i) {
                Fabric f = fabrics[i];
                this._fabricRegionsMap.put(f.getName(), new HashSet());
            }
        }
        if (fabrics == null && SnmpSession.isTrace()) {
            DefaultLogger._DefLogger.debug((Object)"Unable to find any fabric");
        }
        if (this._customeBtns != null) {
            this._customeBtns[1].setEnabled(fabrics != null);
        }
        String[] headers = new String[LABELS.length];
        System.arraycopy(LABELS, 0, headers, 0, LABELS.length);
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        boolean isSanSelected = mgmtDomain instanceof San;
        headers[3] = isSanSelected ? BOTH_ALIAS : (this._isFcAlias ? FC_ALIAS : "Device Alias");
        boolean[] editable = new boolean[headers.length];
        this._isEditable = true;
        editable[2] = true;
        editable[3] = this._isAliasEditable = !this._isFcAlias && fabrics != null;
        this._endPortCol = headers.length + 1;
        this.setHeaders(headers);
        this.setEditable(editable);
        boolean[] emptyColumnsHidable = new boolean[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            emptyColumnsHidable[i] = true;
        }
        emptyColumnsHidable[3] = false;
        this.setEmptyColumnsHidable(emptyColumnsHidable);
    }

    @Override
    protected void setSpecialAttr() {
        SnmpKTable table = BrowserFrame.getTable();
        if (this._rawWwnRenderer == null) {
            this._rawWwnRenderer = new RawWWNRenderer();
        }
        table.getColumnModel().getColumn(4).setCellRenderer(this._rawWwnRenderer);
        table.getColumnModel().getColumn(7).setCellRenderer(new SeverityRenderer("ok", "-"));
        if (!this._isAliasEditable) {
            BorderCellRenderer renderer = new BorderCellRenderer();
            renderer.setToolTipText("You cannot edit aliases if there is no manageable seed switch, or you are using FC aliases.");
            table.getColumnModel().getColumn(3).setCellRenderer(renderer);
        }
    }

    @Override
    protected SnmpPeer getRowPeer(int row) {
        Object[] values = (Object[])this.getData().elementAt(row);
        Switch sw = this.getAliasSeed(values);
        EndPort ep = (EndPort)values[this._endPortCol];
        if (sw == null) {
            this.storeFabricRegion(ep.getFabric(), (Integer)values[14]);
        }
        return sw == null ? null : sw.getPeer();
    }

    protected Switch getAliasSeed(Object[] values) {
        EndPort ep = (EndPort)values[this._endPortCol];
        Fabric fabric = ep.getFabric();
        Integer id = (Integer)values[14];
        return this.getAliasRegionSeed(fabric.getName(), id);
    }

    protected Switch getAliasRegionSeed(String fabric, Integer regionId) {
        HashSet<AliasRegion> regions = this._fabricRegionsMap.get(fabric);
        if (regions == null) {
            return null;
        }
        for (AliasRegion region : regions) {
            if (region.getRegionId() != regionId.intValue()) continue;
            return region.getSeedSwitch();
        }
        return null;
    }

    protected void storeFabricRegion(Fabric fabric, Integer regionId) {
        WwnKey wwnKey = fabric.getRegionAliasSeed(regionId);
        Switch sw = fabric.findSwitchByPK(wwnKey);
        AliasRegion region = new AliasRegion(regionId, sw);
        HashSet<AliasRegion> regions = this._fabricRegionsMap.get(fabric.getName());
        regions.add(region);
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        if (this._fabricRegionsMap.size() == 0) {
            return null;
        }
        return super.buildSendPdus();
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        return this.getTableVars();
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        return this.getTableVars();
    }

    Array getTableVars() throws SnmpException {
        this._responseData = new Array();
        ArrayList<EndPort> endPorts = this._endPorts != null ? this._endPorts : this._mgmtDomain.getEndPorts(null, this._needTarget);
        Enclosure encl = null;
        Collections.sort(endPorts);
        for (int i = 0; i < endPorts.size(); ++i) {
            EndPort ep = endPorts.get(i);
            encl = ep == null ? null : ep.getEnclosure();
            Object[] row = new Object[this._endPortCol + 1];
            Object object = row[1] = ep != null ? ep.getVsansAsString() : "";
            if (ep != null && ep.getEnclosure() != null) {
                row[2] = ep.getEnclosure().getEnclosureName();
                row[8] = WwnDictionary.getWwnVendor(ep.getPortWwn().getValue());
            }
            if (row[2] == null) {
                row[2] = "";
            }
            if (row[8] == null) {
                row[8] = "";
            }
            row[3] = ep.getAlias();
            if (row[3] == null) {
                row[3] = "";
            }
            row[4] = ep.getPortWwn();
            row[5] = ep.getFcIdAsString();
            row[6] = ep.getSwitch().getName() + " " + ep.getIfIndexName();
            row[7] = ep.getStatus();
            Switch swEdge = ep.getSwitch();
            Switch swCore = null;
            if (swEdge.isNpvEnabled()) {
                Array<NpvLink> links = swEdge.getFabric().getNpvLinks(swEdge, false);
                for (int iL = 0; iL < links.size(); ++iL) {
                    NpvLink link = links.elementAt(iL);
                    if (link.getCoreSwitch().equals(swEdge)) continue;
                    swCore = link.getCoreSwitch();
                    break;
                }
                row[14] = swCore != null ? new Integer(swCore.getCfsRegionId("device-alias")) : new Integer(ep.getSwitch().getCfsRegionId("device-alias"));
            } else {
                row[14] = new Integer(ep.getSwitch().getCfsRegionId("device-alias"));
            }
            Hba hbas = ep.getHBA();
            if (hbas != null) {
                row[9] = hbas.getSerialNumber();
                if (hbas.getModel() != null || hbas.getModelDescription() != null) {
                    row[10] = hbas.getModelDescription() != null ? hbas.getModelDescription().trim() : hbas.getModel();
                }
                row[11] = hbas.getFirmwareVersion();
                row[12] = hbas.getDriverVersion();
            }
            row[0] = ep.getFabric().getName();
            String symName = ep.getSymNodeName();
            if (symName != null && symName.length() > 0) {
                row[13] = ep.isISCSI() && ep.getNodeIpAddress() != null ? ep.getNodeIpAddress() : symName;
            }
            row[this._endPortCol] = ep;
            this._responseData.addElement(row);
        }
        return this._responseData;
    }

    public static ArrayList getEnclosures(MgmtDomainIf mgmtDomain, ArrayList endPorts, ArrayList enclosures, boolean needTarget) {
        Enclosure[] encls;
        int i;
        if (enclosures == null) {
            enclosures = new HashedArrayList<Enclosure>();
        }
        boolean ignoreTarget = true;
        if (endPorts == null) {
            endPorts = mgmtDomain.getEndPorts(null, needTarget);
            ignoreTarget = false;
        }
        Enclosure encl = null;
        if (endPorts != null && endPorts.size() > 0) {
            for (i = 0; i < endPorts.size(); ++i) {
                EndPort ep = endPorts.get(i);
                if (!ignoreTarget && !(needTarget ? ep.isTarget() : !ep.isTarget()) || (encl = ep.getEnclosure()) == null || ((ArrayList)enclosures).contains(encl)) continue;
                ((ArrayList)enclosures).add(encl);
            }
        }
        if ((encls = San.getInstance().getEnclosures()) != null) {
            for (i = 0; i < encls.length; ++i) {
                encl = encls[i];
                if (!ignoreTarget && !(needTarget ? encl.isTarget() : !encl.isTarget()) || encl.getMemberCount() != 0 || ((ArrayList)enclosures).contains(encl)) continue;
                ((ArrayList)enclosures).add(encl);
            }
        }
        return enclosures;
    }

    public static void updateBtnTextByPreference() {
        SnmpKTable table = BrowserFrame.getTable();
        if (table == null) {
            return;
        }
        TableModel model = table.getModel();
        if (model != null && model instanceof SmHostTableModel) {
            ((SmHostTableModel)model).initAliasBtn();
            ((SmHostTableModel)model).initZoneBtn();
        }
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        if (!this._selectAction) {
            return;
        }
        this.mapSelectDevice(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(int sortColumn, boolean ascending, ListSelectionModel selection) {
        try {
            this._selectAction = false;
            super.sort(sortColumn, ascending, selection);
        }
        catch (Throwable th) {
        }
        finally {
            this._selectAction = true;
        }
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[this._endPortCol];
    }

    @Override
    protected boolean RefreshBtnOn() {
        return true;
    }

    @Override
    public void resetChanges(boolean undo) {
        super.resetChanges(undo);
        try {
            this.setData(this.getTableVars());
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    @Override
    public boolean applyChanges() throws Exception {
        boolean encChanged = this.processEnclosureChanges();
        this._bAliasChanged = false;
        this._changedAliasList.clear();
        this._failedPeers.clear();
        boolean bApplyChangeSup = super.applyChanges();
        if (bApplyChangeSup && this._bAliasChanged) {
            this.processAliasChange(this._changedAliasList);
        } else {
            this.processErrorMessages("");
        }
        return this._bAliasChanged ? bApplyChangeSup : encChanged;
    }

    @Override
    public boolean applyChanges(SnmpAggregrateIf applyChangesCallback) throws Exception {
        this._state = 5;
        HashMap pdus = this.buildSendPdus();
        if (pdus == null || pdus.size() == 0) {
            return false;
        }
        int successfulSets = this.applyChangesSet(pdus, applyChangesCallback);
        if (successfulSets == 0) {
            return false;
        }
        if (successfulSets < pdus.size()) {
            int failedSets = pdus.size() - successfulSets;
            this._setErrMsg.addElement("Failed on " + failedSets + " of " + pdus.size() + " device(s).");
            return true;
        }
        if (this.getRefreshChangedRow()) {
            this.getTableCols();
        }
        return true;
    }

    @Override
    public int applyChangesSet(HashMap pdus, SnmpAggregrateIf applyChangesCallback) throws Exception {
        int successfulSets = 0;
        Iterator peersIt = pdus.keySet().iterator();
        Iterator pdusIt = pdus.values().iterator();
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        SnmpPeer[] peerArray = new SnmpPeer[1];
        SnmpPDU[] pduArray = new SnmpPDU[1];
        while (pdusIt.hasNext()) {
            pduArray[0] = (SnmpPDU)pdusIt.next();
            if (pduArray[0].getVariables().size() == 0) continue;
            peerArray[0] = (SnmpPeer)peersIt.next();
            successfulSets += aggregrate.set(peerArray, pduArray, pdus.values().iterator(), applyChangesCallback, this._fragPduOnByte);
        }
        for (SnmpPDU pdu : pdus.values()) {
            if (pdu.getVariables().size() != 0) continue;
            ++successfulSets;
        }
        return successfulSets;
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        if (cell._col == 3) {
            Object[] values = (Object[])this.getData().elementAt(cell._row);
            Object[] oldVals = (Object[])values[this.getHeaders().length];
            String oldAlias = (String)oldVals[3];
            String newAlias = (String)values[3];
            String fabricName = (String)values[0];
            EndPort ep = (EndPort)values[this._endPortCol];
            Switch sw = this.getAliasSeed(values);
            if (oldAlias != null && oldAlias.length() != 0) {
                SnmpPDU p = new SnmpPDU(-93, new VarBindList());
                int[] oldIndex = new int[oldAlias.length() + 1];
                oldIndex[0] = oldAlias.length();
                for (int i = 1; i < oldIndex.length; ++i) {
                    oldIndex[i] = oldAlias.charAt(i - 1);
                }
                SnmpOID oid = new SnmpOID(_cfdaConfigRowStatusOid, oldIndex);
                p.addVar(oid, new SnmpInt(6));
                try {
                    sw.getPeer().set(p);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (newAlias.length() != 0) {
                int[] newIndex = new int[newAlias.length() + 1];
                newIndex[0] = newAlias.length();
                for (int i = 1; i < newIndex.length; ++i) {
                    newIndex[i] = newAlias.charAt(i - 1);
                }
                SnmpOID oid = new SnmpOID(_cfdaConfigRowStatusOid, newIndex);
                pdu.addVar(oid, new SnmpInt(4));
                oid = new SnmpOID(_cfdaConfigDeviceTypeOid, newIndex);
                pdu.addVar(oid, new SnmpInt(1));
                oid = new SnmpOID(_cfdaConfigDeviceIdOid, newIndex);
                Wwn pWwn = (Wwn)values[4];
                pdu.addVar(oid, new SnmpString(pWwn.getValue()));
            }
            this._changedAliasList.add(new ChangedModelObject(ep.getPK(), 1558, (Serializable)((Object)oldAlias), (Serializable)((Object)newAlias)));
            this._bAliasChanged = true;
            if (!this._changedFabricsList.contains(fabricName)) {
                this._changedFabricsList.add(fabricName);
            }
        }
        return null;
    }

    void processAliasChange(ArrayList<String> changedAliasList) throws Exception {
        StringBuffer message = new StringBuffer();
        for (int i = 0; i < this._changedFabricsList.size(); ++i) {
            String fabric = this._changedFabricsList.get(i);
            HashSet<AliasRegion> regions = this._fabricRegionsMap.get(fabric);
            Iterator<AliasRegion> it = regions.iterator();
            while (it.hasNext()) {
                Switch seed = it.next().getSeedSwitch();
                String ipAddress = NetUtil.getHostAddress(seed.getPeer().getAddress());
                String swName = seed.getPeer().getSysName();
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("fabric name: " + fabric + ", peer: " + ipAddress + ", sysName: " + swName));
                }
                if (!this._failedPeers.contains(seed.getPeer())) {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)("CFS worker starts on fabric: " + fabric + ", peer: " + ipAddress));
                    }
                    Thread worker = new Thread(new CFSWorker(fabric, seed.getPeer(), changedAliasList, message));
                    worker.start();
                    continue;
                }
                if (!_Logger.isTraceEnabled()) continue;
                _Logger.trace((Object)("CFS skipped fabric: " + fabric));
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (Throwable th) {
            // empty catch block
        }
        int count = 0;
        while (this._cfsFabricCount > 0 && count < 30) {
            try {
                Thread.sleep(1000L);
                count = (short)(count + 1);
            }
            catch (Throwable th) {}
        }
        this.processErrorMessages(message.toString());
    }

    @Override
    public int[] getCellSetIndex(Cell cell) {
        return null;
    }

    @Override
    protected SnmpOID getCellOid(Cell cell, int[] index, SnmpPeer node) {
        return null;
    }

    private boolean processEnclosureChanges() throws Exception {
        Array cells = this.getChanged();
        HashMap<Fabric, EnclosureChangeDetailHolder> enclosureChanges = new HashMap<Fabric, EnclosureChangeDetailHolder>();
        if (cells != null && cells.size() > 0) {
            int prevRow = -1;
            ArrayList reverseTargetCol = new ArrayList();
            for (int i = 0; i < cells.size(); ++i) {
                Cell c = (Cell)cells.elementAt(i);
                if (c._col != 2 || c._row == prevRow) continue;
                EndPort ep = null;
                Wwn wwn = (Wwn)this.getValueAt(c._row, 4);
                try {
                    int vsanIndex = (Integer)this.getValueAt(c._row, 1);
                    if (vsanIndex != 0) {
                        ep = ClientController.findFabricEndPortByWwn(wwn, vsanIndex);
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                if (ep == null) {
                    ep = ClientController.findFabricEndPortByWwn(wwn);
                }
                if (ep == null) {
                    DefaultLogger._DefLogger.error((Object)("Create/Modify enclosure: possibly removed: " + wwn));
                    continue;
                }
                prevRow = c._row;
                Fabric fabric = ep.getSwitch().getFabric();
                String encName = (String)this.getValueAt(c._row, 2);
                EnclosureChangeDetailHolder changeDetails = (EnclosureChangeDetailHolder)enclosureChanges.get(fabric);
                if (changeDetails == null) {
                    changeDetails = new EnclosureChangeDetailHolder(fabric, ep, encName);
                    enclosureChanges.put(fabric, changeDetails);
                } else {
                    changeDetails.addToList(ep, encName);
                }
                if (encName != null && encName.length() != 0 || ep.getEnclosure() == null) continue;
                this.setValueAt(ep.getEnclosure().getEnclosureName(), c._row, 2);
            }
            if (enclosureChanges.size() > 0) {
                for (EnclosureChangeDetailHolder nextChange : enclosureChanges.values()) {
                    ClientController.getInstance().updateEnclosure(nextChange.fab, nextChange.endPorts.toArray(new EndPort[nextChange.endPorts.size()]), nextChange.encNames.toArray(new String[nextChange.encNames.size()]));
                }
                int nReverseTargetCol = reverseTargetCol.size();
                if (nReverseTargetCol != 0) {
                    for (int i = nReverseTargetCol - 1; i >= 0; --i) {
                        this.getData().removeElementAt((Integer)reverseTargetCol.get(i));
                    }
                    this.fireTableRowsDeleted((Integer)reverseTargetCol.get(0), (Integer)reverseTargetCol.get(nReverseTargetCol - 1));
                }
                return true;
            }
        }
        return true;
    }

    public static SmFilter createFilter(SnmpPeer peer, int[][] indeces, int numIndeces) {
        int[][] index = new int[numIndeces][1];
        for (int j = 0; j < numIndeces; ++j) {
            index[j][0] = indeces[j][0];
        }
        return new SmFilter(peer, index);
    }

    public static SmFilter[] getEndDeviceInterfaces(boolean isHost) {
        return SmHostTableModel.getEndDeviceInterfaces(isHost ? 0 : 1);
    }

    public static SmFilter[] getEndDeviceInterfaces(int endDevtype) {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        ArrayList<EndPort> endPorts = null;
        if (mgmtDomain != null) {
            endPorts = endDevtype == 0 ? mgmtDomain.getEndPorts(endPorts, false) : (endDevtype == 1 ? mgmtDomain.getEndPorts(endPorts, true) : mgmtDomain.getEndPortsAsList());
        }
        Collections.sort(endPorts, new SwitchPortComparer());
        ArrayList<SmFilter> filters = new ArrayList<SmFilter>();
        SnmpPeer lastPeer = null;
        int maxIndeces = 128;
        int[][] indeces = new int[maxIndeces][1];
        int numIndeces = 0;
        int lastIfIndex = 0;
        if (endPorts == null) {
            return null;
        }
        for (int i = 0; i < endPorts.size(); ++i) {
            EndPort ep = endPorts.get(i);
            int ifIndex = ep.getIfIndex();
            if (IfIndexUtil.isFmIfIndex(ifIndex)) {
                DefaultLogger._DefLogger.debug((Object)("SmHostTableModel filter: skipping " + ifIndex));
                continue;
            }
            if (!ep.getSwitch().isMDS() || ep.getSwitch().getPeer() == null || !ep.isPresent() || ep.isFiconCup()) continue;
            if (ep.getSwitch().getPeer() != lastPeer) {
                if (lastPeer != null && numIndeces > 0) {
                    filters.add(SmHostTableModel.createFilter(lastPeer, indeces, numIndeces));
                }
                lastPeer = ep.getSwitch().getPeer();
                numIndeces = 0;
                lastIfIndex = 0;
            }
            if (lastIfIndex == ep.getIfIndex()) continue;
            lastIfIndex = ep.getIfIndex();
            if (numIndeces >= maxIndeces) {
                int[][] ifs = new int[maxIndeces *= 2][1];
                System.arraycopy(indeces, 0, ifs, 0, numIndeces);
                indeces = ifs;
            }
            indeces[numIndeces++][0] = lastIfIndex;
        }
        if (numIndeces > 0) {
            filters.add(SmHostTableModel.createFilter(lastPeer, indeces, numIndeces));
        }
        if (filters.size() > 0) {
            return filters.toArray(new SmFilter[filters.size()]);
        }
        return null;
    }

    public static void setPromptAliasEnclosureFlag(boolean value) {
        _PromptAliasEnclosureInfo = value;
    }

    public static boolean getPromptAliasEnclosureFlag() {
        return _PromptAliasEnclosureInfo;
    }

    protected void applyChangesToSelectedRowsNoDialog(String aliasRE) throws Exception {
        String toUpperStr = ClientController.getInstance().assertSession().getServerProperty("fabric.alias.toEnclosure.toUpper");
        boolean toUpper = true;
        if (toUpperStr != null) {
            toUpper = Boolean.parseBoolean(toUpperStr);
        }
        ArrayList<Pattern> patternList = SmHostTableModel.convertRE2Pattern(aliasRE, "aliasRE");
        DataView dataView = BrowserFrame.getDataView();
        if (dataView._tableModel instanceof SmHostTableModel) {
            int[] sels = dataView._table.getSelectedRows();
            Array data = this.getData();
            for (int i = 0; i < sels.length; ++i) {
                int row = sels[i];
                Object[] rowData = (Object[])data.elementAt(row);
                String alias = (String)rowData[3];
                if (alias == null || alias.equals("")) continue;
                String encname = GenUtil.regexMatch(patternList, alias, toUpper);
                this.setValueAt(encname, row, 2);
            }
        }
    }

    protected void applyZoneChangesToSelectedRowsNoDialog(String zoneRE) throws Exception {
        String toUpperStr = ClientController.getInstance().assertSession().getServerProperty("fabric.zone.toAlias.toUpper");
        boolean toUpper = false;
        if (toUpperStr != null) {
            toUpper = Boolean.parseBoolean(toUpperStr);
        }
        ArrayList<Pattern> patternList = SmHostTableModel.convertRE2Pattern(zoneRE, "zoneRE");
        DataView dataView = BrowserFrame.getDataView();
        if (dataView._tableModel instanceof SmHostTableModel) {
            int[] sels = dataView._table.getSelectedRows();
            Array data = this.getData();
            int importedAliasCount = 0;
            for (int i = 0; i < sels.length; ++i) {
                String aliasname;
                String zoneName;
                EndPort ep;
                int row = sels[i];
                Object[] rowData = (Object[])data.elementAt(row);
                String currentAlias = (String)rowData[3];
                if (currentAlias != null && currentAlias.trim().length() > 0 || (ep = (EndPort)rowData[this._endPortCol]) == null || !ep.isInitiator() || (zoneName = this.getZoneNameForEndPort(ep)) == null || zoneName.equals(aliasname = GenUtil.regexMatch(patternList, zoneName, toUpper)) || aliasname == null || aliasname.trim().length() <= 0) continue;
                this.setValueAt(aliasname, row, 3);
                ++importedAliasCount;
            }
            BrowserFrame.getInstance().setStatus("Zone->Alias action complete: number of Aliases set - " + importedAliasCount);
        }
    }

    private void processErrorMessages(String message) {
        int MAX_ERR_MSG = 50;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._setErrMsg.size(); ++i) {
            sb.append(this._setErrMsg.elementAt(i));
            sb.append('\n');
            if (i != MAX_ERR_MSG) continue;
            sb.append("...see log for details.\n");
        }
        if (message != null && message.length() > 0) {
            sb.append(message);
        }
        if (sb.toString().length() > 0) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), sb.toString());
        }
    }

    @Override
    public void postErrorMsg() throws Exception {
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (err != null && err.length() != 0 && pdu.getPeer() != null) {
            this._failedPeers.add(pdu.getPeer());
        }
    }

    private String getZoneNameForEndPort(EndPort ep) {
        String zoneName = null;
        Vsan vsan = ep.getVsan();
        if (vsan != null) {
            EnforcedZone[] zones;
            for (EnforcedZone nextZone : zones = vsan.getEnforcedZones()) {
                ArrayList<EndPort> zoneInitiators = nextZone.getEndPorts(null, false);
                if (zoneInitiators.size() != 1 || !zoneInitiators.get(0).equals(ep)) continue;
                return nextZone.getName();
            }
        }
        return zoneName;
    }

    protected void saveAliasREtoServer(String aliasRE) {
        try {
            ClientController.getInstance().assertSession().updateServerProperty("fabric.aliasRE", aliasRE);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
        }
    }

    protected void saveZoneREtoServer(String zoneRE) {
        try {
            ClientController.getInstance().assertSession().updateServerProperty("fabric.zoneRE", zoneRE);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
        }
    }

    public static ArrayList<Pattern> convertRE2Pattern(String regEx, String errorMsgStr) throws Exception {
        if (regEx != null && regEx.length() != 0) {
            String[] ss = regEx.split(",", -1);
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (int i = 0; i < ss.length; ++i) {
                try {
                    String pattern = ss[i].replaceAll("\n", "");
                    pattern.trim();
                    patterns.add(Pattern.compile(pattern));
                    continue;
                }
                catch (PatternSyntaxException ex) {
                    throw new Exception(ss[i] + " " + regEx + " error: " + ex);
                }
            }
            return patterns;
        }
        return null;
    }

    public static String convertRE2SingleLineString(String regEx) throws Exception {
        if (regEx != null && regEx.length() != 0) {
            String newRE = regEx.replaceAll("[\r\n]+", "");
            return newRE;
        }
        return null;
    }

    class CFSWorker
    implements Runnable {
        private String fabricName;
        private SnmpPeer peer;
        private ArrayList changedAliasList;
        private StringBuffer msg;

        public CFSWorker(String fabricName, SnmpPeer peer, ArrayList changedAliasList, StringBuffer msg) {
            this.fabricName = fabricName;
            this.peer = peer;
            this.changedAliasList = changedAliasList;
            this.msg = msg == null ? new StringBuffer() : msg;
        }

        @Override
        public void run() {
            boolean committed = false;
            SmHostTableModel.this._cfsFabricCount = (short)(SmHostTableModel.this._cfsFabricCount + 1);
            String tmpMsg = null;
            try {
                VarBindList vbl = new VarBindList();
                vbl.add(SmCFSControlTableModel._cfsFeatureOpStatusOid, SmCFSControlTableModel.DDAS_INDEX);
                SnmpPDU resp = null;
                resp = this.peer.send(new SnmpPDU(-96, vbl));
                if (resp.getVariables().intValue(0) != 2) {
                    vbl.clear();
                    vbl.add(new SnmpVarBind(new SnmpOID(SmCFSControlTableModel._cfsFeatureOpActionOid, SmCFSControlTableModel.DDAS_INDEX), new SnmpInt(2)));
                    this.peer.set(new SnmpPDU(-93, vbl));
                }
                _Logger.warn((Object)("Commit device alias on fabric: " + this.fabricName + " switch: " + this.peer));
                System.out.println("Commit device alias on fabric: " + this.fabricName + " switch: " + this.peer);
                vbl.clear();
                vbl.add(new SnmpVarBind(new SnmpOID(SmCFSControlTableModel._cfsFeatureOpActionOid, SmCFSControlTableModel.DDAS_INDEX), new SnmpInt(4)));
                this.peer.set(new SnmpPDU(-93, vbl));
                boolean poll = true;
                vbl.clear();
                SmCfsUtil.getInstance();
                vbl.add(new SnmpVarBind(new SnmpOID(SmCfsUtil._cfsFeatureOpLastActionResultOid, SmCFSControlTableModel.DDAS_INDEX), new SnmpInt(4)));
                long start = System.currentTimeMillis() / 1000L;
                while (poll && System.currentTimeMillis() / 1000L - start < 5L) {
                    resp = this.peer.send(new SnmpPDU(-96, vbl));
                    committed = resp.getVariables().intValue(0) == 2;
                    if (!committed) continue;
                    poll = false;
                }
                if (!committed && resp.getVariables().intValue(0) == 4) {
                    resp = this.peer.send(new SnmpPDU(-96, vbl));
                    committed = resp.getVariables().intValue(0) == 2;
                }
            }
            catch (SnmpException ex) {
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("Fabric " + this.fabricName + ": " + ex.getMessage()));
                }
                tmpMsg = "Fabric " + this.fabricName + " seed " + this.peer + ": " + ex.getMessage() + "\n";
            }
            if (committed) {
                try {
                    for (int i = 0; i < this.changedAliasList.size(); ++i) {
                        ChangedModelObject cmObject = (ChangedModelObject)this.changedAliasList.get(i);
                        EndPort ep = ClientController.findFabricEndPortByWwn(((WwnKey)cmObject.getPK())._wwn);
                        if (ep == null) continue;
                        String epFabricName = ep.getFabric().getFabricName();
                        if (this.fabricName == null || !this.fabricName.equals(epFabricName)) continue;
                        if (ClientController.getInstance().isServerActive()) {
                            ClientController.getInstance().assertModelFacade().propertyChanged((FabricPK)ep.getFabric().getPK(), cmObject);
                        }
                        ep.setDeviceAlias((String)((Object)cmObject.getNewValue()));
                    }
                }
                catch (Exception ex) {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)("Fabric " + this.fabricName + ": " + ex.getMessage()));
                    }
                    tmpMsg = tmpMsg + "Fabric " + this.fabricName + ": " + ex.getMessage() + "\n";
                }
            }
            if (tmpMsg != null) {
                this.msg.append(tmpMsg);
            }
            SmHostTableModel.this._cfsFabricCount = (short)(SmHostTableModel.this._cfsFabricCount - 1);
        }
    }

    class AliasRegion {
        int regionId = -1;
        Switch seedSw = null;

        public AliasRegion(int id, Switch seed) {
            this.regionId = id;
            this.seedSw = seed;
        }

        public int getRegionId() {
            return this.regionId;
        }

        public Switch getSeedSwitch() {
            return this.seedSw;
        }
    }

    class Alias2EnclosureDlg
    extends JDialog
    implements ActionListener {
        JTextArea _aliasREContent;
        static final String HELP_TEXT = "<html>You can create enclosure names from selected aliases using the following regular expression list.<br>Please modify them as appropriate and use ',' or carriage return to seperate each pattern.";

        public Alias2EnclosureDlg(String aliasRE) {
            super((Frame)BrowserFrame.getInstance(), SmHostTableModel.ALIAS_2_ENCLOSURE_BTN_TEXT_NO_DISP);
            JLabel helpLabel = new JLabel(HELP_TEXT);
            this._aliasREContent = new JTextArea();
            this._aliasREContent.setEditable(true);
            this.initAliasREDisplay(aliasRE);
            JScrollPane sp = new JScrollPane(this._aliasREContent);
            sp.setPreferredSize(new Dimension(300, 250));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add("North", helpLabel);
            panel.add("Center", sp);
            String[] btns = new String[]{"Apply", "OK", "Close"};
            SmHostTableModel.this._cbNoDisp = new JCheckBox("Don't show me again");
            SmHostTableModel.this._cbNoDisp.setSelected(!SmHostTableModel.getPromptAliasEnclosureFlag());
            panel.add("South", SmHostTableModel.this._cbNoDisp);
            DialogUtil.buildDialog((JDialog)this, (Container)BrowserFrame.getInstance(), (Container)panel, (AbstractButton[])DialogUtil.buildButtons(btns, (ActionListener)this));
            this.setDefaultCloseOperation(2);
            this.setResizable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = ((JButton)e.getSource()).getText();
            try {
                switch (cmd.charAt(0)) {
                    case 'O': {
                        this.applyChangesToSelectedRows();
                    }
                    case 'C': {
                        this.dispose();
                        break;
                    }
                    case 'A': {
                        this.applyChangesToSelectedRows();
                    }
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
            }
        }

        void applyChangesToSelectedRows() throws Exception {
            SmHostTableModel.setPromptAliasEnclosureFlag(!SmHostTableModel.this._cbNoDisp.isSelected());
            SmHostTableModel.this.initAliasBtn();
            String toUpperStr = ClientController.getInstance().assertSession().getServerProperty("fabric.alias.toEnclosure.toUpper");
            boolean toUpper = true;
            if (toUpperStr != null) {
                toUpper = Boolean.parseBoolean(toUpperStr);
            }
            String newAliasRE = this._aliasREContent.getText();
            ArrayList<Pattern> patternList = SmHostTableModel.convertRE2Pattern(newAliasRE, "aliasRE");
            DataView dataView = BrowserFrame.getDataView();
            if (dataView._tableModel instanceof SmHostTableModel) {
                int[] sels = dataView._table.getSelectedRows();
                Array data = SmHostTableModel.this.getData();
                for (int i = 0; i < sels.length; ++i) {
                    int row = sels[i];
                    Object[] rowData = (Object[])data.elementAt(row);
                    String alias = (String)rowData[3];
                    if (alias == null || alias.equals("")) continue;
                    String encname = GenUtil.regexMatch(patternList, alias, toUpper);
                    SmHostTableModel.this.setValueAt(encname, row, 2);
                }
            }
            String lineStr = SmHostTableModel.convertRE2SingleLineString(newAliasRE);
            SmHostTableModel.this.saveAliasREtoServer(lineStr);
        }

        protected void reloadData() {
            SmHostTableModel.this._cbNoDisp.setSelected(!SmHostTableModel.getPromptAliasEnclosureFlag());
        }

        protected void initAliasREDisplay(String aliasRE) {
            String[] ss = aliasRE.split(",", -1);
            StringBuffer displayAliasRE = new StringBuffer();
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].trim().length() == 0) continue;
                if (i == ss.length - 1) {
                    displayAliasRE.append(ss[i] + ",");
                    continue;
                }
                displayAliasRE.append(ss[i] + ",\n");
            }
            if (displayAliasRE.indexOf("(.*)[_-].*,\n") == -1) {
                displayAliasRE.append("(.*)[_-].*,\n");
            }
            this._aliasREContent.setText(displayAliasRE.toString());
        }

        public void refreshAliasREDisplay(String aliasRE) {
            this.initAliasREDisplay(aliasRE);
        }
    }

    class Zone2AliasDlg
    extends JDialog
    implements ActionListener {
        JTextArea _zoneREContent;
        Zone2AliasTableModel _zone2AliasTablModel;
        KTable _zone2AliasTable;
        HeaderListener _headerListener;
        static final String HELP_TEXT = "<html>You can create aliases for selected devices from zone names using the following regular expression list.<br>Please modify them as appropriate and use ',' or carriage return to seperate each pattern.<br>Note:Selected rows with aliases not included.";

        public Zone2AliasDlg(String zoneRE) {
            super((Frame)BrowserFrame.getInstance(), SmHostTableModel.ZONE_2_ALIAS_BTN_TEXT_NO_DISP);
            this.setModal(true);
            JLabel helpLabel = new JLabel(HELP_TEXT);
            this._zoneREContent = new JTextArea();
            this._zoneREContent.setEditable(true);
            this.initZoneREDisplay(zoneRE);
            JScrollPane sp = new JScrollPane(this._zoneREContent);
            sp.setPreferredSize(new Dimension(650, 100));
            JPanel panel = new JPanel(new BorderLayout());
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add("North", helpLabel);
            northPanel.add("Center", sp);
            this._zone2AliasTablModel = new Zone2AliasTableModel();
            this._zone2AliasTable = new KTable(this._zone2AliasTablModel);
            if (SmHostTableModel.this._rawWwnRenderer == null) {
                SmHostTableModel.this._rawWwnRenderer = new RawWWNRenderer();
            }
            this._zone2AliasTable.setCellSelectionEnabled(true);
            this._headerListener = new HeaderListener();
            this._zone2AliasTable.getTableHeader().addMouseListener(this._headerListener);
            this._zone2AliasTable.setSortable(true);
            this._zone2AliasTable.getColumnModel().getColumn(this._zone2AliasTablModel.PORT_WWN_COL).setCellRenderer(SmHostTableModel.this._rawWwnRenderer);
            JScrollPane tablePanel = new JScrollPane(this._zone2AliasTable);
            panel.add("North", northPanel);
            panel.add("Center", tablePanel);
            String[] btns = new String[]{"Run Regular Expressions", "Copy To Table", "Close"};
            DialogUtil.buildDialog((JDialog)this, (Container)BrowserFrame.getInstance(), (Container)panel, (AbstractButton[])DialogUtil.buildButtons(btns, (ActionListener)this));
            this.setDefaultCloseOperation(2);
            this.setResizable(true);
            this.reloadData();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = ((JButton)e.getSource()).getText();
            try {
                if (cmd.startsWith("R")) {
                    this.runRegex();
                } else if (cmd.startsWith("Close")) {
                    this.dispose();
                } else if (cmd.startsWith("Copy")) {
                    this.copyToTable();
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
            }
        }

        protected void reloadData() {
            Array<Object[]> zoneDialogTabledata = new Array<Object[]>();
            this._zone2AliasTablModel.setData(zoneDialogTabledata);
            int[] sels = BrowserFrame.getDataView()._table.getSelectedRows();
            Array hostTabledata = SmHostTableModel.this.getData();
            int rowLength = this._zone2AliasTablModel.headers.length + 3;
            int zoneNameCount = 0;
            for (int i = 0; i < sels.length; ++i) {
                String currentAlias;
                int rowIndex = sels[i];
                Object[] rowData = (Object[])hostTabledata.elementAt(rowIndex);
                if (rowData == null || (currentAlias = (String)rowData[3]) != null && currentAlias.trim().length() > 0) continue;
                EndPort ep = (EndPort)rowData[SmHostTableModel.this._endPortCol];
                String zoneName = "";
                if (ep != null && ep.isInitiator() && (zoneName = SmHostTableModel.this.getZoneNameForEndPort(ep)) != null && zoneName.trim().length() > 0) {
                    ++zoneNameCount;
                }
                Object[] newZoneRowData = new Object[rowLength];
                newZoneRowData[this._zone2AliasTablModel.NAME_COL] = rowData[2];
                newZoneRowData[this._zone2AliasTablModel.PORT_WWN_COL] = rowData[4];
                newZoneRowData[this._zone2AliasTablModel.ZONE_NAME_COL] = zoneName;
                newZoneRowData[this._zone2AliasTablModel.DEVICE_ALIAS_COL] = rowData[3];
                newZoneRowData[this._zone2AliasTablModel.END_PORT_HIDDEN_COL] = ep;
                newZoneRowData[this._zone2AliasTablModel.ROW_INDEX_HIDDEN_COL] = rowIndex;
                zoneDialogTabledata.addElement(newZoneRowData);
            }
            this._zone2AliasTablModel.setData(zoneDialogTabledata);
            if (zoneNameCount == 0) {
                JOptionPane.showMessageDialog(this, "No qualifying zone names were found for the ports selected. To qualify the zone must contain only the port as a member.", "Zone->Alias ", 1);
            }
        }

        void runRegex() throws Exception {
            if (this._zone2AliasTable.isEditing()) {
                this._zone2AliasTable.getCellEditor().stopCellEditing();
            }
            String toUpperStr = ClientController.getInstance().assertSession().getServerProperty("fabric.zone.toAlias.toUpper");
            boolean toUpper = false;
            if (toUpperStr != null) {
                toUpper = Boolean.parseBoolean(toUpperStr);
            }
            String newzoneRE = this._zoneREContent.getText();
            ArrayList<Pattern> patternList = SmHostTableModel.convertRE2Pattern(newzoneRE, "zoneRE");
            Array data = this._zone2AliasTablModel.getData();
            int importedAliasCount = 0;
            for (int i = 0; i < data.size(); ++i) {
                String aliasname;
                String zoneName;
                Object[] rowData = (Object[])data.elementAt(i);
                String currentAlias = (String)rowData[this._zone2AliasTablModel.DEVICE_ALIAS_COL];
                if (currentAlias != null && currentAlias.trim().length() > 0 || (zoneName = (String)rowData[this._zone2AliasTablModel.ZONE_NAME_COL]) == null || (aliasname = GenUtil.regexMatch(patternList, zoneName, toUpper)) == null || zoneName.equals(aliasname) || aliasname.trim().length() <= 0) continue;
                this._zone2AliasTablModel.setValueAt(aliasname, i, this._zone2AliasTablModel.DEVICE_ALIAS_COL);
                ++importedAliasCount;
            }
            String lineStr = SmHostTableModel.convertRE2SingleLineString(newzoneRE);
            SmHostTableModel.this.saveZoneREtoServer(lineStr);
            if (importedAliasCount == 0) {
                JOptionPane.showMessageDialog(this, "Regular expression run complete, no new aliases were found.", "Zone->Alias ", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Regular expression run complete, number of aliases found:  " + importedAliasCount, "Zone->Alias ", 1);
            }
        }

        void copyToTable() throws Exception {
            if (this._zone2AliasTable.isEditing()) {
                this._zone2AliasTable.getCellEditor().stopCellEditing();
            }
            Array data = this._zone2AliasTablModel.getData();
            int importedAliasCount = 0;
            for (int i = 0; i < data.size(); ++i) {
                Object[] rowData = (Object[])data.elementAt(i);
                String currentAlias = (String)rowData[this._zone2AliasTablModel.DEVICE_ALIAS_COL];
                if (currentAlias == null || currentAlias.trim().length() == 0) continue;
                int rowIndex = (Integer)rowData[this._zone2AliasTablModel.ROW_INDEX_HIDDEN_COL];
                SmHostTableModel.this.setValueAt(currentAlias, rowIndex, 3);
                ++importedAliasCount;
            }
            if (importedAliasCount == 0) {
                JOptionPane.showMessageDialog(this, "No aliases found to copy.", "Zone->Alias ", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Copy to table complete, number of aliases copied:  " + importedAliasCount, "Zone->Alias ", 1);
            }
            BrowserFrame.getInstance().setStatus("Zone->Alias action complete: number of Aliases set - " + importedAliasCount);
        }

        protected void initZoneREDisplay(String zoneRE) {
            String[] ss = zoneRE.split(",", -1);
            StringBuffer displayZoneRE = new StringBuffer();
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].trim().length() == 0) continue;
                if (i == ss.length - 1) {
                    displayZoneRE.append(ss[i] + ",");
                    continue;
                }
                displayZoneRE.append(ss[i] + ",\n");
            }
            this._zoneREContent.setText(displayZoneRE.toString());
        }

        public void refreshZoneREDisplay(String zoneRE) {
            this.initZoneREDisplay(zoneRE);
        }
    }

    class Zone2AliasTableModel
    extends KTableModel {
        public int NAME_COL = 0;
        public int PORT_WWN_COL = 1;
        public int ZONE_NAME_COL = 2;
        public int DEVICE_ALIAS_COL = 3;
        public int END_PORT_HIDDEN_COL = 5;
        public int ROW_INDEX_HIDDEN_COL = 6;
        public String[] headers = new String[]{"Enclosure Name", "Port WWN", "Zone Name", "Device Alias"};

        public Zone2AliasTableModel() {
            this.setHeaders(this.headers);
            this.setEditable(new boolean[]{false, false, false, true});
        }
    }
}

