/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.gui.SmTableModel;

public class SmIPSubIfTableModel
extends SmTableModel {
    static final int ADDR_COL = 7;
    static final int[] _ipPrefixOid = MibNode.get("ciiIPIfAddressPrefixLength").getOid();

    @Override
    protected SnmpPDU buildGetTablePdu(SnmpPeer node, int[] index) {
        SnmpPDU pdu = new SnmpPDU(-95, new VarBindList(this._mibNodes.length));
        for (int j = this._offset; j < this._mibNodes.length; ++j) {
            if (j == 7) {
                pdu.addNull(new SnmpOID(this._mibNodes[j].getOid(), index[0] + 1));
                continue;
            }
            pdu.addNull(new SnmpOID(this._mibNodes[j].getOid(), index));
        }
        return pdu;
    }

    @Override
    protected boolean isSkip(SnmpPeer peer, int[] req, SnmpVarBind firstVb, int[] index, VarBindList vbl, int reqId) {
        int[] oid = firstVb.getOid().getValue();
        int ifIndex = oid[oid.length - 1];
        int subIf = ifIndex & 0xFFF;
        if (subIf == 0) {
            return true;
        }
        return super.isSkip(peer, req, firstVb, index, vbl, reqId);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        int[] addrId = vbl.getVb(vbl.size() - 1).getOid().getValue();
        int ifIndex = index.getValue()[0];
        if (SnmpOID.startsWith(addrId, _ipPrefixOid)) {
            int addrIfIndex = addrId[addrId.length - 7];
            if (ifIndex == addrIfIndex) {
                SnmpOID ip = new SnmpOID(addrId, addrId.length - 4, 4);
                row[7] = ip.toString() + "/" + row[7];
            } else {
                row[7] = "n/a";
                addrId[addrId.length - 7] = ifIndex;
            }
        } else {
            row[7] = "n/a";
        }
        return row;
    }
}

