/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.ISLCellIf;
import com.cisco.dcbu.sm.client.dialogs.IslData;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class SmISLCellEditor
extends DefaultCellEditor {
    private JMenu _menu;
    private JTable _table;
    private SnmpPeer _peer;
    private JPanel _panel;
    private JTextField _data;
    private int _vsan;
    private int _destDomain;
    private HashMap _peerIslMap;
    private Switch _srcSw;
    private Switch _destSw;
    static final int COL_SNMP_PEER = 0;
    static final int COL_VSAN_ID = 1;
    static final int COL_DOMAIN_ID = 2;

    public SmISLCellEditor(JTable table) {
        super(new JComboBox());
        this.setClickCountToStart(1);
        this._table = table;
        this._panel = new JPanel(new BorderLayout());
        this._data = new JTextField();
        this._data.setBorder(BorderFactory.createLineBorder(Color.black));
        this._data.setFont(ChangedCellRenderer.getChangeFont());
        this._panel.add((Component)this._data, "Center");
        this._menu = new JMenu();
        MyMenuButton btn = new MyMenuButton(this._menu, this._data);
        this._panel.add((Component)btn, "East");
        this._panel.setBorder(null);
        this._peerIslMap = ((ISLCellIf)((Object)this._table.getModel())).getPeerISLs();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._table = table;
        this._menu = new JMenu();
        this._vsan = (Integer)this._table.getValueAt(row, this._table.convertColumnIndexToModel(1));
        String domainString = (String)this._table.getValueAt(row, this._table.convertColumnIndexToModel(2));
        this._destDomain = this.convertDomainIdToInteger(domainString);
        this._peer = (SnmpPeer)this._table.getValueAt(row, 0);
        this._srcSw = ClientController.findFabricSwitchByIpAddress(this._peer.getAddress());
        this._destSw = ClientController.findFabricSwitchByVsanDomainId(this._vsan, this._destDomain);
        this._data.setText(value != null ? value.toString() : "");
        return this._panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this._data.getText();
    }

    public int convertDomainIdToInteger(String idStr) throws NumberFormatException {
        if (idStr == null || idStr.trim().length() == 0) {
            throw new NumberFormatException("Input string is null or empty.");
        }
        if (idStr.indexOf(40) >= 0) {
            int value = Integer.parseInt(idStr.substring(idStr.indexOf(40) + 1, idStr.indexOf(41)));
            return value;
        }
        if (idStr.toLowerCase().startsWith("0x")) {
            int value = Integer.parseInt(idStr.substring(2), 16);
            return value;
        }
        return Integer.parseInt(idStr);
    }

    class MyMenuButton
    extends MenuButton {
        JTextField _parent;

        public MyMenuButton(JMenu menu, JTextField parent) {
            super(menu);
            this._parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._menu = new JMenu();
            try {
                Object[] names = null;
                String srcKey = String.valueOf(SmISLCellEditor.this._srcSw.getWwn());
                String destKey = String.valueOf(SmISLCellEditor.this._destSw.getWwn());
                String key = srcKey + "_" + destKey;
                ArrayList islList = (ArrayList)SmISLCellEditor.this._peerIslMap.get(key);
                if (islList != null) {
                    names = new String[islList.size()];
                    for (int i = 0; i < islList.size(); ++i) {
                        names[i] = ((IslData)islList.get(i)).toStringShort();
                    }
                }
                if (names == null || names.length == 0) {
                    this.setEnabled(false);
                    return;
                }
                this.buildMenu(names);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (e.getSource() instanceof JMenuItem) {
                if (this._parent != null) {
                    String ifName = ((JMenuItem)e.getSource()).getText();
                    int offset = ifName.indexOf(40);
                    ifName = offset == -1 ? ifName : ifName.substring(0, offset);
                    this._parent.setText(ifName);
                }
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

