/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class SmInsertAsmBase
extends InsertForm {
    protected int _asmTimeout = -1;

    public SmInsertAsmBase(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this.updateParamsUponSwitchListChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this.updateParamsUponSwitchListChange();
                return;
            }
        }
        super.actionPerformed(e);
    }

    protected void updateParamsUponSwitchListChange() {
    }

    protected boolean isValidCard(Switch sw, Card card) {
        return card.getType() == 5 || card.getType() == 20;
    }

    protected void loadModuleList(JComboBox moduleList) {
        Card[] cards;
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        ArrayList<Integer> cardlist = new ArrayList<Integer>();
        if (sw != null && (cards = sw.getCards()) != null) {
            for (int i = 0; i < cards.length; ++i) {
                if (cards[i] == null || !this.isValidCard(sw, cards[i])) continue;
                cardlist.add(new Integer(cards[i].getSlotId()));
            }
            if (cardlist.size() != 0) {
                Integer[] ssmCardIds = cardlist.toArray(new Integer[cardlist.size()]);
                DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(ssmCardIds);
                moduleList.setModel(model);
                moduleList.setSelectedIndex(0);
            }
        }
    }
}

