/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class SmInsertCfsRegion
extends InsertForm {
    private static final int FEATURE = 0;
    private static final int REGIONID = 1;
    int[] _regionIndex;
    int[] CfsRegionStatusOid = MibNode.get("cfsRegionStatus").getOid();
    int[] CfsFeatureOpStatusOid = MibNode.get("cfsFeatureOpStatus").getOid();
    SnmpPeer _selectedPeer;
    JComboBox _featureList;

    public SmInsertCfsRegion(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        try {
            String[] list = this.getCfsFeatures();
            this._featureList.setModel(new DefaultComboBoxModel<String>(list));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            String[] list = new String[]{};
            this._featureList = new JComboBox<String>(list);
            return this._featureList;
        }
        if (index == 1) {
            return new FieldPanel(this.getWidth(mibVar, mibNode, mibNode.getTCLabel()), 1, mibNode.getHi(), (String)SnmpTableModel._Units.get(mibVar));
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            Object selected = ((JComboBox)this._values[index]).getSelectedItem();
            return new SnmpString((String)((JComboBox)this._values[index]).getSelectedItem());
        }
        return super.getComponentValue(index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        this._regionIndex = new int[2];
        this._regionIndex[0] = 1;
        this._regionIndex[1] = Integer.parseInt(((FieldPanel)this._values[1]).getText());
        int[] newIndex = new int[index.length + 2];
        newIndex[0] = index.length;
        System.arraycopy(index, 0, newIndex, 1, index.length);
        newIndex[newIndex.length - 1] = 1;
        return newIndex;
    }

    @Override
    protected int setInsertRow(VarBindList vbl) throws Exception {
        this.createRegion();
        return super.setInsertRow(vbl);
    }

    private void createRegion() throws Exception {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(this.CfsRegionStatusOid, this._regionIndex), new SnmpInt(4)));
        for (int i = 0; i < this._selPeerList.length; ++i) {
            SnmpPDU pdu = this.getInsertPDU((SnmpPeer)this._selPeerList[i], vbl);
            if (pdu == null) continue;
            try {
                ((SnmpPeer)this._selPeerList[i]).send(pdu);
                continue;
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) continue;
                System.out.println("ignore region creation error, region may have been created.");
            }
        }
    }

    private String[] getCfsFeatures() throws SnmpException {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(this.CfsFeatureOpStatusOid)));
        int length = this.CfsFeatureOpStatusOid.length;
        SnmpPDU resp = SnmpFetch.getBulk(peer, vbl, 0);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        String[] list = new String[vbl.size()];
        for (int i = 0; i < vbl.size(); ++i) {
            int[] index = vbl.get(i).getOid().getValue();
            String a = SnmpString.toString(index, length + 1, index.length);
            list[i] = SnmpString.toString(index, length + 1, index.length);
        }
        return list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                try {
                    String[] list = this.getCfsFeatures();
                    this._featureList.setModel(new DefaultComboBoxModel<String>(list));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this._selectedPeer = peer;
                return;
            }
        }
        super.actionPerformed(e);
    }
}

