/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Enclosure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SmInsertEnclosure
extends InsertForm
implements ItemListener,
ActionListener {
    public static final String[] LABELS = new String[]{"Enclosure Name: ", "IP Address: ", "Element Manager Path: ", "Device Type: "};
    public static final int NAME = 0;
    public static final int ENCIPADDR = 1;
    public static final int DM_HTTP = 2;
    public static final int DM_PATH = 2;
    public static final int DEVICE_TYPE = 3;
    JButton _dmButton;
    JTextField _dmText;

    public SmInsertEnclosure(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        this._labels = new JLabel[LABELS.length];
        this._values = new JComponent[LABELS.length];
        for (int i = 0; i < this._values.length; ++i) {
            this._labels[i] = new JLabel(LABELS[i]);
            this._values[i] = i == 2 ? this.buildDMPannel() : (i == 3 ? new JComboBox<String>(Enclosure.getAllowedDeviceTypes()) : new KTextField(20));
        }
        this.layoutForm();
        this.buildButtons();
    }

    @Override
    protected void layoutForm() {
        JComponent[] labels = new JComponent[this._labels.length + 4];
        System.arraycopy(this._labels, 0, labels, 0, this._labels.length);
        JComponent[] values = new JComponent[this._values.length + 4];
        System.arraycopy(this._values, 0, values, 0, this._values.length);
        values[values.length - 4] = new DialogSeparator();
        DialogUtil.buildPanel(this._container, labels, values);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected = e.getStateChange() == 1;
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void insert() throws Exception {
        String typeString;
        String enclosureName = ((KTextField)this._values[0]).getText().trim();
        if (enclosureName == null || enclosureName.length() == 0) {
            ((KTextField)this._values[0]).setText("");
            throw new Exception("Enclosure should have a name");
        }
        String ip = ((KTextField)this._values[1]).getText().trim();
        InetAddress ia = null;
        int type = 0;
        if (ip == null || ip.length() == 0) {
            ((KTextField)this._values[1]).setText("");
        } else {
            try {
                ia = InetAddress.getByName(ip);
            }
            catch (Exception uhe) {
                throw new Exception("Invalid IP Address: " + ip);
            }
        }
        String dmPath = this._dmText.getText().trim();
        if (dmPath == null || dmPath.length() == 0) {
            this._dmText.setText("");
        }
        if ((typeString = ((String)((JComboBox)this._values[3]).getSelectedItem()).trim()) != null && typeString.length() > 0) {
            type = Enclosure.getDeviceType(null, typeString);
        }
        ClientController.getInstance().updateEnclosure(null, null, new String[]{enclosureName}, new String[]{ip}, new int[]{type}, new String[]{dmPath}, new String[]{""}, new String[]{""}, new String[]{""}, new String[]{""});
        this._parent.dispose();
        BrowserFrame.getDataView().refresh();
    }

    @Override
    protected void insertAction() throws Exception {
        super.insertAction();
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        return new SnmpPDU(-93, vbl);
    }

    public JComponent buildDMPannel() {
        JPanel panel = new JPanel(new BorderLayout());
        this._dmText = new KTextField();
        panel.add((Component)this._dmText, "Center");
        this._dmButton = new JButton("..."){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.setSize(12.0, dim.getHeight());
                return dim;
            }
        };
        this._dmButton.addActionListener(this);
        this._dmButton.setToolTipText("Browse File...");
        panel.add((Component)this._dmButton, "East");
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._dmButton) {
            String s = Util.getFileName(BrowserFrame.getInstance(), "*.*", 0);
            if (s != null && s.length() > 0) {
                this._dmText.setText(s);
            }
        } else {
            super.actionPerformed(event);
        }
    }
}

