/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class SmInsertFcIdPersistency
extends InsertForm {
    static final int VSANID = 0;

    public SmInsertFcIdPersistency(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        if (!this._table.isTableFiltered()) {
            this._choice.setActionCommand("L");
            this._choice.addActionListener(this);
        } else {
            this.setComponentVisibleAt(0, false);
        }
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            short[] vsans;
            if (this._table.isTableFiltered()) {
                vsans = new short[]{(short)this._table.getTableIndex()};
            } else {
                SnmpPeer peer = this._peers[0];
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                vsans = sw.getVsanIds();
            }
            Integer[] oVsans = new Integer[vsans == null ? 0 : vsans.length];
            for (int i = 0; i < oVsans.length; ++i) {
                oVsans[i] = new Integer(vsans[i]);
            }
            JComboBox<Integer> combo = new JComboBox<Integer>(oVsans);
            Dimension dm = combo.getPreferredSize();
            dm.setSize(80, dm.height);
            combo.setPreferredSize(dm);
            return combo;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            JComboBox combo = (JComboBox)this._values[index];
            int vsanId = (Integer)combo.getSelectedItem();
            return new SnmpInt(vsanId);
        }
        return super.getComponentValue(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                JComboBox comboPeer = (JComboBox)e.getSource();
                SnmpPeer peer = (SnmpPeer)comboPeer.getSelectedItem();
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                short[] vsans = sw.getVsanIds();
                Integer[] oVsans = new Integer[vsans == null ? 0 : vsans.length];
                for (int i = 0; i < oVsans.length; ++i) {
                    oVsans[i] = new Integer(vsans[i]);
                }
                DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(oVsans);
                JComboBox comboVsan = (JComboBox)this._values[0];
                comboVsan.setModel(model);
                return;
            }
        }
        super.actionPerformed(e);
    }
}

