/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;

public class SmInsertIPRoute
extends InsertForm {
    static final int INSTANCE = 0;
    static final int DEST_TYPE = 1;
    static final int DEST = 2;
    static final int MASK = 3;
    static final int GATEWAY_TYPE = 4;
    static final int GATEWAY = 5;
    static final int METRIC = 6;
    static final int INTERFACE = 7;
    VsanIdMenuButton _interfaceButton = null;

    public SmInsertIPRoute(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 7) {
            SnmpPeer peer = this._peers[0];
            if (this._choice != null && this._choice.getSelectedItem() != null) {
                peer = (SnmpPeer)this._choice.getSelectedItem();
            }
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            this._interfaceButton = new VsanIdMenuButton(null, peer, 2, sw);
            FieldPanel f = new FieldPanel(mibNode.getMaxWidth(), (JComponent)this._interfaceButton);
            return f;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this.getComponentAt(0).setVisible(false);
        this._labels[0].setVisible(false);
        this.getComponentAt(1).setVisible(false);
        this._labels[1].setVisible(false);
        this.getComponentAt(4).setVisible(false);
        this._labels[4].setVisible(false);
        this.setComponentText(0, "0");
        this.setComponentText(3, "24");
        this.setComponentText(6, "1");
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 7) {
            String ifName = ((FieldPanel)this._values[index]).getText();
            Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._choice.getSelectedItem()).getAddress());
            return new SnmpInt(sw.nameToIfIndex(ifName));
        }
        if (index == 6) {
            if (((FieldPanel)this._values[index]).getText().equals("1")) {
                return new SnmpInt(-1);
            }
        } else if (index == 0) {
            int pos;
            String ifName = ((FieldPanel)this._values[7]).getText();
            int moduleId = 0;
            if (ifName.startsWith("cpp") && (moduleId = Integer.parseInt(ifName.substring(3, pos = ifName.indexOf(47)))) < 0) {
                throw new Exception("bad interface: " + ifName);
            }
            return new SnmpInt(moduleId);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected boolean isAddStringLength(MibNode mibNode) {
        return mibNode.getType() == 4 && mibNode.getTCLabel() != null && !mibNode.getTCLabel().equals("FcAddressId") && !mibNode.getTCLabel().equals("FcNameId") && !mibNode.getTCLabel().equals("InetAddress");
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        if (values[2] instanceof SnmpInetAddress) {
            int n = index[1] = ((SnmpInetAddress)values[2]).getValue().length == 16 ? 2 : 1;
        }
        if (values[5] instanceof SnmpInetAddress) {
            int len = ((SnmpInetAddress)values[5]).getValue().length;
            index[index.length - len - 1] = len == 16 ? 2 : (len == 0 ? 0 : 1);
        }
        return index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                try {
                    SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                    Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                    this._interfaceButton.setPeer(peer, sw);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
        super.actionPerformed(e);
    }
}

