/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.dialogs.SmIpProfileUtil;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

public class SmInsertIfIpProfile
extends InsertForm {
    static final int INTERFACE = 0;
    static final int DIRECTION = 1;
    static final int PROFILE = 2;
    private static final int IPV4 = 2;
    private static final int IPV6 = 3;
    public static final String IP_INBOUND_V4 = "inbound";
    public static final String IP_OUTBOUND_V4 = "outbound";
    public static final String IP_INBOUND_V6 = "inboundIPv6";
    public static final String IP_OUTBOUND_v6 = "outboundIPv6";
    int _profileType = 2;
    JComboBox _cmbx;

    public SmInsertIfIpProfile(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this.setComponentText(0, "mgmt0");
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 2) {
            HashMap profiles = SmIpProfileUtil.getInstance().getProfiles(this._profileType);
            Object[] strProfiles = new String[profiles.size()];
            int numProfiles = 0;
            for (String profile : profiles.keySet()) {
                strProfiles[numProfiles++] = profile;
            }
            Arrays.sort(strProfiles);
            this._cmbx = new JComboBox<Object>(strProfiles);
            this._cmbx.setEditable(true);
            this._cmbx.setSelectedItem("");
            return this._cmbx;
        }
        if (index == 1) {
            RadioButtonPanel panel = (RadioButtonPanel)super.buildComponent(mibVar, mibNode, index);
            JToggleButton[] buttons = panel.getButtons();
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i].addActionListener(this);
            }
            return panel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Interface:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            String ifName = this.getComponentText(index);
            if (ifName.length() == 0) {
                throw new Exception("Interface: invalid entry");
            }
            return new SnmpInt(this.getSelectedIfIndexIf().nameToIfIndex(ifName));
        }
        if (index == 2) {
            return new SnmpString((String)((JComboBox)this._values[index]).getSelectedItem());
        }
        return super.getComponentValue(index);
    }

    protected void refreshProfile() {
        this._cmbx.removeAllItems();
        HashMap profiles = SmIpProfileUtil.getInstance().getProfiles(this._profileType);
        Object[] strProfiles = new String[profiles.size()];
        int numProfiles = 0;
        for (String profile : profiles.keySet()) {
            strProfiles[numProfiles++] = profile;
        }
        Arrays.sort(strProfiles);
        for (int i = 0; i < strProfiles.length; ++i) {
            this._cmbx.addItem(strProfiles[i]);
        }
        this._cmbx.setSelectedItem("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block8: {
            try {
                String command = ((AbstractButton)e.getSource()).getText();
                if (command.equals(IP_INBOUND_V4) || command.equals(IP_OUTBOUND_V4)) {
                    this._profileType = 2;
                    this.refreshProfile();
                } else if (command.equals(IP_INBOUND_V6) || command.equals(IP_OUTBOUND_v6)) {
                    this._profileType = 3;
                    this.refreshProfile();
                } else {
                    super.actionPerformed(e);
                }
            }
            catch (Exception ex) {
                this._parent.setCursor(Cursor.getDefaultCursor());
                Util.errorMessage((Component)this._parent, ex);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            catch (Error ex) {
                this._parent.setCursor(Cursor.getDefaultCursor());
                Util.errorMessage((Component)this._parent, ex.getMessage());
                if (!SnmpSession.isTrace()) break block8;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

