/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import javax.swing.JToggleButton;

public class SmInsertIkePolicy
extends InsertForm {
    static final int DOI = 0;
    static final int PRIORITY = 1;
    static final int ENCRYPT = 2;
    static final int HASH = 3;
    static final int AUTH = 4;
    static final int DHGRP = 5;
    static final int LIFETIME = 5;
    static final int PRESHARED_KEY = 0;
    static final int RSA_KEY = 1;

    public SmInsertIkePolicy(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._labels[0].setVisible(false);
        this._values[0].setVisible(false);
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        this.updateAuth(peer);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                this.updateAuth(peer);
                return;
            }
        }
        super.actionPerformed(e);
    }

    void updateAuth(SnmpPeer peer) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isAbove3dot0 = sw.isVersionGreaterThanEqual("3.0(0)");
        GroupButtonPanel authGrp = (GroupButtonPanel)this._values[4];
        JToggleButton rsaBtn = authGrp.getButton(1);
        rsaBtn.setEnabled(isAbove3dot0);
    }
}

