/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;

public class SmInsertIpAddressIn
extends InsertForm {
    int _addrTypeIndex = 1;
    int _addrIndex = 2;
    int _addrType;
    protected String _addrTypeVar;
    protected int _supportedAddrType = 0;

    public SmInsertIpAddressIn(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._addrIndex) {
            SnmpInt var = (SnmpInt)super.getComponentValue(this._addrTypeIndex);
            this._addrType = var.getValue();
            String addr = this.getComponentText(this._addrIndex);
            if (addr.equals("")) {
                throw new Exception("Please provide a valid address.");
            }
            if (this._addrType == 1 || this._addrType == 2) {
                byte[] ipaddress = SnmpIpAddress.parse(addr);
                return new SnmpString(ipaddress);
            }
            return this.getDnsAddress(addr);
        }
        return super.getComponentValue(index);
    }

    protected SnmpVar getDnsAddress(String addr) throws NumberFormatException, Exception {
        if (this._supportedAddrType == 1) {
            return null;
        }
        this._addrType = 16;
        return new SnmpString(addr);
    }
}

