/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSetEditor;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmPortSetFieldPanel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JComponent;

public class SmInsertPortChannel
extends InsertForm {
    int _portMemIndex = this.getVarIndex("portChannelMemberList");
    int[] _portMemIfIndices;
    SmPortSetFieldPanel _portFieldPanel;

    public SmInsertPortChannel(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    public SnmpPeer[] getValidPeers() {
        SnmpPeer[] peers = super.getValidPeers();
        ArrayList<SnmpPeer> peersValid = new ArrayList<SnmpPeer>(this._peers.length);
        for (SnmpPeer peer : peers) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sw.isN5K()) continue;
            peersValid.add(peer);
        }
        this._peers = peersValid.toArray(new SnmpPeer[peersValid.size()]);
        return this._peers;
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._portFieldPanel.setNode((SnmpPeer)this._choice.getSelectedItem());
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this._portMemIndex) {
            PortEditorFilter psFilter = new PortEditorFilter(new int[]{22, 27, 39, 41, 44, 68}, new int[]{2}, 1);
            this._portFieldPanel = new SmPortSetFieldPanel(false, 15, psFilter);
            return this._portFieldPanel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._portMemIndex) {
            this._portMemIfIndices = SnmpIntList.parse(((FieldPanel)this._values[index]).getText(), this.getSelectedIfIndexIf());
            for (int i = 0; i < this._portMemIfIndices.length; ++i) {
                if (IfIndexUtil.getType(this._portMemIfIndices[i]) == 2) continue;
                throw new Exception("only gigE ports are allowed!");
            }
        }
        return super.getComponentValue(index);
    }

    @Override
    protected VarBindList buildInsertVarbind(int[] index, SnmpVar[] values) {
        VarBindList vbl = super.buildInsertVarbind(index, values);
        if (this._portMemIfIndices != null && this._portMemIfIndices.length != 0) {
            for (int i = 0; i < this._portMemIfIndices.length; ++i) {
                SnmpVarBind vbMemberAdminMode = new SnmpVarBind(new SnmpOID(MibNode.get("ifAdminStatus").getOid(), this._portMemIfIndices[i]), new SnmpInt(1));
                vbl.add(vbMemberAdminMode);
            }
        }
        return vbl;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                this._portFieldPanel.setNode(peer);
                this._portFieldPanel.setText("");
                return;
            }
        }
        super.actionPerformed(e);
    }

    @Override
    public void dispose() {
        PortSetEditor.getInstance(BrowserFrame.getInstance()).hideDlg();
    }
}

