/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpCrypto;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmRoleUtil;
import com.cisco.dcbu.sm.client.dialogs.SmUserTableModel;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Fabric;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class SmInsertUser
extends InsertForm {
    String _newuser;
    String _cloneuser;
    String _role;
    String _cloneAuthPswd;
    String _authPswd;
    String _cfmAuthPswd;
    String _clonePrivPswd;
    boolean _isPriv;
    String _privPswd;
    String _cfmprivPswd;
    final SnmpInt _CREATEANDGO = new SnmpInt(4);
    static final String[] _preConfiguredRoles = new String[]{"network-admin", "network-operator"};
    static final int[] _usmUserStatusOid = MibNode.get("usmUserStatus").getOid();
    static final int[] _sysOidOid = MibNode.get("sysObjectID").getOid();
    static final int[] _vacmGrpNameOid = MibNode.get("vacmGroupName").getOid();
    static final int[] USM_NO_PRIV_PROTOCOL = new int[]{1, 3, 6, 1, 6, 3, 10, 1, 2, 1};
    static final String[] _Labels = new String[]{"New User:", "Clone from Existing User:", "Role:", null, "Clone Password:", "Password:", "Confirm Password:", null, null, "My Privacy Password:", "Password:", "Confirm Password:"};
    static final String AUTH_PSWD_MISMATCH = "Auth Password does not match.";
    static final String PRIV_PSWD_MISMATCH = "Priv Password does not match.";
    static final String AUTH_PSWD_LEN_ERROR = "Auth Password needs to be at least 8 characters long.";
    static final String PRIV_PSWD_LEN_ERROR = "Priv Password needs to be at least 8 characters long.";
    static final String PRIV_CLONEPSWD_EMPTY_ERROR = "Clone Password is empty.";
    static final int NEW_USER = 0;
    static final int CLONE_USER = 1;
    static final int ROLE = 2;
    static final int AUTH_LINE = 3;
    static final int CLONE_AUTH_PSWD = 4;
    static final int AUTH_PSWD = 5;
    static final int CFM_AUTH_PSWD = 6;
    static final int PRIV_LINE = 7;
    static final int PRIV = 8;
    static final int CLONE_PRIV_PSWD = 9;
    static final int PRIV_PSWD = 10;
    static final int CFM_PRIV_PSWD = 11;
    static final int CLI_USER_NOTE = 12;
    static final int CHG_AUTH_PSWD = 1;
    static final int CHG_PRIV_PSWD = 2;
    InsertGrpRowCallback _insertGrpRowCallback = new InsertGrpRowCallback();
    DeleteUserRowCallback _deleteUserRowCallback = new DeleteUserRowCallback();
    Array _peersFailedVacmGrpInsert = new Array();
    HashMap _verifiedClonePswdPeers = new HashMap();

    public SmInsertUser(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        int i;
        this._mibNodes = new MibNode[this._vars.length];
        for (i = 0; i < this._vars.length; ++i) {
            this._mibNodes[i] = MibNode.get(this._vars[i]);
        }
        this._labels = new JLabel[_Labels.length];
        for (i = 0; i < this._labels.length; ++i) {
            if (_Labels[i] == null) continue;
            this._labels[i] = new JLabel(_Labels[i], 4);
        }
        this.BuildInsertComponents();
        this.setComponentVisibleAt(1, false);
        this.setComponentVisibleAt(4, false);
        this.layoutForm();
        this.addPeers();
        this.buildButtons();
    }

    void BuildInsertComponents() {
        this._values = new JComponent[_Labels.length];
        this._values[0] = new KTextField();
        this._values[1] = new KTextField();
        ClientController.getInstance().getFabric();
        SnmpPeer seed = Fabric.getReferencePeer();
        ((JTextField)this._values[1]).setText(seed.getUserName());
        HashMap roles = SmRoleUtil.getInstance().getRoles();
        String[] strRoles = new String[roles.size() + 2];
        int numRoles = 0;
        for (String role : roles.keySet()) {
            strRoles[numRoles++] = role;
        }
        strRoles[numRoles++] = _preConfiguredRoles[0];
        strRoles[numRoles++] = _preConfiguredRoles[1];
        JComboBox<String> cmbx = new JComboBox<String>(strRoles);
        cmbx.setEditable(true);
        cmbx.setSelectedItem("");
        this._values[2] = cmbx;
        this._values[3] = new DialogSeparator("Authentication");
        this._values[4] = new JPasswordField(20);
        ((JTextField)this._values[4]).setText(seed.getAuthPassword());
        this._values[5] = new JPasswordField(20);
        this._values[6] = new JPasswordField(20);
        this._values[7] = new DialogSeparator("Privacy");
        this._values[8] = new JCheckBox("Privacy", false);
        this._values[9] = new JPasswordField(20);
        ((JCheckBox)this._values[8]).addActionListener(this);
        this._values[10] = new JPasswordField(20);
        this._values[11] = new JPasswordField(20);
        this.setEnabled(9, false);
        this.setEnabled(10, false);
        this.setEnabled(11, false);
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        JPanel newBottomPanel = new JPanel(new BorderLayout());
        newBottomPanel.add((Component)this._buttonPanel, "South");
        newBottomPanel.add((Component)new JLabel("<html>Note: Users created via DCNM-SAN don't have a CLI password. <br>Use DM/CLI to create password.</html>"), "North");
        this._buttonPanel = newBottomPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            char ch = ((JCheckBox)e.getSource()).getActionCommand().charAt(0);
            boolean isSelected = ((JCheckBox)e.getSource()).isSelected();
            switch (ch) {
                case 'P': {
                    this.setEnabled(9, isSelected);
                    this.setEnabled(10, isSelected);
                    this.setEnabled(11, isSelected);
                }
            }
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        switch (index) {
            case 0: {
                this._newuser = ((JTextField)this._values[index]).getText();
                if (this._newuser.equals("")) {
                    throw new Exception("New User cannot be blank");
                }
                return new SnmpString(this._newuser);
            }
            case 1: {
                this._cloneuser = ((JTextField)this._values[index]).getText();
                if (this._cloneuser.equals("")) {
                    throw new Exception("Clone User cannot be blank");
                }
                return new SnmpString(this._cloneuser);
            }
            case 2: {
                this._role = (String)((JComboBox)this._values[index]).getSelectedItem();
                if (this._role.equals("")) {
                    throw new Exception("Role cannot be blank");
                }
                return new SnmpString(this._role);
            }
            case 4: {
                this._cloneAuthPswd = ((JTextComponent)this._values[index]).getText();
                return new SnmpString(this._cloneAuthPswd);
            }
            case 5: {
                this._authPswd = ((JTextComponent)this._values[index]).getText();
                return new SnmpString(this._authPswd);
            }
            case 6: {
                this._cfmAuthPswd = ((JTextComponent)this._values[index]).getText();
                return new SnmpString(this._cfmAuthPswd);
            }
            case 9: {
                this._clonePrivPswd = ((JTextComponent)this._values[index]).getText();
                return new SnmpString(this._clonePrivPswd);
            }
            case 10: {
                this._privPswd = ((JTextComponent)this._values[index]).getText();
                return new SnmpString(this._privPswd);
            }
            case 11: {
                this._cfmprivPswd = ((JTextComponent)this._values[index]).getText();
                return new SnmpString(this._cfmprivPswd);
            }
            case 8: {
                this._isPriv = ((JCheckBox)this._values[index]).isSelected();
                return null;
            }
        }
        return null;
    }

    @Override
    protected void insert() throws Exception {
        this.insertInit();
        this.getInsertValue();
        this.checkConfirmPassWord();
        if (this._isPriv && this._clonePrivPswd != null) {
            this.checkClonePrivPassWord();
        }
        this._firstOid = this._mibNodes[0].getOid();
        this._successfulSets = 0;
        this._pending = this._selPeerList.length;
        for (int i = 0; i < this._selPeerList.length; ++i) {
            SnmpPeer peer = (SnmpPeer)this._selPeerList[i];
            byte[] engineId = peer.getEngineId();
            int[] index = SmUserTableModel.getUserIndex(engineId, this._newuser);
            VarBindList vbl = this.buildInsertNewUserVarbind(peer, index, engineId);
            SnmpPDU pdu = new SnmpPDU(-93, vbl);
            peer.send(pdu, this);
        }
        if (this._selPeerList.length != 0) {
            this.wait(this._peers);
        }
        if (this._successfulSets < this._selPeerList.length) {
            if (this._successfulSets == 0) {
                this._insertErrMsg.addElement("Failed on usmUserTable creation");
            } else if (this._successfulSets < this._selPeerList.length) {
                int failedSets = this._selPeerList.length - this._successfulSets;
                this._insertErrMsg.addElement("Failed on " + failedSets + " of " + this._selPeerList.length + " device(s) on usmUserTable creation.");
            }
        }
        this.insertGrpRow();
    }

    protected void insertGrpRow() throws Exception {
        this._peersFailedVacmGrpInsert.clear();
        this._successfulSets = 0;
        this._pending = this._selPeerList.length - this._insertErrPeers.size();
        this._firstOid = _vacmGrpNameOid;
        int nPeersGrp = 0;
        for (int i = 0; i < this._selPeerList.length; ++i) {
            SnmpPeer peer = (SnmpPeer)this._selPeerList[i];
            if (this._insertErrPeers.get(peer) != null) continue;
            VarBindList vbl = this.buildInsertNewVacmVarbind();
            SnmpPDU pdu = new SnmpPDU(-93, vbl);
            ++nPeersGrp;
            peer.send(pdu, this);
        }
        if (nPeersGrp != 0) {
            this.wait(this._peers);
        }
        if (this._peersFailedVacmGrpInsert.size() != 0) {
            int i;
            int[] indices = new int[this._peersFailedVacmGrpInsert.size()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)this._peersFailedVacmGrpInsert.elementAt(i);
            }
            Arrays.sort(indices);
            for (i = indices.length - 1; i >= 0; --i) {
                this._table.getData().removeElementAt(indices[i]);
            }
        }
        if (this._successfulSets < nPeersGrp) {
            if (this._successfulSets == 0) {
                this._insertErrMsg.addElement("Failed on vacmSecurityToGroupTable creation");
            } else if (this._successfulSets < this._selPeerList.length) {
                int failedSets = this._selPeerList.length - this._successfulSets;
                this._insertErrMsg.addElement("Failed on " + failedSets + " of " + this._selPeerList.length + " device(s) on vacmSecurityToGroupTable creation.");
            }
        }
    }

    protected VarBindList buildInsertNewUserVarbind(SnmpPeer peer, int[] index, byte[] engineId) {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(_usmUserStatusOid, index), this._CREATEANDGO));
        int[] usmUserSecurityName = MibNode.get("usmUserSecurityName").getOid();
        int[] cloneId = new int[usmUserSecurityName.length + engineId.length + this._cloneuser.length() + 2];
        System.arraycopy(usmUserSecurityName, 0, cloneId, 0, usmUserSecurityName.length);
        System.arraycopy(index, 0, cloneId, usmUserSecurityName.length, engineId.length + 1);
        int cloneIdPos = usmUserSecurityName.length + (engineId.length + 1);
        cloneId[cloneIdPos] = this._cloneuser.length();
        ++cloneIdPos;
        int j = 0;
        while (j < this._cloneuser.length()) {
            cloneId[cloneIdPos] = this._cloneuser.charAt(j);
            ++j;
            ++cloneIdPos;
        }
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("usmUserCloneFrom").getOid(), index), new SnmpOID(cloneId)));
        SnmpVarBind vb = SmInsertUser.buildUSMUserPassword(peer, index, engineId, 1, this._cloneAuthPswd, this._authPswd, null, null);
        vbl.add(vb);
        if (this._isPriv) {
            vb = SmInsertUser.buildUSMUserPassword(peer, index, engineId, 2, null, null, this._clonePrivPswd, this._privPswd);
            vbl.add(vb);
        } else {
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("usmUserPrivProtocol").getOid(), index), new SnmpOID(USM_NO_PRIV_PROTOCOL)));
        }
        return vbl;
    }

    public static SnmpVarBind buildUSMUserPassword(SnmpPeer peer, int[] index, byte[] engineId, int chgAuthPrivFlag, String cloneAuthPwd, String authPassword, String clonePrivPwd, String privPassword) {
        if (chgAuthPrivFlag == 1) {
            byte[] keyChange = SnmpCrypto.getKeyChange(cloneAuthPwd, authPassword, engineId, peer.getAuthProtocol());
            return new SnmpVarBind(new SnmpOID(MibNode.get("usmUserAuthKeyChange").getOid(), index), new SnmpString(keyChange));
        }
        if (chgAuthPrivFlag == 2) {
            byte[] keyChange = SnmpCrypto.getKeyChange(clonePrivPwd, privPassword, engineId, peer.getAuthProtocol());
            return new SnmpVarBind(new SnmpOID(MibNode.get("usmUserPrivKeyChange").getOid(), index), new SnmpString(keyChange));
        }
        return null;
    }

    protected VarBindList buildInsertNewVacmVarbind() {
        VarBindList vbl = new VarBindList();
        int[] index = new int[this._newuser.length() + 2];
        index[0] = 3;
        index[1] = this._newuser.length();
        int indexPos = 2;
        int j = 0;
        while (j < this._newuser.length()) {
            index[indexPos] = this._newuser.charAt(j);
            ++j;
            ++indexPos;
        }
        vbl.add(new SnmpVarBind(new SnmpOID(_vacmGrpNameOid, index), new SnmpString(this._role)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("vacmSecurityToGroupStatus").getOid(), index), this._CREATEANDGO));
        return vbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        SnmpOID firstOid = pdu.getVariables().getVb(0).getOid();
        if (firstOid.startsWith(_sysOidOid)) {
            this.processClonePswdCheck(node, reqid, pdu, timedOut);
            return;
        }
        if (!firstOid.startsWith(_vacmGrpNameOid)) {
            super.callback(session, reqid, pdu, timedOut);
            return;
        }
        --this._pending;
        if (!timedOut && pdu.getError() == 0) {
            ++this._successfulSets;
            SnmpVarBind vb = pdu.getVariables().getVb(0);
            int[] oid = vb.getOid().getValue();
            int[] index = new int[oid.length - this._firstOid.length];
            System.arraycopy(oid, this._firstOid.length, index, 0, oid.length - this._firstOid.length);
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(_vacmGrpNameOid, index)));
            SnmpPDU getPdu = new SnmpPDU(-96, vbl);
            ++this._pending;
            try {
                node.send(getPdu, this._insertGrpRowCallback);
            }
            catch (SnmpException ex) {}
        } else {
            this.processInsertError(node, pdu, timedOut);
            Integer tableRowN = (Integer)this._peer2InsertRowIndex.get(node);
            if (tableRowN != null) {
                int rowIndex = tableRowN;
                Object[] row = (Object[])this._table.getData().elementAt(rowIndex);
                SnmpOID indexOID = (SnmpOID)row[1];
                SnmpPDU delPdu = new SnmpPDU(-93, new VarBindList());
                delPdu.addVar(new SnmpOID(_usmUserStatusOid, indexOID.getValue()), new SnmpInt(6));
                try {
                    ++this._pending;
                    node.send(delPdu, this._deleteUserRowCallback);
                }
                catch (SnmpException ex) {
                    DefaultLogger._DefLogger.error((Object)(node + ": UserTableRollback failed : " + ex.getMessage()));
                }
                this._peersFailedVacmGrpInsert.addElement(tableRowN);
            }
            if (this._pending <= 0) {
                try {
                    SnmpPeer[] rowIndex = this._peers;
                    synchronized (this._peers) {
                        this._peers.notifyAll();
                        // ** MonitorExit[rowIndex] (shouldn't be in output)
                    }
                }
                catch (IllegalMonitorStateException ex) {
                    DefaultLogger._DefLogger.error((Object)ex);
                }
            }
        }
        {
            return;
        }
    }

    @Override
    protected void processInsertError(SnmpPeer peer, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut && pdu.getErrorIndex() > 0) {
            int[] oid = pdu.getVariables().getVb(pdu.getErrorIndex() - 1).getOid().getValue();
            String errMib = MibNode.oidToName(oid);
            if (pdu.getError() == 14 && errMib.startsWith("usmUserPrivKeyChange")) {
                this._insertErrPeers.put(peer, peer);
                String err = peer + ": SnmpException: Clone Privacy Password non-existing or incorrect";
                this._insertErrMsg.addElement(err);
                return;
            }
        }
        super.processInsertError(peer, pdu, timedOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertGrpRowCallback(SnmpPDU pdu, boolean timedOut) {
        SnmpPeer[] vb;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        --this._pending;
        if (!timedOut && pdu.getError() == 0) {
            vb = pdu.getVariables().getVb(0);
            SnmpString grpName = (SnmpString)vb.getVar();
            int rowIndex = (Integer)this._peer2InsertRowIndex.get(node);
            Object[] row = (Object[])this._table.getData().elementAt(rowIndex);
            Object object = row[2] = grpName.getType() != 5 ? grpName : null;
        }
        if (this._pending <= 0) {
            try {
                vb = this._peers;
                synchronized (this._peers) {
                    this._peers.notifyAll();
                    // ** MonitorExit[vb] (shouldn't be in output)
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
        {
            return;
        }
    }

    void checkConfirmPassWord() throws Exception {
        if (this._authPswd.length() < 8) {
            throw new Exception(AUTH_PSWD_LEN_ERROR);
        }
        if (!this._authPswd.equals(this._cfmAuthPswd)) {
            DefaultLogger._DefLogger.debug((Object)("Auth is " + this._authPswd));
            DefaultLogger._DefLogger.debug((Object)("_cfmAuthPswd is " + this._cfmAuthPswd));
            throw new Exception(AUTH_PSWD_MISMATCH);
        }
        if (this._isPriv) {
            if (this._clonePrivPswd == null || this._clonePrivPswd.length() == 0) {
                throw new Exception(PRIV_CLONEPSWD_EMPTY_ERROR);
            }
            if (this._privPswd.length() < 8) {
                throw new Exception(PRIV_PSWD_LEN_ERROR);
            }
            if (!this._privPswd.equals(this._cfmprivPswd)) {
                throw new Exception(PRIV_PSWD_MISMATCH);
            }
        }
    }

    void checkClonePrivPassWord() throws Exception {
        this._pending = this._selPeerList.length;
        this._verifiedClonePswdPeers.clear();
        HashMap<SnmpPeer, String> peer2PrivPswd = new HashMap<SnmpPeer, String>();
        HashMap<SnmpPeer, byte[]> peer2PrivKey = new HashMap<SnmpPeer, byte[]>();
        for (int i = 0; i < this._selPeerList.length; ++i) {
            SnmpPeer peer = (SnmpPeer)this._selPeerList[i];
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
            pdu.addNull(new SnmpOID(_sysOidOid, 0));
            String privPswd = peer.getPrivPassword();
            byte[] privKey = peer.getPrivKey();
            peer2PrivPswd.put(peer, privPswd);
            peer2PrivKey.put(peer, privKey);
            peer.setPrivPassword(this._clonePrivPswd);
            peer.calcLocalizedKey();
            peer.send(pdu, this);
        }
        if (this._selPeerList.length != 0) {
            this.wait(this._peers);
            for (SnmpPeer peer : peer2PrivPswd.keySet()) {
                String privPswd = (String)peer2PrivPswd.get(peer);
                byte[] privKey = (byte[])peer2PrivKey.get(peer);
                peer.setPrivPassword(privPswd);
                peer.setPrivKey(privKey);
            }
            if (this._verifiedClonePswdPeers.size() != this._selPeerList.length) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this._selPeerList.length; ++i) {
                    if (this._verifiedClonePswdPeers.get(this._selPeerList[i]) != null) continue;
                    sb.append(this._selPeerList[i]);
                    sb.append('\n');
                }
                throw new Exception("Invalid or unable to verify(due to timeout) Clone Password for the following Swithches:\n" + sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processClonePswdCheck(SnmpPeer peer, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut && pdu.getError() == 0) {
            this._verifiedClonePswdPeers.put(peer, peer);
        }
        --this._pending;
        if (this._pending <= 0) {
            try {
                SnmpPeer[] snmpPeerArray = this._peers;
                synchronized (this._peers) {
                    this._peers.notifyAll();
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
        {
            return;
        }
    }

    @Override
    protected SnmpVar[] getInsertValue() throws Exception {
        SnmpVar[] values = new SnmpVar[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            if (!this._values[i].isEnabled()) continue;
            values[i] = this.getComponentValue(i);
        }
        return values;
    }

    class DeleteUserRowCallback
    implements SnmpCallbackIf {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
            SmInsertUser.this._pending--;
            if (SmInsertUser.this._pending <= 0) {
                try {
                    SnmpPeer[] snmpPeerArray = SmInsertUser.this._peers;
                    synchronized (snmpPeerArray) {
                        SmInsertUser.this._peers.notifyAll();
                    }
                }
                catch (IllegalMonitorStateException ex) {
                    DefaultLogger._DefLogger.error((Object)ex);
                }
            }
        }
    }

    class InsertGrpRowCallback
    implements SnmpCallbackIf {
        @Override
        public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
            SmInsertUser.this.insertGrpRowCallback(pdu, timedOut);
        }
    }
}

