/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSetCellCallbackIf;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.vsif.VSifObj;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmFcInterfaceTableModel;
import com.cisco.dcbu.sm.client.dialogs.SmVFCifGeneralTableModel;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmPortSetFieldPanel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class SmInsertVirtualInterface
extends InsertForm
implements PortSetCellCallbackIf,
ItemListener {
    static final int VSIF_INDEX = 0;
    static final int BIND_TYPE_INDEX = 1;
    static final int BIND_IF_INDEX = 2;
    static final int BIND_MAC_INDEX = 3;
    int vsifType = 56;
    SmPortSetFieldPanel _portFieldPanel;
    RadioButtonPanel _bindTypePanel;
    JFormattedTextField _bindMacTF;

    public SmInsertVirtualInterface(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
        if (table instanceof SmFcInterfaceTableModel) {
            this.vsifType = 56;
        }
        try {
            this._bindMacTF = new JFormattedTextField();
            this._bindMacTF.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("HH:HH:HH:HH:HH:HH")));
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    @Override
    protected int[] getTableFirstOid() {
        return this._table.getFirstOid();
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this.switchSelectionChanged();
        this.bindTypeChanged();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
    }

    private void switchSelectionChanged() {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        this._portFieldPanel.setNode(peer);
        this._portFieldPanel.setText("");
    }

    private void bindTypeChanged() {
        if (this._bindTypePanel.getSelected() == 0) {
            this._portFieldPanel.setEnabled(true);
            this._bindMacTF.setEnabled(false);
            this._bindMacTF.setValue(new SnmpString("00:00:00:00:00:00"));
        } else {
            this._portFieldPanel.setEnabled(false);
            this._bindMacTF.setEnabled(true);
            this._portFieldPanel.setText("");
        }
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        JComponent comp = super.buildComponent(mibVar, mibNode, index);
        if (index == 0) {
            int width = this.getWidth(mibVar, mibNode, mibNode.getTCLabel());
            return new FieldPanel(width, mibNode.getLo(), VSifObj.getMaxVSifId(56), (String)SnmpTableModel._Units.get(mibVar));
        }
        if (index == 1) {
            this._bindTypePanel = (RadioButtonPanel)comp;
            this._bindTypePanel.addChangeListener(this);
        } else {
            if (index == 2) {
                PortEditorFilter psFilter = new PortEditorFilter(FRUConstants.getAllFCoECapableCardTypes(), new int[]{26, 31});
                this._portFieldPanel = new SmPortSetFieldPanel(true, true, 15, psFilter);
                this._portFieldPanel.setCellCallBack(this);
                return this._portFieldPanel;
            }
            if (index == 3) {
                return this._bindMacTF;
            }
        }
        return comp;
    }

    @Override
    public boolean PortSetCellCB(int card, int port) {
        try {
            this.getSelectedPeers();
            Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[0]).getAddress());
            int ifIndex = sw.nameToIfIndex(card, port, sw.getActualType(26));
            return ((SmVFCifGeneralTableModel)this._table).validateSpeed((SnmpPeer)this._selPeerList[0], ifIndex);
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    protected SnmpVar getComponentValue(int pIndex) throws Exception {
        if (pIndex == 2) {
            String ifName = this._portFieldPanel.getText().trim();
            if (ifName.equals("")) {
                return null;
            }
            Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[0]).getAddress());
            int ifIndex = sw.nameToIfIndex(ifName);
            if (!((SmVFCifGeneralTableModel)this._table).validateSpeed((SnmpPeer)this._selPeerList[0], ifIndex)) {
                throw new Exception("The Bound Ethernet Interface : <" + ifName + "> is not running at 10G+.\n" + "Please select a 10G+ Ethernet Interface.");
            }
            return new SnmpInt(ifIndex);
        }
        return super.getComponentValue(pIndex);
    }

    @Override
    protected MibEnum[] getApplicableEnums(MibNode mibNode) {
        if (MibNode.equals(VSifObj.VSIF_TYPE_MIB_NODE.getOid(), mibNode.getOid()) == 0) {
            return VSifObj.getApplicableVsifTypeEnums();
        }
        return super.getApplicableEnums(mibNode);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this.switchSelectionChanged();
                return;
            }
        }
        super.actionPerformed(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.bindTypeChanged();
    }

    public int getMatchedMibEnumIndex(MibNode pMibNode, int pVSifType) {
        MibEnum[] enums = this.getApplicableEnums(pMibNode);
        for (int i = 0; i < enums.length; ++i) {
            if (enums[i].getValue() != pVSifType) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] pValues) {
        int vsifId = 0;
        vsifId = (int)((SnmpUnsignedInt)pValues[0]).getValue();
        return IfIndexUtil.vfcIndexToVfcTableIndex(vsifId);
    }

    @Override
    protected int[] getTableIndex(int[] index) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[0]).getAddress());
        int vsifIfIndex = IfIndexUtil.vfcTableIndexToIfIndex(index, sw);
        return new int[]{vsifIfIndex};
    }

    @Override
    protected void insertAction() throws Exception {
        super.insertAction();
        if (this._insertErrMsg.size() == 0) {
            int index = Integer.parseInt(this.getComponentText(0));
            this.setComponentText(0, index < this._mibNodes[0].getHi() ? Integer.toString(index + 1) : "");
            this.setComponentText(2, "");
            this.setComponentText(3, "");
        }
    }
}

