/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmIpFcTableModel
extends SmTableModel {
    static final int ADDR_COL = 7;
    static final int[] _ipPrefixOid = MibNode.get("ciiIPIfAddressPrefixLength").getOid();

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        if (var.startsWith("ciiIPIfAddressPrefixLength")) {
            int[] addrId = vbl.getVb(indexOfVbl + 7 - this._offset).getOid().getValue();
            int ifIndex = index.getValue()[0];
            if (SnmpOID.startsWith(addrId, _ipPrefixOid)) {
                int addrIfIndex = addrId[addrId.length - 7];
                if (ifIndex == addrIfIndex) {
                    SnmpOID ip = new SnmpOID(addrId, addrId.length - 4, 4);
                    SnmpVar v = vb.getVar();
                    return new SnmpString(ip.toString() + "/" + v.toString());
                }
                addrId[addrId.length - 7] = ifIndex;
                return new SnmpString("n/a");
            }
            return new SnmpString("n/a");
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    @Override
    protected boolean isEnd(SnmpPeer peer, int[] req, SnmpVarBind vb, int[] index, int reqId) {
        boolean isEnd = super.isEnd(peer, req, vb, index, reqId);
        if (!isEnd) {
            return IfIndexUtil.getType(index[0]) != 8;
        }
        return isEnd;
    }

    @Override
    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        Object[] row = (Object[])this.getData().elementAt(rowN);
        SnmpPeer peer = (SnmpPeer)row[0];
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        int processorId = sw.getSupProcessorId();
        int vsanId = this.getIndex(rowN)[0] - 0x8F80000;
        int[] index = new int[]{processorId, 1, vsanId};
        pdu.addVar(new SnmpOID(this.getRowStatus(), index), new SnmpInt(this.getDeleteValue()));
        return pdu;
    }

    @Override
    public SnmpPDU buildGetPdu(SnmpPeer node, int[] index) {
        VarBindList vbl = this.buildGetVbl(node, index);
        SnmpPDU pdu = new SnmpPDU(-95, vbl);
        return pdu;
    }

    @Override
    public VarBindList buildGetVbl(VarBindList vbl, SnmpPeer node, int[] index) {
        int ifIndex = index[0];
        for (int i = this._offset; i < this._mibNodes.length; ++i) {
            if (i != 7) {
                vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[i].getOid(), ifIndex - 1)));
                continue;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[i].getOid(), ifIndex)));
        }
        return vbl;
    }

    @Override
    protected void fetchTableCols(SnmpFetch f, SnmpPeer peer, VarBindList vbl) throws SnmpException {
        f.getNext(peer, vbl, this);
    }
}

