/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.util.HashMap;

public class SmIscsiSessionConnTableModel
extends SmTableModel {
    HashMap _peers2RowData = new HashMap();
    private int _sessionAttriTableIndexStart = 0;
    private String _initTargetHeader;
    public static final int INIT_TARGET_COL = 2;
    static final int[] _cIscsiSsnInitiatorNameOid = MibNode.get("cIscsiSsnInitiatorName").getOid();
    static final int[] _cIscsiSsnTargetNameOid = MibNode.get("cIscsiSsnTargetName").getOid();

    public SmIscsiSessionConnTableModel(int sessionAttriTableIndexStart, String initTargetHeader) {
        this._sessionAttriTableIndexStart = sessionAttriTableIndexStart;
        this._initTargetHeader = initTargetHeader;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset + 1);
        String[] headers = this.getHeaders();
        headers[2] = this._initTargetHeader;
        this.setHeaders(headers);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peers2RowData.clear();
        super.getTableVars(nodes);
        if (this._peers2RowData.size() != 0) {
            this.getSessionNames();
        }
        return this._responseData;
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        row[2] = "n/a";
        Array<Object[]> row2Datas = (Array<Object[]>)this._peers2RowData.get(node);
        if (row2Datas == null) {
            row2Datas = new Array<Object[]>();
            this._peers2RowData.put(node, row2Datas);
        }
        row2Datas.addElement(row);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getSessionNames() throws SnmpException {
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowData.keySet()) {
                Array rowDatas = (Array)this._peers2RowData.get(peer);
                VarBindList vbl = new VarBindList();
                for (int i = 0; i < rowDatas.size(); ++i) {
                    Object[] row = (Object[])rowDatas.elementAt(i);
                    int[] indexOid = ((SnmpOID)row[1]).getValue();
                    int[] sessionIndex = new int[]{indexOid[this._sessionAttriTableIndexStart], indexOid[this._sessionAttriTableIndexStart + 1], indexOid[this._sessionAttriTableIndexStart + 2]};
                    vbl.add(new SnmpVarBind(new SnmpOID(_cIscsiSsnInitiatorNameOid, sessionIndex)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cIscsiSsnTargetNameOid, sessionIndex)));
                }
                SnmpFetch f = new SnmpFetch();
                f.get(peer, vbl, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            if (!((SnmpOID)firstOid).startsWith(_cIscsiSsnInitiatorNameOid)) {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            this.fillSessionNames(node, pdu.getVariables());
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    void fillSessionNames(SnmpPeer node, VarBindList vbl) {
        Array row2Datas = (Array)this._peers2RowData.get(node);
        if (row2Datas == null) {
            return;
        }
        int i = 0;
        int j = 0;
        while (i < vbl.size()) {
            SnmpVarBind vb = vbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            Object[] row = (Object[])row2Datas.elementAt(j);
            if (row != null) {
                this.fillInitTargetInfo(row, vbl.stringValue(i), vbl.stringValue(i + 1));
            }
            i += 2;
            ++j;
        }
    }

    protected void fillInitTargetInfo(Object[] row, String init, String target) {
        row[2] = init + "," + target;
    }
}

