/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;

public class SmIvrActionTableModel
extends SmTableModel {
    static final int ISACTIVE = 2;
    static final int NAT_COL = 4;
    static final int AUTOTOPO_COL = 5;

    @Override
    public boolean applyChangesAction() throws Exception {
        boolean result = super.applyChangesAction();
        if (result) {
            BrowserFrame.getDataView().refresh();
        }
        return result;
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        SnmpVar activeVar;
        if (col == 2 && (activeVar = vb.getVar()).getType() == 2 && ((SnmpInt)activeVar).getValue() == 1) {
            return vbl.intValue(4) == 1 ? "Auto Configured" : "User Configured";
        }
        return super.toCell(mibNode, vb.getVar(), var, row);
    }

    @Override
    public boolean isCellActive(int row, int col) {
        SnmpPeer peer = this.getRowPeer(row);
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (!(col != 5 && col != 4 || sw != null && sw.isVersionGreaterThanEqual("2.1(0)"))) {
            return false;
        }
        return super.isCellActive(row, col);
    }

    @Override
    protected SnmpPeer[] getWrkingPeers() {
        this._wrkingPeers = super.getWrkingPeers();
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        if (this._wrkingPeers != null) {
            for (int i = 0; i < this._wrkingPeers.length; ++i) {
                Switch sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(this._wrkingPeers[i].getAddress());
                if (sw == null || !sw.isManageable() || !sw.isIvrEnabled()) continue;
                peers.add(this._wrkingPeers[i]);
            }
        }
        this._wrkingPeers = peers.toArray(new SnmpPeer[peers.size()]);
        return this._wrkingPeers;
    }
}

