/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SmIvrEnfZoneTableModel
extends SmTableModel
implements ActionListener {
    static final String[] LABELS = new String[]{"VSAN Id", "Zone", "Type", "Fabric Id", "Switch Interface", "Name", "WWN", "FcId", "LUNs", "Status"};
    String _zoneName;
    static final int VSANID = 0;
    static final int ZONE = 1;
    static final int TYPE = 2;
    static final int FABRIC_ID = 3;
    static final int SWITCHPORT = 4;
    static final int NAME = 5;
    static final int PWWN = 6;
    static final int FCID = 7;
    static final int LUN = 8;
    static final int INFO = 9;
    private int _regionId = -1;

    public SmIvrEnfZoneTableModel(String zone, int regionId) {
        this._zoneName = zone;
        this._regionId = regionId;
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._prefixes = prefixes;
        this.setHeaders(LABELS);
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = new Array();
        Fabric fa = ClientController.getInstance().getFabric();
        try {
            EnforcedZone[] zones = fa.getIvrEnforcedZones(this._regionId);
            if (zones == null) {
                return this._responseData;
            }
            for (int i = 0; i < zones.length; ++i) {
                EnforcedZone zn = zones[i];
                if (this._zoneName != null && !this._zoneName.equals(zn.toString())) continue;
                String zoneName = zn.getName();
                Array mem = zn.getMembers();
                int maxj = mem.size();
                for (int j = 0; j < maxj; ++j) {
                    EnforcedZoneMember zmem = (EnforcedZoneMember)mem.elementAt(j);
                    this.addRow(zmem.getEndPort(fa), zoneName, zmem);
                }
            }
        }
        catch (Exception ex) {
            throw new SnmpException(ex.getMessage());
        }
        return this._responseData;
    }

    private void addRow(EndPort p, String zoneName, EnforcedZoneMember zmem) {
        Object[] row = new Object[LABELS.length];
        row[1] = zoneName;
        row[5] = p != null ? p : zmem.getName(p, null);
        Wwn pWWN = zmem.getPortWWN(p);
        row[6] = pWWN != null ? SnmpString.toHexString(zmem.getPortWWN(p).getValue()) : "";
        row[3] = Integer.toString(zmem.getAfId());
        row[7] = zmem.getFcid(p);
        row[4] = EnforcedZoneMember.getSwitchPort(p, zmem.getType(), zmem.getId(), this.getIvrVsan(p, zmem));
        row[2] = zmem.getConType();
        row[0] = Short.toString(zmem.getIvrVsanId());
        row[8] = zmem.getLun();
        row[9] = EnforcedZoneMember.getInfo(p, zmem.getIvrVsanId(), zmem.getType());
        this._responseData.addElement(row);
    }

    private Vsan getIvrVsan(EndPort endPort, EnforcedZoneMember zmem) {
        Vsan prtVsan = null;
        if (endPort != null && endPort.getSwitch() != null) {
            prtVsan = endPort.getSwitch().getVsan(zmem.getIvrVsanId());
            if (prtVsan == null) {
                prtVsan = endPort.getFirstVsan();
            }
        } else if (endPort != null) {
            prtVsan = endPort.getFirstVsan();
        }
        return prtVsan;
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        this.mapSelectDevice(table);
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[5];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIControls.getInstance().actionPerformed(e);
    }
}

