/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmFeatureControlTableModel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;

public class SmNpvFeatureControlTableModel
extends SmFeatureControlTableModel {
    private boolean _isCore;

    public SmNpvFeatureControlTableModel(int[][] ownerIndcies, boolean isCore) {
        super(ownerIndcies, 3000);
        this._isCore = isCore;
    }

    @Override
    protected SnmpPeer[] getWrkingPeers(SnmpPeer[] peers) {
        SnmpPeer[] wkPeers = super.getWrkingPeers(peers);
        ArrayList<SnmpPeer> peersValid = new ArrayList<SnmpPeer>(wkPeers.length);
        for (int i = 0; i < wkPeers.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(wkPeers[i].getAddress());
            if ((this._isCore || !sw.isParadise() && !sw.isN5K()) && !this._isCore) continue;
            peersValid.add(wkPeers[i]);
        }
        this._wrkingPeers = peersValid.toArray(new SnmpPeer[peersValid.size()]);
        return this.getFeatureCtrlPeers(this._wrkingPeers);
    }

    @Override
    protected void setSpecialAttr() {
        if (this._isCore) {
            return;
        }
        SmTableModel.SmTableModelCellChecker[] checkers = new SmTableModel.SmTableModelCellChecker[2];
        String mibName = "cfcFeatureCtrlAction";
        String warningMsg1 = "<html>Changing to npv mode erases the current configuration and reboots the switch in npv mode.<p>Do you want to continue?</html>";
        String warningMsg2 = "<html>Disabling npv mode erases the current configuration and reboots the switch in non-npv mode.<p>Do you want to continue?</html>";
        checkers[0] = new SmTableModel.SmTableModelCellChecker(this, mibName, new int[]{2}, warningMsg1);
        checkers[1] = new SmTableModel.SmTableModelCellChecker(this, mibName, new int[]{3}, warningMsg2);
        this.setCellChecker(checkers);
    }
}

