/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.ISLCellIf;
import com.cisco.dcbu.sm.client.dialogs.IslData;
import com.cisco.dcbu.sm.client.dialogs.SmMultiIndexedTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class SmPreferredPathTableModel
extends SmMultiIndexedTableModel
implements ISLCellIf {
    public static final int INDEX1_COL = 2;
    public static final int INDEX2_COL = 3;
    public static final int INDEX3_COL = 4;
    public static final int PRI_ISL_COL = 5;
    public static final int SEC_ISL_COL = 6;
    public static final int PRI_ISL_VAR = 3;
    public static final int SEC_ISL_VAR = 4;
    protected Vsan _vsan;
    protected int _vsanId;
    private HashMap _peerIslMap;
    int node_count = 0;

    public SmPreferredPathTableModel(Vsan vsan) {
        this._vsan = vsan;
        if (this._vsan != null) {
            this._vsanId = this._vsan.getId();
        }
        this._peerIslMap = new HashMap();
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peerIslMap.clear();
        return super.getTableVars(nodes);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = new Object[vbl.size() + 3];
        this._responseData.addElement(row);
        int[] indexValue = index.getValue();
        row[0] = node;
        row[1] = index;
        row[2] = ClientController.findFabricSwitchByIpAddress(node.getAddress()).ifIndexToName(indexValue[1]);
        row[3] = indexValue[0];
        row[4] = "0x" + SnmpString.toHexString(indexValue, 2, 3, false) + "(" + indexValue[2] + ")";
        row[5] = new SnmpString(ClientController.findFabricSwitchByIpAddress(node.getAddress()).ifIndexToName(vbl.intValue(3)));
        row[6] = new SnmpString(ClientController.findFabricSwitchByIpAddress(node.getAddress()).ifIndexToName(vbl.intValue(4)));
        Switch srcSwitch = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        Switch destSwitch = ClientController.findFabricSwitchByVsanDomainId(this._vsanId, indexValue[2]);
        String srcKey = String.valueOf(srcSwitch.getWwn());
        if (destSwitch != null) {
            String destKey = String.valueOf(destSwitch.getWwn());
            String key = srcKey + "_" + destKey;
            if (this._peerIslMap.get(key) == null) {
                ArrayList<IslData> islList = new ArrayList<IslData>();
                this.getIslList(srcSwitch, destSwitch, this._vsan, true, islList);
                this._peerIslMap.put(key, islList);
            }
        }
        if (row == null) {
            return row;
        }
        return row;
    }

    @Override
    public HashMap getPeerISLs() {
        return this._peerIslMap;
    }

    public void getIslList(Switch srcSwitch, Switch destSwitch, Vsan vsan, boolean directConn, ArrayList<IslData> islList) {
        if (islList == null) {
            islList = new ArrayList();
        }
        ArrayList<Isl> vsanIsl = new ArrayList<Isl>();
        vsan.getIsls(vsanIsl);
        if (vsanIsl.size() <= 0) {
            return;
        }
        islList.clear();
        for (Isl isl : vsanIsl) {
            if (!SmPreferredPathTableModel.isIslInScope(isl, srcSwitch, destSwitch, directConn)) continue;
            IslData islData = new IslData(isl, srcSwitch);
            islList.add(islData);
            List<Isl> children = isl.getPCMemberLinksAsIsls();
            if (children == null) continue;
            for (Isl child : children) {
                islData = new IslData(child, srcSwitch);
                islList.add(islData);
            }
        }
    }

    public static boolean isIslInScope(Isl isl, Switch srcSwitch, Switch destSwitch, boolean directConn) {
        boolean result = false;
        if (isl == null || srcSwitch == null || destSwitch == null) {
            return result;
        }
        Switch sw1 = isl.getSwitch1();
        Switch sw2 = isl.getSwitch2();
        if (!directConn) {
            if (srcSwitch.equals(sw1) || srcSwitch.equals(sw2)) {
                result = true;
            }
        } else if ((srcSwitch.equals(sw1) || srcSwitch.equals(sw2)) && (destSwitch.equals(sw1) || destSwitch.equals(sw2))) {
            result = true;
        }
        return result;
    }

    public int getVsanId() {
        return this._vsanId;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 5 || col == 6;
    }

    @Override
    public boolean deleteRowsAction(int[] rows) throws Exception {
        Object[] options = new Object[]{"Continue", "Cancel"};
        if (JOptionPane.showOptionDialog(BrowserFrame.getInstance(), "<html>Delete a preferred path may interrupt traffic.<p>Do you want to continue?</html>", "DCNM-SAN", -1, 2, null, options, options[0]) == 1) {
            return false;
        }
        return super.deleteRowsAction(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback_test(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        this.processCallback(node, session, reqid, pdu, timedOut);
        SyncedInt syncedInt = this._numOutstanding;
        synchronized (syncedInt) {
            this._numOutstanding.notifyAll();
        }
        this.updateTableDisplay();
    }

    public void processCallback_test(SnmpPeer node, SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpVarBind vb = pdu.getVariables().getVb(0);
        int[] oid = vb.getOid().getValue();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        int[] firstOid = this.getFirstOid(sw);
        if (firstOid != null && oid.length >= firstOid.length) {
            SnmpOID index = new SnmpOID(oid, firstOid.length, oid.length - firstOid.length);
            if (this._state == 5) {
                this.processSetCallback(node, session, reqid, pdu, timedOut);
            } else if (this._state == 2) {
                this.addElement(pdu.getVariables(), node, index);
            } else if (this._state == 1) {
                this.addCallbackRow(pdu, node, index, this._state);
            } else if (this._state == 6) {
                if (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state)) {
                    this.updateCols(pdu.getVariables(), node);
                }
            } else if (this._state == 3) {
                if (!this._validateVbl || this._validateVbl && (this._validateGETEntireVbl || this.validateVbl(node, pdu.getVariables(), this._state))) {
                    this.addElements(pdu.getVariables(), node, index);
                }
            } else if (!this.isEnd(node, firstOid, vb, index.getValue(), reqid) && (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state))) {
                this.processGetBulk(pdu.getVariables(), node, index);
            }
        }
    }
}

