/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmPsmPortEnforceTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class SmPsmDiffTableModel
extends SmPsmPortEnforceTableModel
implements ItemListener {
    JPanel _newToolbar;
    JPanel _actPanel;
    JLabel _compareWith;
    RadioButtonPanel _diffType;
    int _psmType;
    static final int[] _cpsmPortBindDiffConfigDbOid = MibNode.get("cpsmPortBindDiffConfigDb").getOid();
    static final int[] _cpsmFabricBindDiffConfigDbOid = MibNode.get("cpsmFabricBindDiffConfigDb").getOid();
    static final int[] _cdpvmDiffConfigOid = MibNode.get("cdpvmDiffConfig").getOid();
    public static final int PSM_TYPE_PORT = 1;
    public static final int PSM_TYPE_FABRIC = 2;
    public static final int DPVM_PORT = 3;
    static final int COMPARE_WITH_ACTIVE_AS_BASE = 1;
    static final int COMPARE_WITH_CFG_AS_BASE = 2;
    int _diffTypeVal = 1;

    public SmPsmDiffTableModel(int vsanId) {
        this(vsanId, 1);
    }

    public SmPsmDiffTableModel(Vsan vsan) {
        this(vsan, 1);
    }

    public SmPsmDiffTableModel(Vsan vsan, int psmType) {
        super(vsan);
        this.initTM(psmType);
    }

    public SmPsmDiffTableModel(int vsanId, int psmType) {
        super(vsanId);
        this.initTM(psmType);
    }

    private void initTM(int psmType) {
        this._psmType = psmType;
        DataView dataView = BrowserFrame.getDataView();
        this._actPanel = new JPanel(new FlowLayout(0, 2, 2));
        Object[] choices = new String[]{"Active", "Config"};
        this._diffType = new RadioButtonPanel(choices);
        this._diffType.addChangeListener(this);
        this._compareWith = new JLabel("Compare With: ");
        FieldPanel panel = new FieldPanel((JComponent)this._compareWith, (JComponent)this._diffType, null);
        this._actPanel.add(panel);
        JPanel _newToolbar = new JPanel(new FlowLayout(2, 2, 2));
        _newToolbar.add(this._actPanel);
        _newToolbar.add(dataView.getDefaultButtonPanel());
        dataView.replaceButtonPanel(_newToolbar);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        if (nodes == null) {
            return null;
        }
        this.setDiffTypes(this.getWrkingPeers(), this._diffTypeVal);
        return super.getTableVars(nodes);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        if (this._psmType == 1) {
            return super.addElement(vbl, node, index);
        }
        return super.addElementDefault(vbl, node, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDiffTypes(SnmpPeer[] nodes, int diffType) throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] diffOid = null;
        diffOid = this._psmType == 1 ? _cpsmPortBindDiffConfigDbOid : (this._psmType == 2 ? _cpsmFabricBindDiffConfigDbOid : _cdpvmDiffConfigOid);
        vbl.add(new SnmpVarBind(new SnmpOID(diffOid, this.getIndex()), new SnmpInt(diffType)));
        this._state = 5;
        this._firstOid = this._psmType == 1 ? _cpsmPortBindDiffConfigDbOid : _cpsmFabricBindDiffConfigDbOid;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < nodes.length; ++i) {
                SnmpPDU pdu = new SnmpPDU(-93, vbl);
                pdu.setIgnoreSetCount(true);
                nodes[i].send(pdu, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        char c = ((JToggleButton)e.getSource()).getText().charAt(0);
        this._diffTypeVal = c == 'A' ? 1 : 2;
        try {
            this.setDiffTypes(this.getWrkingPeers(), this._diffTypeVal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BrowserFrame.getDataView().refresh();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._diffType != null) {
            this._compareWith.setVisible(false);
            this._diffType.setVisible(false);
        }
    }
}

