/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmPsmPortEnforceTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.util.HashMap;

public class SmPsmPortBindTableModel
extends SmPsmPortEnforceTableModel {
    static final int[] _cpsmPortBindLoginPointOid = MibNode.get("cpsmPortBindLoginPoint").getOid();
    static final int[] _cpsmPortBindLoginPointTypeOid = MibNode.get("cpsmPortBindLoginPointType").getOid();
    HashMap _peer2LastPortBindIndex = new HashMap();

    public SmPsmPortBindTableModel(int vsanId) {
        super(vsanId);
    }

    public SmPsmPortBindTableModel(Vsan vsan) {
        super(vsan);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2LastPortBindIndex.clear();
        return super.getTableVars(nodes);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        int portBindIndex = index.getValue()[2];
        this._peer2LastPortBindIndex.put(node, new Integer(portBindIndex));
        return row;
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        if (changedCellOid.startsWith(_cpsmPortBindLoginPointOid)) {
            String cellVal = (String)this.getValueAt(cell._row, cell._col);
            SnmpPeer node = this.getRowPeer(cell._row);
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            int ifIndex = sw.nameToIfIndex(cellVal);
            byte[] b = new byte[4];
            b[3] = (byte)(ifIndex & 0xFF);
            b[2] = (byte)(ifIndex >> 8 & 0xFF);
            b[1] = (byte)(ifIndex >> 16 & 0xFF);
            b[0] = (byte)(ifIndex >> 24 & 0xFF);
            SnmpString changedCellVar = new SnmpString(b);
            pdu.addVar(new SnmpOID(_cpsmPortBindLoginPointTypeOid, index), new SnmpInt(2));
            pdu.addVar(new SnmpOID(_cpsmPortBindLoginPointOid, index), changedCellVar);
            return changedCellVar;
        }
        return super.processChangedCell(cell, pdu, changedCellOid, index);
    }

    public int getLastPortBindIndex(SnmpPeer node) {
        Integer lastIndexObj = (Integer)this._peer2LastPortBindIndex.get(node);
        return lastIndexObj != null ? lastIndexObj : 0;
    }
}

