/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;

public class SmSmartZoningTableModel
extends SmTableModel
implements ActionListener {
    HashMap _peers2RowInfo = new HashMap();
    HashMap _peers2RowsGetStatus;
    Array _actionChangedCells;
    protected Timer _statusTimer = new Timer(5000, this);
    static final int OP_STATUS_COL = 2;
    static final int ACTION_COL = 3;
    static final int LASTACTION_COL = 4;
    static final int ACTION_STATUS_COL = 5;
    static final int FAILURE_REASON_COL = 6;
    static final int[] _czsszSmartZoningActionOid = MibNode.get("czsszSmartZoningAction").getOid();
    static final int STATUS_POLLING_MIB_SIZE = 3;
    static final int[] _cfcFeatureCtrlLastActionResultOid = MibNode.get("czsszSmartZoningActionResult").getOid();
    static final int[] _cfcFeatureCtrlLastFailureReasonOid = MibNode.get("czsszSmartZoningFailureReason").getOid();
    static final int[] _cfcFeatureCtrlOpStatusOid = MibNode.get("czsszSmartZoningOpStatus").getOid();
    static final int DISABLE_FEATURE = 3;
    static final int ENABLE_FEATURE = 2;
    static final int FEATURE_ENABLED = 2;
    static final int ACTION_RESULT_INPROGRESS = 4;

    public SmSmartZoningTableModel() {
        this._peers2RowsGetStatus = new HashMap();
        this._actionChangedCells = new Array();
    }

    @Override
    protected void setSpecialAttr() {
        SmTableModel.SmTableModelCellChecker[] checkers = new SmTableModel.SmTableModelCellChecker[1];
        String mibName = "cfcFeatureCtrlAction";
        int[] value = new int[]{3};
        String warningMsgVsanId = "Disabling the feature will remove its configuration. Continue?";
        checkers[0] = new SmTableModel.SmTableModelCellChecker(this, mibName, value, warningMsgVsanId, false);
        this.setCellChecker(checkers);
    }

    @Override
    protected int[] getIndex(SnmpPeer node) {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        if (mgmtDomain instanceof Vsan) {
            int indx = mgmtDomain.getVsanId();
            return new int[]{indx - 1};
        }
        DefaultLogger._DefLogger.error((Object)"Smart-Zoning: Management Domain should be VSAN");
        return new int[0];
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        String failureReason = row[6].toString();
        if (failureReason != null && !failureReason.equals("")) {
            row[5] = row[5].toString() + " - " + failureReason;
        }
        return row;
    }

    @Override
    public boolean applyChanges() throws Exception {
        if (this._peers2RowsGetStatus.size() != 0) {
            return false;
        }
        Array cells = super.getChanged();
        if (cells == null) {
            return false;
        }
        this._peers2RowsGetStatus.clear();
        this._actionChangedCells.clear();
        boolean rtnVal = super.applyChanges(this);
        if (rtnVal && this._peers2RowsGetStatus.size() != 0) {
            this._statusTimer.start();
        }
        return rtnVal;
    }

    @Override
    protected Array getChangeCells() {
        if (this._actionChangedCells.size() == 0) {
            return super.getChangeCells();
        }
        return this._actionChangedCells;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 3) {
            int changedRowInThisCol = -1;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.isChanged(i, col)) continue;
                changedRowInThisCol = i;
                break;
            }
            return changedRowInThisCol == -1 || changedRowInThisCol == row;
        }
        return super.isCellEditable(row, col);
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells;
        HashMap pdus = super.buildSendPdus();
        if (pdus != null && (cells = super.getChanged()) != null) {
            for (int i = 0; i < cells.size(); ++i) {
                Cell cell = (Cell)cells.elementAt(i);
                this._actionChangedCells.addElement(new Cell(cell._row, 3));
                SnmpPeer peer = this.getRowPeer(cell._row);
                this._peers2RowInfo.clear();
                this._peers2RowInfo.put(peer, new Integer(cell._row));
            }
            this.fireTableDataChanged();
        }
        return pdus;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._peers2RowsGetStatus.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
            this.resetChanges(false);
            BrowserFrame.getInstance();
            BrowserFrame.getDataView().refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        this._state = 1;
        boolean requestSent = false;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Object object = this._peers2RowsGetStatus;
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowsGetStatus.keySet()) {
                Array rowIndices = (Array)this._peers2RowsGetStatus.get(peer);
                if (rowIndices == null) continue;
                VarBindList vbl = new VarBindList();
                for (int i = 0; i < rowIndices.size(); ++i) {
                    int[] index = ((SnmpOID)rowIndices.elementAt(i)).getValue();
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastActionResultOid, index)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastFailureReasonOid, index)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlOpStatusOid, index)));
                }
                peers2Vbl.put(peer, vbl);
            }
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                VarBindList vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpPDU pdu = new SnmpPDU(-96, vbl);
                pdu.setRetries(0);
                try {
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object vbl;
        if (this._state == 3) {
            super.callback(session, reqid, pdu, timedOut);
            return;
        }
        if (this._state == 5) {
            return;
        }
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(peer, pdu, timedOut) && pdu.getVariables().size() > 0) {
            vbl = pdu.getVariables();
            for (int i = 0; i < ((VarBindList)vbl).size(); i += 3) {
                SnmpVarBind vb = ((VarBindList)vbl).getVb(i);
                int actionResult = ((VarBindList)vbl).intValue(i);
                int[] oid = vb.getOid().getValue();
                SnmpOID index = new SnmpOID(oid, _cfcFeatureCtrlLastActionResultOid.length, oid.length - _cfcFeatureCtrlLastActionResultOid.length);
                Integer rowNum = (Integer)this._peers2RowInfo.get(peer);
                if (rowNum != null) {
                    int rowNumInt = rowNum;
                    Object[] row = (Object[])this.getData().elementAt(rowNumInt);
                    String strLastActionResult = MibEnum.getLabel(MibNode.get("czsszSmartZoningActionResult").getEnums(), actionResult);
                    String failureReason = ((VarBindList)vbl).stringValue(i + 1);
                    row[5] = strLastActionResult + (failureReason != null && !failureReason.equals("") ? " - " + failureReason : "");
                    row[2] = MibEnum.getLabel(MibNode.get("czsszSmartZoningOpStatus").getEnums(), ((VarBindList)vbl).intValue(i + 2));
                    BrowserFrame.getInstance();
                    BrowserFrame.getDataView()._table.calcPreferredSize();
                }
                if (actionResult == 4) continue;
                HashMap hashMap = this._peers2RowsGetStatus;
                synchronized (hashMap) {
                    this._peers2RowsGetStatus.remove(peer);
                    continue;
                }
            }
        } else {
            vbl = this._peers2RowsGetStatus;
            synchronized (vbl) {
                this._peers2RowsGetStatus.remove(peer);
            }
        }
        this.fireTableDataChanged();
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                vbl = this._numOutstanding;
                synchronized (vbl) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (err.length() != 0) {
            return;
        }
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        Array<SnmpOID> rowIndices = (Array<SnmpOID>)this._peers2RowsGetStatus.get(node);
        if (rowIndices == null) {
            rowIndices = new Array<SnmpOID>();
            HashMap hashMap = this._peers2RowsGetStatus;
            synchronized (hashMap) {
                this._peers2RowsGetStatus.put(node, rowIndices);
            }
        }
        VarBindList vbl = pdu.getVariables();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            SnmpOID index = new SnmpOID(oid, _czsszSmartZoningActionOid.length, oid.length - _czsszSmartZoningActionOid.length);
            rowIndices.addElement(index);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
    }
}

