/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmSmeIntfInterfacesTableModel
extends SmTableModel {
    static final int COL_SPEED_ADMIN = 5;
    protected int _smeTimeout = -1;
    static final String VER_STR_5_2_6 = "5.2(6)";

    public SmSmeIntfInterfacesTableModel() {
        BrowserFrame.getInstance();
        BrowserFrame.getDataView()._table.setSelectionMode(0);
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        this.setEditable(5, false);
    }

    @Override
    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        SnmpPDU newPdu = super.processDeleteRow(node, pdu, rowN);
        if (this.isVersionGreaterThanEqual(node, VER_STR_5_2_6)) {
            this._smeTimeout = 60000;
            newPdu.setTimeout(this._smeTimeout);
        }
        return newPdu;
    }

    @Override
    protected SnmpAggregrate getDeleteSnmpAggregrate() {
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        if (this._smeTimeout != -1) {
            aggregrate.setTimeOut(this._smeTimeout);
        }
        return aggregrate;
    }

    protected boolean isVersionGreaterThanEqual(SnmpPeer node, String ver) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        return sw.isVersionGreaterThanEqual(ver);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        BrowserFrame.getInstance();
        BrowserFrame.getDataView()._table.setSelectionMode(2);
    }
}

