/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.util.HashMap;

public class SmTargetSecurityTableModel
extends SmTableModel {
    @Override
    public boolean applyChanges() throws Exception {
        String strErr;
        Array cells = this.getChanged();
        if (cells == null) {
            return false;
        }
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        HashMap<SnmpPeer, SnmpPDU> pdusNotInService = new HashMap<SnmpPeer, SnmpPDU>();
        HashMap<SnmpPeer, SnmpPDU> pdusActive = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            int[] index = this.getIndex(cell._row);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
            SnmpVar changedCellVar = this.getChangedCell(cell._row, cell._col);
            pdu.addVar(oid, changedCellVar);
            SnmpPDU pduNotInService = (SnmpPDU)pdusNotInService.get(node);
            if (pduNotInService == null) {
                pduNotInService = new SnmpPDU(-93, new VarBindList());
                pduNotInService.setAddress(node.getAddress());
                pdusNotInService.put(node, pduNotInService);
            }
            SnmpVarBind statusNotInService = new SnmpVarBind(new SnmpOID(MibNode.get("snmpTargetParamsRowStatus").getOid(), index), new SnmpInt(2));
            pduNotInService.addVar(statusNotInService);
            SnmpPDU pduActive = (SnmpPDU)pdusActive.get(node);
            if (pduActive == null) {
                pduActive = new SnmpPDU(-93, new VarBindList());
                pduActive.setAddress(node.getAddress());
                pdusActive.put(node, pduActive);
            }
            SnmpVarBind statusActive = new SnmpVarBind(new SnmpOID(MibNode.get("snmpTargetParamsRowStatus").getOid(), index), new SnmpInt(1));
            pduActive.addVar(statusActive);
        }
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        int successfulSetsNotInService = aggregrate.set(pdusNotInService.keySet().iterator(), pdusNotInService.values().iterator());
        aggregrate = new SnmpAggregrate();
        int successfulSets = aggregrate.set(pdus.keySet().iterator(), pdus.values().iterator());
        aggregrate = new SnmpAggregrate();
        int successfulSetsActive = aggregrate.set(pdusActive.keySet().iterator(), pdusActive.values().iterator());
        if (successfulSetsNotInService < pdusNotInService.size()) {
            strErr = "Succeeded on " + successfulSetsNotInService + " of " + pdusNotInService.size() + " device(s) while setting snmpTargetParamsRowStatus to NotInService.\r\n";
            this._setErrMsg.addElement(strErr);
        }
        if (successfulSets < pdus.size()) {
            strErr = "Succeeded on " + successfulSets + " of " + pdus.size() + " device(s).  See log for details.";
            this._setErrMsg.addElement(strErr);
        }
        if (successfulSetsActive < pdusActive.size()) {
            strErr = "Succeeded on " + successfulSetsActive + " of " + pdusActive.size() + " device(s) while setting snmpTargetParamsRowStatus to Active.\r\n";
            this._setErrMsg.addElement(strErr);
        }
        return true;
    }
}

